/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiScoreMapper;
import com.els.base.performance.entity.KpiScore;
import com.els.base.performance.entity.KpiScoreExample;
import com.els.base.performance.service.KpiScoreService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultKpiScoreService")
public class KpiScoreServiceImpl
implements KpiScoreService {
    @Resource
    protected KpiScoreMapper kpiScoreMapper;

    @CacheEvict(value={"kpiScore"}, allEntries=true)
    public void addObj(KpiScore t) {
        this.kpiScoreMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"kpiScore"}, allEntries=true)
    public void addAll(List<KpiScore> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.kpiScoreMapper.insertBatch(list);
    }

    @CacheEvict(value={"kpiScore"}, allEntries=true)
    public void deleteObjById(String id) {
        this.kpiScoreMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"kpiScore"}, allEntries=true)
    public void deleteByExample(KpiScoreExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.kpiScoreMapper.deleteByExample(example);
    }

    @CacheEvict(value={"kpiScore"}, allEntries=true)
    public void modifyObj(KpiScore t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.kpiScoreMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"kpiScore"}, keyGenerator="redisKeyGenerator")
    public KpiScore queryObjById(String id) {
        return this.kpiScoreMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"kpiScore"}, keyGenerator="redisKeyGenerator")
    public List<KpiScore> queryAllObjByExample(KpiScoreExample example) {
        return this.kpiScoreMapper.selectByExample(example);
    }

    @Cacheable(value={"kpiScore"}, keyGenerator="redisKeyGenerator")
    public PageView<KpiScore> queryObjByPage(KpiScoreExample example) {
        PageView<KpiScore> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiScoreMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public int queryDeliveryRateTimely(String fromCode, String supCompanySapCode) {
        return this.kpiScoreMapper.selectDeliveryRateTimely(fromCode, supCompanySapCode);
    }

    @Override
    public int queryDeliveryRateTotal(String fromCode, String supCompanySapCode) {
        return this.kpiScoreMapper.selectDeliveryRateTotal(fromCode, supCompanySapCode);
    }

    @Override
    public int queryQualityRateStandard(String fromCode, String supCompanySapCode, Integer parameter) {
        return this.kpiScoreMapper.selectQualityRateStandard(fromCode, supCompanySapCode);
    }

    @Override
    public int queryQualityRateStandardOutNCR(String fromCode, String supCompanySapCode, Integer parameter) {
        return this.kpiScoreMapper.selectQualityRateStandard(fromCode, supCompanySapCode) - this.kpiScoreMapper.selectQualityRateStandardOutNCR(fromCode, supCompanySapCode);
    }

    @Override
    public int queryQualityRateTotal(String fromCode, String supCompanySapCode, Integer parameter) {
        return this.kpiScoreMapper.selectQualityRateTotal(fromCode, supCompanySapCode);
    }
}

