/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiServiceFormMapper;
import com.els.base.performance.entity.KpiDeliveryRate;
import com.els.base.performance.entity.KpiDeliveryRateExample;
import com.els.base.performance.entity.KpiService;
import com.els.base.performance.entity.KpiServiceExample;
import com.els.base.performance.entity.KpiServiceForm;
import com.els.base.performance.entity.KpiServiceFormExample;
import com.els.base.performance.enums.KpiServiceFormStatus;
import com.els.base.performance.service.KpiDeliveryRateService;
import com.els.base.performance.service.KpiServiceFormService;
import com.els.base.performance.service.KpiServiceService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultKpiServiceFormService")
public class KpiServiceFormServiceImpl
implements KpiServiceFormService {
    @Resource
    protected KpiServiceFormMapper kpiServiceFormMapper;
    @Resource
    protected KpiServiceService kpiServiceService;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected CompanyPurRefService companyPurRefService;
    @Resource
    protected KpiDeliveryRateService kpiDeliveryRateService;

    @CacheEvict(value={"kpiServiceForm", "kpiService"}, allEntries=true)
    @Transactional
    public void addObj(KpiServiceForm t) {
        String formCode = this.generateCodeService.getNextCode("KPI_SERVICRE_FORM");
        t.setFormNo(formCode);
        t.setId(UUIDGenerator.generateUUID());
        t.setCreateTime(new Date());
        t.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        t.setCreateUserName(SpringSecurityUtils.getLoginUserName());
        t.setUpdateTime(new Date());
        t.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        t.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        t.setFormStatus(KpiServiceFormStatus.NEW.getValue());
        this.kpiServiceFormMapper.insertSelective(t);
        List<KpiService> kpiServices = t.getKpiServiceList();
        for (KpiService kpiService : kpiServices) {
            kpiService.setFormId(t.getId());
            kpiService.setFormNo(formCode);
            kpiService.setYear(t.getYear());
            kpiService.setMonth(t.getMonth());
            kpiService.setStatus(KpiServiceFormStatus.NEW.getValue());
            kpiService.setCreateTime(new Date());
            kpiService.setCreateUserId(SpringSecurityUtils.getLoginUserId());
            kpiService.setCreateUserName(SpringSecurityUtils.getLoginUserName());
            kpiService.setUpdateTime(new Date());
            kpiService.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            kpiService.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            KpiDeliveryRateExample example = new KpiDeliveryRateExample();
            example.createCriteria().andMonthEqualTo(kpiService.getMonth()).andYearEqualTo(kpiService.getYear()).andSupCompanySapCodeEqualTo(kpiService.getSupCompanySapCode());
            List kpiDeliveryRates = this.kpiDeliveryRateService.queryAllObjByExample((IExample)example);
            if (!CollectionUtils.isNotEmpty((Collection)kpiDeliveryRates)) continue;
            kpiService.setCategory(((KpiDeliveryRate)kpiDeliveryRates.get(0)).getCategory());
            kpiService.setImportantFlag(((KpiDeliveryRate)kpiDeliveryRates.get(0)).getImportantFlag());
            kpiService.setSalesMan(((KpiDeliveryRate)kpiDeliveryRates.get(0)).getSalesMan());
            kpiService.setDevelopmentManager(((KpiDeliveryRate)kpiDeliveryRates.get(0)).getDevelopmentManager());
        }
        this.kpiServiceService.addAll(kpiServices);
    }

    @Transactional
    @CacheEvict(value={"kpiServiceForm"}, allEntries=true)
    public void addAll(List<KpiServiceForm> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.kpiServiceFormMapper.insertBatch(list);
    }

    @CacheEvict(value={"kpiServiceForm"}, allEntries=true)
    public void deleteObjById(String id) {
        this.kpiServiceFormMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"kpiServiceForm"}, allEntries=true)
    public void deleteByExample(KpiServiceFormExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.kpiServiceFormMapper.deleteByExample(example);
    }

    @CacheEvict(value={"kpiServiceForm"}, allEntries=true)
    public void modifyObj(KpiServiceForm t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.kpiServiceFormMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"kpiServiceForm"}, keyGenerator="redisKeyGenerator")
    public KpiServiceForm queryObjById(String id) {
        return this.kpiServiceFormMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"kpiServiceForm"}, keyGenerator="redisKeyGenerator")
    public List<KpiServiceForm> queryAllObjByExample(KpiServiceFormExample example) {
        return this.kpiServiceFormMapper.selectByExample(example);
    }

    @Cacheable(value={"kpiServiceForm"}, keyGenerator="redisKeyGenerator")
    public PageView<KpiServiceForm> queryObjByPage(KpiServiceFormExample example) {
        PageView<KpiServiceForm> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiServiceFormMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"kpiServiceForm", "kpiService"}, allEntries=true)
    @Transactional
    public void deleteByIdArray(List<String> list) {
        for (String id : list) {
            this.deleteObjById(id);
            KpiServiceExample example = new KpiServiceExample();
            example.createCriteria().andFormIdEqualTo(id);
            this.kpiServiceService.deleteByExample((IExample)example);
        }
    }

    @Override
    @CacheEvict(value={"kpiServiceForm", "kpiService"}, allEntries=true)
    @Transactional
    public void publishByIds(List<String> list) {
        for (String id : list) {
            KpiServiceForm form = this.queryObjById(id);
            form.setFormStatus(KpiServiceFormStatus.PUBLIC.getValue());
            form.setUpdateTime(new Date());
            form.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            form.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            this.modifyObj(form);
            KpiServiceExample example = new KpiServiceExample();
            example.createCriteria().andFormIdEqualTo(id);
            List kpiServices = this.kpiServiceService.queryAllObjByExample((IExample)example);
            for (KpiService kpiService : kpiServices) {
                kpiService.setStatus(KpiServiceFormStatus.PUBLIC.getValue());
                kpiService.setUpdateTime(new Date());
                kpiService.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
                kpiService.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
                this.kpiServiceService.modifyObj(kpiService);
            }
        }
    }

    @Override
    @CacheEvict(value={"kpiServiceForm", "kpiService"}, allEntries=true)
    @Transactional
    public void invalidByIds(List<String> list) {
        for (String id : list) {
            KpiServiceForm form = this.queryObjById(id);
            form.setFormStatus(KpiServiceFormStatus.INVAILD.getValue());
            form.setUpdateTime(new Date());
            form.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            form.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            this.modifyObj(form);
            KpiServiceExample example = new KpiServiceExample();
            example.createCriteria().andFormIdEqualTo(id);
            List kpiServices = this.kpiServiceService.queryAllObjByExample((IExample)example);
            for (KpiService kpiService : kpiServices) {
                kpiService.setStatus(KpiServiceFormStatus.INVAILD.getValue());
                kpiService.setUpdateTime(new Date());
                kpiService.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
                kpiService.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
                this.kpiServiceService.modifyObj(kpiService);
            }
        }
    }

    @Override
    public KpiServiceForm viewById(String id) {
        KpiServiceForm form = this.queryObjById(id);
        KpiServiceExample example = new KpiServiceExample();
        example.createCriteria().andFormIdEqualTo(id);
        List kpiServices = this.kpiServiceService.queryAllObjByExample((IExample)example);
        form.setKpiServiceList(kpiServices);
        return form;
    }

    @Override
    public KpiServiceForm scoreById(String id) {
        List companyList = this.companyPurRefService.queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), null);
        ArrayList<String> companySapCodes = new ArrayList<String>();
        for (Company company : companyList) {
            companySapCodes.add(company.getCompanySapCode());
        }
        KpiServiceForm form = this.queryObjById(id);
        KpiServiceExample example = new KpiServiceExample();
        example.createCriteria().andFormIdEqualTo(id).andSupCompanySapCodeIn(companySapCodes);
        List kpiServices = this.kpiServiceService.queryAllObjByExample((IExample)example);
        form.setKpiServiceList(kpiServices);
        return form;
    }

    @Override
    @CacheEvict(value={"kpiServiceForm", "kpiService"}, allEntries=true)
    public void saveKpiServiceForm(KpiServiceForm kpiServiceForm) {
        KpiServiceForm serviceFormUpdate = this.queryObjById(kpiServiceForm.getId());
        serviceFormUpdate.setUpdateTime(new Date());
        serviceFormUpdate.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        serviceFormUpdate.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        serviceFormUpdate.setYear(kpiServiceForm.getYear());
        serviceFormUpdate.setMonth(kpiServiceForm.getMonth());
        serviceFormUpdate.setFormDescription(kpiServiceForm.getFormDescription());
        this.modifyObj(serviceFormUpdate);
        KpiServiceExample example = new KpiServiceExample();
        example.createCriteria().andFormIdEqualTo(kpiServiceForm.getId());
        this.kpiServiceService.deleteByExample((IExample)example);
        List<KpiService> kpiServices = kpiServiceForm.getKpiServiceList();
        for (KpiService kpiService : kpiServices) {
            kpiService.setFormId(kpiServiceForm.getId());
            kpiService.setFormNo(kpiServiceForm.getFormNo());
            kpiService.setYear(kpiServiceForm.getYear());
            kpiService.setMonth(kpiServiceForm.getMonth());
            kpiService.setStatus(KpiServiceFormStatus.NEW.getValue());
            kpiService.setCreateTime(new Date());
            kpiService.setCreateUserId(SpringSecurityUtils.getLoginUserId());
            kpiService.setCreateUserName(SpringSecurityUtils.getLoginUserName());
            kpiService.setUpdateTime(new Date());
            kpiService.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            kpiService.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        }
        this.kpiServiceService.addAll(kpiServices);
    }
}

