/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiServiceMapper;
import com.els.base.performance.entity.KpiDeliveryRate;
import com.els.base.performance.entity.KpiDeliveryRateExample;
import com.els.base.performance.entity.KpiOriginalExport;
import com.els.base.performance.entity.KpiOriginalExportExample;
import com.els.base.performance.entity.KpiService;
import com.els.base.performance.entity.KpiServiceExample;
import com.els.base.performance.entity.KpiServiceForm;
import com.els.base.performance.enums.KpiServiceFormStatus;
import com.els.base.performance.service.KpiDeliveryRateService;
import com.els.base.performance.service.KpiServiceFormService;
import com.els.base.performance.service.KpiServiceService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultKpiServiceService")
public class KpiServiceServiceImpl
implements KpiServiceService {
    @Resource
    protected KpiServiceMapper kpiServiceMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected KpiServiceFormService kpiServiceFormService;
    @Resource
    protected KpiDeliveryRateService kpiDeliveryRateService;

    @CacheEvict(value={"kpiService"}, allEntries=true)
    public void addObj(KpiService t) {
        this.kpiServiceMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"kpiService"}, allEntries=true)
    public void addAll(List<KpiService> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.kpiServiceMapper.insertBatch(list);
    }

    @CacheEvict(value={"kpiService"}, allEntries=true)
    public void deleteObjById(String id) {
        this.kpiServiceMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"kpiService"}, allEntries=true)
    public void deleteByExample(KpiServiceExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.kpiServiceMapper.deleteByExample(example);
    }

    @CacheEvict(value={"kpiService"}, allEntries=true)
    public void modifyObj(KpiService t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.kpiServiceMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"kpiService"}, keyGenerator="redisKeyGenerator")
    public KpiService queryObjById(String id) {
        return this.kpiServiceMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"kpiService"}, keyGenerator="redisKeyGenerator")
    public List<KpiService> queryAllObjByExample(KpiServiceExample example) {
        return this.kpiServiceMapper.selectByExample(example);
    }

    @Cacheable(value={"kpiService"}, keyGenerator="redisKeyGenerator")
    public PageView<KpiService> queryObjByPage(KpiServiceExample example) {
        PageView<KpiService> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiServiceMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"kpiService"}, allEntries=true)
    @Transactional
    public void AddSupplerByIds(List<String> list, String FormId) {
        ArrayList<KpiService> kpiServices = new ArrayList<KpiService>();
        for (String companyId : list) {
            Company company = (Company)this.companyService.queryObjById((Object)companyId);
            KpiServiceForm kpiServiceForm = (KpiServiceForm)this.kpiServiceFormService.queryObjById(companyId);
            KpiService kpiService = new KpiService();
            kpiService.setId(UUIDGenerator.generateUUID());
            kpiService.setFormId(kpiServiceForm.getId());
            kpiService.setFormNo(kpiServiceForm.getFormNo());
            kpiService.setStatus(kpiServiceForm.getFormStatus());
            kpiService.setSupCompanyName(company.getCompanyName());
            kpiService.setSupCompanySapCode(company.getCompanySapCode());
            kpiService.setSupCompanySrmCode(company.getCompanyCode());
            kpiService.setCreateTime(new Date());
            kpiService.setCreateUserId(SpringSecurityUtils.getLoginUserId());
            kpiService.setCreateUserName(SpringSecurityUtils.getLoginUserName());
            kpiService.setUpdateTime(new Date());
            kpiService.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            kpiService.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            kpiService.setYear(kpiServiceForm.getYear());
            kpiService.setMonth(kpiServiceForm.getMonth());
            KpiDeliveryRateExample example = new KpiDeliveryRateExample();
            example.createCriteria().andMonthEqualTo(kpiService.getMonth()).andYearEqualTo(kpiService.getYear()).andSupCompanySapCodeEqualTo(kpiService.getSupCompanySapCode());
            List kpiDeliveryRates = this.kpiDeliveryRateService.queryAllObjByExample((IExample)example);
            if (CollectionUtils.isNotEmpty((Collection)kpiDeliveryRates)) {
                kpiService.setSalesMan(((KpiDeliveryRate)kpiDeliveryRates.get(0)).getSalesMan());
                kpiService.setDevelopmentManager(((KpiDeliveryRate)kpiDeliveryRates.get(0)).getDevelopmentManager());
            }
            kpiServices.add(kpiService);
        }
        if (CollectionUtils.isNotEmpty(kpiServices)) {
            this.kpiServiceMapper.insertBatch(kpiServices);
        }
    }

    @Override
    @CacheEvict(value={"kpiService"}, allEntries=true)
    @Transactional
    public void saveScore(List<KpiService> kpiServiceList) {
        for (KpiService kpiService : kpiServiceList) {
            if (kpiService.getLaterCount() != null) {
                Assert.isNotNull((Object)kpiService.getScore(), (String)String.format("\u4f9b\u5e94\u5546[%s]\u7684\u670d\u52a1\u5206\u6570\u4e0d\u80fd\u4e3a\u7a7a", kpiService.getSupCompanyName()));
            }
            if (kpiService.getScore() != null) {
                Assert.isNotNull((Object)kpiService.getLaterCount(), (String)String.format("\u4f9b\u5e94\u5546[%s]\u7684\u4e0d\u53ca\u65f6\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a", kpiService.getSupCompanyName()));
            }
            if (kpiService.getScore() == null && kpiService.getLaterCount() == null) continue;
            KpiService kpiServiceUpdate = this.queryObjById(kpiService.getId());
            kpiServiceUpdate.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            kpiServiceUpdate.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            kpiServiceUpdate.setUpdateTime(new Date());
            kpiServiceUpdate.setLaterCount(kpiService.getLaterCount());
            kpiServiceUpdate.setScore(kpiService.getScore());
            kpiService.setScoreStatus(1);
            this.modifyObj(kpiService);
        }
    }

    @Override
    @CacheEvict(value={"kpiService"}, allEntries=true)
    @Transactional
    public void submitScore(List<KpiService> kpiServiceList) {
        for (KpiService kpiService2 : kpiServiceList) {
            Assert.isNotNull((Object)kpiService2.getLaterCount(), (String)String.format("\u4f9b\u5e94\u5546[%s]\u7684\u4e0d\u53ca\u65f6\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a", kpiService2.getSupCompanyName()));
            Assert.isNotNull((Object)kpiService2.getScore(), (String)String.format("\u4f9b\u5e94\u5546[%s]\u7684\u670d\u52a1\u5206\u6570\u4e0d\u80fd\u4e3a\u7a7a", kpiService2.getSupCompanyName()));
            KpiService kpiServiceUpdate = this.queryObjById(kpiService2.getId());
            kpiServiceUpdate.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            kpiServiceUpdate.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            kpiServiceUpdate.setUpdateTime(new Date());
            kpiServiceUpdate.setLaterCount(kpiService2.getLaterCount());
            kpiServiceUpdate.setScore(kpiService2.getScore());
            kpiService2.setScoreStatus(2);
            kpiService2.setStatus(KpiServiceFormStatus.CONFIRM.getValue());
            this.modifyObj(kpiService2);
        }
        KpiServiceExample example = new KpiServiceExample();
        example.createCriteria().andFormIdEqualTo(kpiServiceList.get(0).getFormId());
        List<KpiService> kpiServiceList1 = this.queryAllObjByExample(example);
        Assert.isNotEmpty(kpiServiceList1, (String)"\u6570\u636e\u5f02\u5e38\uff0c\u8bc4\u4f30\u8868\u4e0e\u8bc4\u4f30\u7ed3\u679c\u5173\u8054\u51fa\u5f02\u5e38");
        List inVaildKpiService = kpiServiceList1.stream().filter(kpiService -> Integer.valueOf(2).equals(kpiService.getScoreStatus()) || kpiService.getScore() == null || kpiService.getLaterCount() == null).map(KpiService::getSupCompanyName).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(inVaildKpiService)) {
            throw new CommonException(String.format("\u4ee5\u4e0b\u4f9b\u5e94\u5546\u672a\u8bc4\u5206\uff0c\u8bf7\u66f4\u65b0\u6570\u636e\u540e\u91cd\u8bd5: %s", StringUtils.join(inVaildKpiService, (String)",")));
        }
        KpiServiceForm form = (KpiServiceForm)this.kpiServiceFormService.queryObjById(kpiServiceList.get(0).getFormId());
        form.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        form.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        form.setUpdateTime(new Date());
        form.setFormStatus(KpiServiceFormStatus.CONFIRM.getValue());
        this.kpiServiceFormService.modifyObj(form);
    }

    @Override
    @Cacheable(value={"kpiOriginalExport"}, keyGenerator="redisKeyGenerator")
    public PageView<KpiOriginalExport> queryReportObjByPage(KpiOriginalExportExample example) {
        PageView<KpiOriginalExport> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiServiceMapper.selectReportByExampleByPage(example));
        return pageView;
    }

    @Override
    public List<KpiOriginalExport> queryReportAllObjByExample(KpiOriginalExportExample example) {
        return this.kpiServiceMapper.selectReportByExample(example);
    }

    @Override
    @CacheEvict(value={"kpiService"}, allEntries=true)
    @Transactional
    public void importScore(List<KpiService> kpiServiceList) {
        for (KpiService kpiService : kpiServiceList) {
            KpiServiceExample example = new KpiServiceExample();
            example.createCriteria().andFormIdEqualTo(kpiService.getFormId()).andSupCompanySapCodeEqualTo(kpiService.getSupCompanySapCode());
            List<KpiService> kpiServices = this.queryAllObjByExample(example);
            if (!CollectionUtils.isNotEmpty(kpiServices)) continue;
            KpiService kpiServiceUpdate = kpiServices.get(0);
            kpiServiceUpdate.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            kpiServiceUpdate.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            kpiServiceUpdate.setUpdateTime(new Date());
            kpiServiceUpdate.setLaterCount(kpiService.getLaterCount());
            kpiServiceUpdate.setScore(kpiService.getScore());
            kpiService.setScoreStatus(1);
            this.modifyObj(kpiServiceUpdate);
        }
    }
}

