/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiSupWeightRankMapper;
import com.els.base.performance.entity.KpiSupWeightRank;
import com.els.base.performance.entity.KpiSupWeightRankExample;
import com.els.base.performance.entity.KpiWeightRank;
import com.els.base.performance.entity.KpiWeightRankExample;
import com.els.base.performance.entity.vo.KpiSupWeightRankVO;
import com.els.base.performance.service.KpiSupWeightRankService;
import com.els.base.performance.service.KpiWeightRankService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultKpiSupWeightRankService")
public class KpiSupWeightRankServiceImpl
implements KpiSupWeightRankService {
    @Resource
    protected KpiSupWeightRankMapper kpiSupWeightRankMapper;
    @Resource
    protected KpiWeightRankService kpiWeightRankService;

    @CacheEvict(value={"kpiSupWeightRank"}, allEntries=true)
    public void addObj(KpiSupWeightRank t) {
        this.kpiSupWeightRankMapper.insertSelective(t);
    }

    @CacheEvict(value={"kpiSupWeightRank"}, allEntries=true)
    public void deleteObjById(String id) {
        this.kpiSupWeightRankMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"kpiSupWeightRank"}, allEntries=true)
    public void modifyObj(KpiSupWeightRank t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.kpiSupWeightRankMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"kpiSupWeightRank"}, keyGenerator="redisKeyGenerator")
    public KpiSupWeightRank queryObjById(String id) {
        return this.kpiSupWeightRankMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"kpiSupWeightRank"}, keyGenerator="redisKeyGenerator")
    public List<KpiSupWeightRank> queryAllObjByExample(KpiSupWeightRankExample example) {
        return this.kpiSupWeightRankMapper.selectByExample(example);
    }

    @Cacheable(value={"kpiSupWeightRank"}, keyGenerator="redisKeyGenerator")
    public PageView<KpiSupWeightRank> queryObjByPage(KpiSupWeightRankExample example) {
        PageView<KpiSupWeightRank> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiSupWeightRankMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"kpiSupWeightRank"}, allEntries=true)
    @Transactional
    public void addSupWeightRank(KpiSupWeightRankVO kpiSupWeightRankVO) {
        List<KpiWeightRank> kpiRank;
        kpiSupWeightRankVO.kpiSupWeightRank.setPurCompanyId(kpiSupWeightRankVO.company.getId());
        kpiSupWeightRankVO.kpiSupWeightRank.setPurCompanyCode(kpiSupWeightRankVO.company.getCompanyCode());
        kpiSupWeightRankVO.kpiSupWeightRank.setPurCompanyName(kpiSupWeightRankVO.company.getCompanyName());
        kpiSupWeightRankVO.kpiSupWeightRank.setPurUserId(kpiSupWeightRankVO.user.getId());
        kpiSupWeightRankVO.kpiSupWeightRank.setPurUserName(kpiSupWeightRankVO.user.getNickName());
        kpiSupWeightRankVO.kpiSupWeightRank.setProductClass(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass());
        kpiSupWeightRankVO.kpiSupWeightRank.setRemark(kpiSupWeightRankVO.getKpiSupWeightRank().getRemark());
        kpiSupWeightRankVO.kpiSupWeightRank.setCreateTime(new Date());
        kpiSupWeightRankVO.kpiSupWeightRank.setLastUpdateUser(kpiSupWeightRankVO.user.getNickName());
        kpiSupWeightRankVO.kpiSupWeightRank.setLastUpdateTime(new Date());
        this.kpiSupWeightRankMapper.insertSelective(kpiSupWeightRankVO.kpiSupWeightRank);
        List<KpiWeightRank> kpiWeight = kpiSupWeightRankVO.getKpiWeight();
        if (kpiWeight != null && kpiWeight.size() > 0) {
            for (KpiWeightRank weight : kpiWeight) {
                weight.setPurCompanyId(kpiSupWeightRankVO.company.getId());
                weight.setPurCompanyCode(kpiSupWeightRankVO.company.getCompanyCode());
                weight.setPurCompanyName(kpiSupWeightRankVO.company.getCompanyName());
                weight.setPurUserId(kpiSupWeightRankVO.user.getId());
                weight.setPurUserName(kpiSupWeightRankVO.user.getNickName());
                weight.setFunctionType("1");
                weight.setSupWeightRankId(kpiSupWeightRankVO.kpiSupWeightRank.getId());
                weight.setProductClass(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass());
                weight.setProjectCode(weight.getProjectCode());
                weight.setProjectName(weight.getProjectName());
                weight.setWeightValue(weight.getWeightValue());
                weight.setCreateTime(new Date());
                weight.setLastUpdateUser(kpiSupWeightRankVO.user.getNickName());
                weight.setLastUpdateTime(new Date());
                this.kpiWeightRankService.addObj(weight);
            }
        }
        if ((kpiRank = kpiSupWeightRankVO.getKpiRank()) != null && kpiRank.size() > 0) {
            for (KpiWeightRank rank : kpiRank) {
                rank.setPurCompanyId(kpiSupWeightRankVO.company.getId());
                rank.setPurCompanyCode(kpiSupWeightRankVO.company.getCompanyCode());
                rank.setPurCompanyName(kpiSupWeightRankVO.company.getCompanyName());
                rank.setPurUserId(kpiSupWeightRankVO.user.getId());
                rank.setPurUserName(kpiSupWeightRankVO.user.getNickName());
                rank.setFunctionType("2");
                rank.setSupWeightRankId(kpiSupWeightRankVO.kpiSupWeightRank.getId());
                rank.setProductClass(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass());
                rank.setProjectCode(rank.getProjectCode());
                rank.setProjectName(rank.getProjectName());
                rank.setBeginNumber(rank.getBeginNumber());
                rank.setEndNumber(rank.getEndNumber());
                rank.setCreateTime(new Date());
                rank.setLastUpdateUser(kpiSupWeightRankVO.user.getNickName());
                rank.setLastUpdateTime(new Date());
                this.kpiWeightRankService.addObj(rank);
            }
        }
    }

    @Override
    @CacheEvict(value={"kpiSupWeightRank"}, allEntries=true)
    @Transactional
    public void editSupWeightRank(KpiSupWeightRankVO kpiSupWeightRankVO) {
        KpiSupWeightRank kpiSupWeightRank = new KpiSupWeightRank();
        kpiSupWeightRank.setId(kpiSupWeightRankVO.getKpiSupWeightRank().getId());
        kpiSupWeightRank.setRemark(kpiSupWeightRankVO.getKpiSupWeightRank().getRemark());
        kpiSupWeightRankVO.kpiSupWeightRank.setLastUpdateUser(kpiSupWeightRankVO.user.getNickName());
        kpiSupWeightRankVO.kpiSupWeightRank.setLastUpdateTime(new Date());
        this.kpiSupWeightRankMapper.updateByPrimaryKeySelective(kpiSupWeightRankVO.kpiSupWeightRank);
        KpiWeightRankExample kpiWeightExample = new KpiWeightRankExample();
        KpiWeightRankExample.Criteria kpiWeightCriteria = kpiWeightExample.createCriteria();
        kpiWeightCriteria.andFunctionTypeEqualTo("1");
        kpiWeightCriteria.andSupWeightRankIdEqualTo(kpiSupWeightRankVO.kpiSupWeightRank.getId());
        kpiWeightCriteria.andProductClassEqualTo(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass());
        this.kpiWeightRankService.deleteByExample(kpiWeightExample);
        List<KpiWeightRank> kpiWeight = kpiSupWeightRankVO.getKpiWeight();
        if (kpiWeight != null && kpiWeight.size() > 0) {
            for (KpiWeightRank weight : kpiWeight) {
                weight.setPurCompanyId(kpiSupWeightRankVO.company.getId());
                weight.setPurCompanyCode(kpiSupWeightRankVO.company.getCompanyCode());
                weight.setPurCompanyName(kpiSupWeightRankVO.company.getCompanyName());
                weight.setPurUserId(kpiSupWeightRankVO.user.getId());
                weight.setPurUserName(kpiSupWeightRankVO.user.getNickName());
                weight.setFunctionType("1");
                weight.setSupWeightRankId(kpiSupWeightRankVO.kpiSupWeightRank.getId());
                weight.setProductClass(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass());
                weight.setProjectCode(weight.getProjectCode());
                weight.setProjectName(weight.getProjectName());
                weight.setWeightValue(weight.getWeightValue());
                weight.setCreateTime(new Date());
                weight.setLastUpdateUser(kpiSupWeightRankVO.user.getNickName());
                weight.setLastUpdateTime(new Date());
                this.kpiWeightRankService.addObj(weight);
            }
        }
        KpiWeightRankExample kpiRankExample = new KpiWeightRankExample();
        KpiWeightRankExample.Criteria kpiRankCriteria = kpiRankExample.createCriteria();
        kpiRankCriteria.andFunctionTypeEqualTo("2");
        kpiRankCriteria.andSupWeightRankIdEqualTo(kpiSupWeightRankVO.kpiSupWeightRank.getId());
        kpiRankCriteria.andProductClassEqualTo(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass());
        this.kpiWeightRankService.deleteByExample(kpiRankExample);
        List<KpiWeightRank> kpiRank = kpiSupWeightRankVO.getKpiRank();
        if (kpiRank != null && kpiRank.size() > 0) {
            for (KpiWeightRank rank : kpiRank) {
                rank.setPurCompanyId(kpiSupWeightRankVO.company.getId());
                rank.setPurCompanyCode(kpiSupWeightRankVO.company.getCompanyCode());
                rank.setPurCompanyName(kpiSupWeightRankVO.company.getCompanyName());
                rank.setPurUserId(kpiSupWeightRankVO.user.getId());
                rank.setPurUserName(kpiSupWeightRankVO.user.getNickName());
                rank.setFunctionType("2");
                rank.setSupWeightRankId(kpiSupWeightRankVO.kpiSupWeightRank.getId());
                rank.setProductClass(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass());
                rank.setProjectCode(rank.getProjectCode());
                rank.setProjectName(rank.getProjectName());
                rank.setBeginNumber(rank.getBeginNumber());
                rank.setEndNumber(rank.getEndNumber());
                rank.setCreateTime(new Date());
                rank.setLastUpdateUser(kpiSupWeightRankVO.user.getNickName());
                rank.setLastUpdateTime(new Date());
                this.kpiWeightRankService.addObj(rank);
            }
        }
    }

    @Override
    @CacheEvict(value={"kpiSupWeightRank"}, allEntries=true)
    @Transactional
    public void deleteSupWeightRank(KpiSupWeightRankVO kpiSupWeightRankVO) {
        this.kpiSupWeightRankMapper.deleteByPrimaryKey(kpiSupWeightRankVO.kpiSupWeightRank.getId());
        KpiWeightRankExample kpiWeightExample = new KpiWeightRankExample();
        KpiWeightRankExample.Criteria kpiWeightCriteria = kpiWeightExample.createCriteria();
        kpiWeightCriteria.andFunctionTypeEqualTo("1");
        kpiWeightCriteria.andSupWeightRankIdEqualTo(kpiSupWeightRankVO.kpiSupWeightRank.getId());
        kpiWeightCriteria.andProductClassEqualTo(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass());
        this.kpiWeightRankService.deleteByExample(kpiWeightExample);
        KpiWeightRankExample kpiRankExample = new KpiWeightRankExample();
        KpiWeightRankExample.Criteria kpiRankCriteria = kpiRankExample.createCriteria();
        kpiRankCriteria.andFunctionTypeEqualTo("2");
        kpiRankCriteria.andSupWeightRankIdEqualTo(kpiSupWeightRankVO.kpiSupWeightRank.getId());
        kpiRankCriteria.andProductClassEqualTo(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass());
        this.kpiWeightRankService.deleteByExample(kpiWeightExample);
    }

    @Transactional
    @CacheEvict(value={"kpiSupWeightRank"}, allEntries=true)
    public void addAll(List<KpiSupWeightRank> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
            this.kpiSupWeightRankMapper.insertSelective((KpiSupWeightRank)item);
        });
    }

    @CacheEvict(value={"kpiSupWeightRank"}, allEntries=true)
    public void deleteByExample(KpiSupWeightRankExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.kpiSupWeightRankMapper.deleteByExample(arg0);
    }
}

