/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiSupplierImproveMapper;
import com.els.base.performance.entity.KpiSupplierImprove;
import com.els.base.performance.entity.KpiSupplierImproveExample;
import com.els.base.performance.service.KpiSupplierImproveService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultKpiSupplierImproveService")
public class KpiSupplierImproveServiceImpl
implements KpiSupplierImproveService {
    @Resource
    protected KpiSupplierImproveMapper kpiSupplierImproveMapper;

    @CacheEvict(value={"kpiSupplierImprove"}, allEntries=true)
    public void addObj(KpiSupplierImprove t) {
        this.kpiSupplierImproveMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"kpiSupplierImprove"}, allEntries=true)
    public void addAll(List<KpiSupplierImprove> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.kpiSupplierImproveMapper.insertBatch(list);
    }

    @CacheEvict(value={"kpiSupplierImprove"}, allEntries=true)
    public void deleteObjById(String id) {
        this.kpiSupplierImproveMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"kpiSupplierImprove"}, allEntries=true)
    public void deleteByExample(KpiSupplierImproveExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.kpiSupplierImproveMapper.deleteByExample(example);
    }

    @CacheEvict(value={"kpiSupplierImprove"}, allEntries=true)
    public void modifyObj(KpiSupplierImprove t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.kpiSupplierImproveMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"kpiSupplierImprove"}, keyGenerator="redisKeyGenerator")
    public KpiSupplierImprove queryObjById(String id) {
        return this.kpiSupplierImproveMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"kpiSupplierImprove"}, keyGenerator="redisKeyGenerator")
    public List<KpiSupplierImprove> queryAllObjByExample(KpiSupplierImproveExample example) {
        return this.kpiSupplierImproveMapper.selectByExample(example);
    }

    @Cacheable(value={"kpiSupplierImprove"}, keyGenerator="redisKeyGenerator")
    public PageView<KpiSupplierImprove> queryObjByPage(KpiSupplierImproveExample example) {
        PageView<KpiSupplierImprove> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiSupplierImproveMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public int countByExample(KpiSupplierImproveExample example) {
        return this.kpiSupplierImproveMapper.countByExample(example);
    }
}

