/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.performance.dao.KpiTemplateItemMapper;
import com.els.base.performance.entity.KpiTemplateItem;
import com.els.base.performance.entity.KpiTemplateItemExample;
import com.els.base.performance.service.KpiTemplateItemService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultKpiTemplateItemService")
public class KpiTemplateItemServiceImpl
implements KpiTemplateItemService {
    @Resource
    protected KpiTemplateItemMapper kpiTemplateItemMapper;

    @CacheEvict(value={"kpiTemplateItem"}, allEntries=true)
    public void addObj(KpiTemplateItem t) {
        this.kpiTemplateItemMapper.insertSelective(t);
    }

    @CacheEvict(value={"kpiTemplateItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.kpiTemplateItemMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"kpiTemplateItem"}, allEntries=true)
    public void deleteByExample(KpiTemplateItemExample exampl) {
        this.kpiTemplateItemMapper.deleteByExample(exampl);
    }

    @CacheEvict(value={"kpiTemplateItem"}, allEntries=true)
    public void modifyObj(KpiTemplateItem t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.kpiTemplateItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"kpiTemplateItem"}, keyGenerator="redisKeyGenerator")
    public KpiTemplateItem queryObjById(String id) {
        return this.kpiTemplateItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"kpiTemplateItem"}, keyGenerator="redisKeyGenerator")
    public List<KpiTemplateItem> queryAllObjByExample(KpiTemplateItemExample example) {
        return this.kpiTemplateItemMapper.selectByExample(example);
    }

    @Cacheable(value={"kpiTemplateItem"}, keyGenerator="redisKeyGenerator")
    public PageView<KpiTemplateItem> queryObjByPage(KpiTemplateItemExample example) {
        PageView<KpiTemplateItem> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiTemplateItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Transactional
    @CacheEvict(value={"kpiTemplateItem"}, allEntries=true)
    public void addAll(List<KpiTemplateItem> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
            this.kpiTemplateItemMapper.insertSelective((KpiTemplateItem)item);
        });
    }
}

