/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.performance.dao.KpiWeightRankMapper;
import com.els.base.performance.entity.KpiWeightRank;
import com.els.base.performance.entity.KpiWeightRankExample;
import com.els.base.performance.service.KpiWeightRankService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultKpiWeightRankService")
public class KpiWeightRankServiceImpl
implements KpiWeightRankService {
    @Resource
    protected KpiWeightRankMapper kpiWeightRankMapper;

    @CacheEvict(value={"kpiWeightRank"}, allEntries=true)
    public void addObj(KpiWeightRank t) {
        this.kpiWeightRankMapper.insertSelective(t);
    }

    @CacheEvict(value={"kpiWeightRank"}, allEntries=true)
    public void deleteObjById(String id) {
        this.kpiWeightRankMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"kpiWeightRank"}, allEntries=true)
    public void modifyObj(KpiWeightRank t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.kpiWeightRankMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"kpiWeightRank"}, keyGenerator="redisKeyGenerator")
    public KpiWeightRank queryObjById(String id) {
        return this.kpiWeightRankMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"kpiWeightRank"}, keyGenerator="redisKeyGenerator")
    public List<KpiWeightRank> queryAllObjByExample(KpiWeightRankExample example) {
        return this.kpiWeightRankMapper.selectByExample(example);
    }

    @Cacheable(value={"kpiWeightRank"}, keyGenerator="redisKeyGenerator")
    public PageView<KpiWeightRank> queryObjByPage(KpiWeightRankExample example) {
        PageView<KpiWeightRank> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiWeightRankMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void deleteByExample(KpiWeightRankExample example) {
        this.kpiWeightRankMapper.deleteByExample(example);
    }

    @Transactional
    @CacheEvict(value={"kpiWeightRank"}, allEntries=true)
    public void addAll(List<KpiWeightRank> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
            this.kpiWeightRankMapper.insertSelective((KpiWeightRank)item);
        });
    }
}

