/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.utils;

import com.els.base.core.exception.CommonException;
import com.els.base.performance.entity.vo.EvaluateVO;
import com.els.base.performance.entity.vo.ExcelVO;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ExcelEvaluateUtil {
    private static Logger logger = LoggerFactory.getLogger(ExcelEvaluateUtil.class);

    public static List<Map<String, Map<String, String>>> excel2List(MultipartFile file, ExcelVO excelVO) {
        ExcelEvaluateUtil.validFile(file);
        try {
            int evaluateCount = excelVO.getList().get(0).getProjectCodeList().size();
            Workbook workbook = Workbook.getWorkbook((InputStream)file.getInputStream());
            Sheet sheet = workbook.getSheet(0);
            int rows = sheet.getRows();
            ArrayList<Map<String, Map<String, String>>> result = new ArrayList<Map<String, Map<String, String>>>();
            for (int i = 1; i < rows; ++i) {
                Cell[] row = sheet.getRow(i);
                if (row.length != evaluateCount + 1) {
                    throw new CommonException("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684Excel\u5185\u5bb9\uff01");
                }
                String companyCode = row[0].getContents();
                if (StringUtils.isEmpty((CharSequence)companyCode)) {
                    throw new CommonException("Excel\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                HashMap companyMap = new HashMap();
                for (EvaluateVO evaluateVO : excelVO.getList()) {
                    if (!companyCode.equals(evaluateVO.getSupplierSrmCode())) continue;
                    HashMap<String, String> scoreMap = new HashMap<String, String>();
                    for (int j = 1; j < row.length; ++j) {
                        List<String> projectCodeList = evaluateVO.getProjectCodeList();
                        scoreMap.put(projectCodeList.get(j - 1), row[j].getContents());
                    }
                    companyMap.put(companyCode, scoreMap);
                    break;
                }
                if (companyMap.size() <= 0) continue;
                result.add(companyMap);
            }
            return result;
        }
        catch (IOException e) {
            logger.error("\u7ee9\u6548\u6a21\u5757-\u5bfc\u5165Excel\u8bc4\u5206\u5f02\u5e38-IOException\uff0cmessage\uff1a" + e.getMessage());
            throw new CommonException("\u5bfc\u5165\u8bc4\u5206\u5f02\u5e38");
        }
        catch (BiffException e) {
            logger.error("\u7ee9\u6548\u6a21\u5757-\u5bfc\u5165Excel\u8bc4\u5206\u5f02\u5e38-BiffException\uff0cmessage\uff1a" + e.getMessage());
            throw new CommonException("\u5bfc\u5165\u8bc4\u5206\u5f02\u5e38");
        }
    }

    private static void validFile(MultipartFile file) {
        if (file == null) {
            throw new CommonException("\u6587\u4ef6\u4e3a\u7a7a\uff01");
        }
        String type = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf("."));
        if (!".xls".equals(type)) {
            throw new CommonException("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u9009\u62e9\u3010.xls\u3011\u6587\u4ef6");
        }
    }
}

