/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.web.controller;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import com.els.base.performance.entity.vo.EliminateVO;
import com.els.base.performance.service.KpiFormService;
import com.els.base.performance.service.KpiScoreService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u7ee9\u6548\u7ba1\u7406-\u8bc4\u4f30\u8868")
@Controller
@RequestMapping(value={"eliminate"})
public class EliminateController {
    private Logger logger = LoggerFactory.getLogger(EliminateController.class);
    @Resource
    protected KpiFormService kpiFormService;
    @Resource
    protected KpiScoreService kpiScoreService;
    @Resource
    protected CompanyPurRefService companyPurRefService;
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected UserService userService;

    @ApiOperation(httpMethod="POST", value="\u6dd8\u6c70\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/eliminateSapSupplier"})
    @ResponseBody
    public ResponseResult<String> eliminateSapSupplier(@RequestBody EliminateVO eliminateVO) {
        this.logger.info("eliminateSapSupplier");
        CompanyExample example = new CompanyExample();
        example.createCriteria().andCompanySapCodeEqualTo(eliminateVO.getSupCompanySapCode());
        this.logger.info("queryAllSupplerCompanies");
        List CompanyArray = this.companyService.queryAllSupplerCompanies(CompanyUtils.currentCompany().getId(), example);
        if (CollectionUtils.isNotEmpty((Collection)CompanyArray)) {
            // empty if block
        }
        Company company = (Company)CompanyArray.get(0);
        company.setIsEnable(Constant.NO_INT);
        company.setRemark(company.getRemark() + " " + eliminateVO.getRemark());
        this.companyService.modifyObj((Serializable)company);
        this.logger.info("queryUserListOfCompany");
        List userList = this.companyUserRefService.queryUserListOfCompany(company.getId());
        if (CollectionUtils.isNotEmpty((Collection)userList)) {
            for (User user : userList) {
                user.setIsEnable(Constant.NO_INT);
                this.userService.modifyObj((Serializable)user);
            }
        }
        return ResponseResult.success();
    }
}

