/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.web.controller;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.performance.entity.KpiAdverseEvent;
import com.els.base.performance.entity.KpiAdverseEventExample;
import com.els.base.performance.enums.KpiAdverseEventStatus;
import com.els.base.performance.service.KpiAdverseEventService;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u4e0d\u826f\u4e8b\u4ef6")
@Controller
@RequestMapping(value={"kpiAdverseEvent"})
public class KpiAdverseEventController {
    @Resource
    protected KpiAdverseEventService kpiAdverseEventService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4e0d\u826f\u4e8b\u4ef6")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiAdverseEvent kpiAdverseEvent) {
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        kpiAdverseEvent.setCompany(company);
        kpiAdverseEvent.setUser(user);
        this.kpiAdverseEventService.addObj(kpiAdverseEvent);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4e0d\u826f\u4e8b\u4ef6")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiAdverseEvent kpiAdverseEvent) {
        Assert.isNotBlank((String)kpiAdverseEvent.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        kpiAdverseEvent.setCompany(company);
        kpiAdverseEvent.setUser(user);
        this.kpiAdverseEventService.modifyObj(kpiAdverseEvent);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4e0d\u826f\u4e8b\u4ef6")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.kpiAdverseEventService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u67e5\u8be2\u4e0d\u826f\u4e8b\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiAdverseEvent", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForPur"})
    @ResponseBody
    public ResponseResult<PageView<KpiAdverseEvent>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiAdverseEventExample example = new KpiAdverseEventExample();
        example.setPageView((PageView<KpiAdverseEvent>)new PageView(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        List loginUserRoleList = SpringSecurityUtils.getLoginUserRoleList();
        ArrayList<String> roleCodeList = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)loginUserRoleList) && i < loginUserRoleList.size(); ++i) {
            roleCodeList.add(((Role)loginUserRoleList.get(i)).getRoleCode());
        }
        example.setOrderByClause("CREATE_TIME DESC");
        PageView pageData = this.kpiAdverseEventService.queryObjByPage((IExample)example);
        List queryResult = pageData.getQueryResult();
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)queryResult) && i < queryResult.size(); ++i) {
            if (!(roleCodeList.contains("systemManager") || roleCodeList.contains("manager") || roleCodeList.contains("supplier") || ((KpiAdverseEvent)queryResult.get(i)).getPurUserId().equals(SpringSecurityUtils.getLoginUserId()))) {
                ((KpiAdverseEvent)queryResult.get(i)).setCurrentUserCreate("0");
                continue;
            }
            ((KpiAdverseEvent)queryResult.get(i)).setCurrentUserCreate("1");
        }
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u67e5\u8be2\u4e0d\u826f\u4e8b\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiAdverseEvent", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForSup"})
    @ResponseBody
    public ResponseResult<PageView<KpiAdverseEvent>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiAdverseEventExample example = new KpiAdverseEventExample();
        example.setPageView((PageView<KpiAdverseEvent>)new PageView(pageNo, pageSize));
        Company company = CompanyUtils.currentCompany();
        KpiAdverseEventExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanySapCodeEqualTo(company.getCompanySapCode()).andStatusNotEqualTo(KpiAdverseEventStatus.NO_SEND.getValue());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC");
        PageView pageData = this.kpiAdverseEventService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4e0d\u826f\u4e8b\u4ef6\u64cd\u4f5c 0:\u91c7\u8d2d\u65b9\u53d1\u9001 1:\u4f9b\u5e94\u5546\u7533\u8bc9 2:\u91c7\u8d2d\u65b9\u62d2\u7edd\u7533\u8bc9 3:\u4f5c\u5e9f")
    @RequestMapping(value={"service/operation"})
    @ResponseBody
    public ResponseResult<String> operation(@RequestBody List<KpiAdverseEvent> kpiAdverseEvents, String type) {
        for (int i = 0; CollectionUtils.isNotEmpty(kpiAdverseEvents) && i < kpiAdverseEvents.size(); ++i) {
            KpiAdverseEvent kpiAdverseEvent = kpiAdverseEvents.get(i);
            kpiAdverseEvent.setCompany(CompanyUtils.currentCompany());
            kpiAdverseEvent.setUser(SpringSecurityUtils.getLoginUser());
            this.kpiAdverseEventService.supSubmitAppeal(kpiAdverseEvent, type);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4e0d\u826f\u4e8b\u4ef6\u5bfc\u51faexcel")
    @RequestMapping(value={"service/downloadExcel"})
    @ResponseBody
    public ModelAndView downloadExcel(HttpServletResponse response) {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("\u4e0d\u826f\u4e8b\u4ef6.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.getTitleAndModelKeys();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, null, (String)"\u4e0d\u826f\u4e8b\u4ef6", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @ApiOperation(value="\u4e0d\u826f\u4e8b\u4ef6excel\u5bfc\u5165", httpMethod="POST")
    @RequestMapping(value={"service/uploadExcel"})
    @ResponseBody
    public ResponseResult<String> uploadExcel(MultipartHttpServletRequest request) {
        List importExcelDataToMap = new ArrayList();
        try {
            Map fileMap = request.getFileMap();
            MultipartFile file = this.vaildFile(fileMap);
            List<TitleAndModelKey> titleAndModelKeys = this.getTitleAndModelKeys();
            importExcelDataToMap = ExcelUtils.importExcelDataToMap((InputStream)file.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, KpiAdverseEvent.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        for (int i = 0; CollectionUtils.isNotEmpty(importExcelDataToMap) && i < importExcelDataToMap.size(); ++i) {
            KpiAdverseEvent kpiAdverseEvent = (KpiAdverseEvent)importExcelDataToMap.get(i);
            kpiAdverseEvent.setCompany(CompanyUtils.currentCompany());
            kpiAdverseEvent.setUser(SpringSecurityUtils.getLoginUser());
            this.kpiAdverseEventService.addObject(kpiAdverseEvent);
        }
        return ResponseResult.success();
    }

    private MultipartFile vaildFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        Set<String> fileKeySet = fileMap.keySet();
        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        return file;
    }

    private List<TitleAndModelKey> getTitleAndModelKeys() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        TitleAndModelKey titleAndModelKey2 = ExcelUtils.createTitleAndModelKey((String)"\u4e8b\u4ef6\u53d1\u751f\u65e5\u671f", (String)"startTime");
        DateConverter dateConverter2 = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKey2.setToObjConverter((StrToObjConverter)dateConverter2);
        titleAndModelKey2.setToStrConverter((ObjToStrConverter)dateConverter2);
        titleAndModelKeys.add(titleAndModelKey2);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546SRM\u7f16\u7801", (String)"supCompanySrmCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e8b\u9879\u7b80\u8ff0", (String)"briefResume"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7c7b\u522b(\u5f71\u54cd/\u670d\u52a1)", (String)"type"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e8b\u9879", (String)"matter"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6263\u5206", (String)"points"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u5907\u6ce8", (String)"remark"));
        return titleAndModelKeys;
    }
}

