/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.performance.entity.KpiDeliveryRate;
import com.els.base.performance.entity.KpiDeliveryRateExample;
import com.els.base.performance.entity.KpiOriginalExport;
import com.els.base.performance.entity.KpiOriginalExportExample;
import com.els.base.performance.service.KpiDeliveryRateService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u4f9b\u5e94\u5546\u4ea4\u4ed8\u7387 \u539f\u59cb\u6570\u636e")
@Controller
@RequestMapping(value={"kpiDeliveryRate"})
public class KpiDeliveryRateController {
    @Resource
    protected CompanyService companyService;
    @Resource
    protected KpiDeliveryRateService kpiDeliveryRateService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u4ea4\u4ed8\u7387 \u539f\u59cb\u6570\u636e")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiDeliveryRate kpiDeliveryRate) {
        this.kpiDeliveryRateService.addObj(kpiDeliveryRate);
        return ResponseResult.success((Object)kpiDeliveryRate.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u4ea4\u4ed8\u7387 \u539f\u59cb\u6570\u636e")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiDeliveryRate kpiDeliveryRate) {
        Assert.isNotBlank((String)kpiDeliveryRate.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.kpiDeliveryRateService.modifyObj(kpiDeliveryRate);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f9b\u5e94\u5546\u4ea4\u4ed8\u7387 \u539f\u59cb\u6570\u636e")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        KpiDeliveryRateExample example = new KpiDeliveryRateExample();
        example.createCriteria().andIdIn((List)ids);
        this.kpiDeliveryRateService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u4ea4\u4ed8\u7387 \u539f\u59cb\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiDeliveryRate", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiDeliveryRate>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiDeliveryRateExample example = new KpiDeliveryRateExample();
        example.setPageView((PageView<KpiDeliveryRate>)new PageView(pageNo, pageSize));
        KpiDeliveryRateExample.Criteria criteria = example.createCriteria();
        if (CompanyUtils.isSupCompany()) {
            criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" CREATE_TIME DESC");
        PageView pageData = this.kpiDeliveryRateService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u4ea4\u4ed8\u7387(\u4f9b\u5e94\u5546) \u539f\u59cb\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiDeliveryRate", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiDeliveryRate>> supplierFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiDeliveryRateExample example = new KpiDeliveryRateExample();
        example.setPageView((PageView<KpiDeliveryRate>)new PageView(pageNo, pageSize));
        KpiDeliveryRateExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" CREATE_TIME DESC");
        PageView pageData = this.kpiDeliveryRateService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u5165\u4ea4\u8d27\u7387\u539f\u59cb\u6570\u636e\u6a21\u677f\u4e0b\u8f7d", httpMethod="GET")
    @RequestMapping(value={"service/dowloadTemplateExcel"})
    @ResponseBody
    public ModelAndView dowloadTemplateExcel(HttpServletResponse response) {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "\u4ea4\u4ed8\u7387\u5bfc\u5165\u6a21\u677f" + System.currentTimeMillis() + ".xls";
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ArrayList kpiDeliveryRates = new ArrayList();
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray(true);
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, kpiDeliveryRates, (String)"\u4ea4\u4ed8\u7387\u6a21\u677f", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    private List<TitleAndModelKey> createTitleAndModelKeyArray(boolean template) {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u4ee3\u7801", (String)"supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5206\u7c7b", (String)"category"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e1a\u52a1\u5458", (String)"salesMan"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u53d1\u7ecf\u7406", (String)"developmentManager"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u51c6\u65f6\u4ea4\u4ed8", (String)"onTimeDelivery"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d85\u671fJIT", (String)"beyondJit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u672a\u4ea4\u4ed8JIT", (String)"noDeliveryJit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u539f\u56e0", (String)"supplierReason"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5eb7\u5c3c\u539f\u56e0", (String)"kangniReason"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u603b\u8ba1", (String)"total"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7b2c1\u7248(\u7cfb\u7edf\u6570\u636e)", (String)"firstEdition"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7b2c2\u7248(\u751f\u4ea7\u7b7e\u5b57\u7248)", (String)"secondEdition"));
        if (template) {
            return titleAndModelKeys;
        }
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e74\u4efd", (String)"year"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6708\u4efd", (String)"month"));
        return titleAndModelKeys;
    }

    @ApiOperation(value="\u5bfc\u5165\u4ea4\u8d27\u7387\u539f\u59cb\u6570\u636e", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importFromExcel"})
    public ResponseResult<String> importFromExcel(MultipartHttpServletRequest request, @RequestParam(required=true) int Year, @RequestParam(required=true) int Month) {
        Map fileMap = request.getFileMap();
        if (MapUtils.isEmpty((Map)fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
        }
        String key = (String)fileMap.keySet().iterator().next();
        MultipartFile uploadFile = (MultipartFile)fileMap.get(key);
        List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray(true);
        List<KpiDeliveryRate> list = new ArrayList();
        try {
            list = ExcelUtils.importExcelDataToMap((InputStream)uploadFile.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, KpiDeliveryRate.class);
        }
        catch (Exception e) {
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty(list)) {
            for (KpiDeliveryRate kpiDeliveryRate : list) {
                CompanyExample example = new CompanyExample();
                example.createCriteria().andCompanySapCodeEqualTo(kpiDeliveryRate.getSupCompanySapCode());
                List companies = this.companyService.queryAllObjByExample((IExample)example);
                if (CollectionUtils.isNotEmpty((Collection)companies)) {
                    kpiDeliveryRate.setSupCompanySrmCode(((Company)companies.get(0)).getCompanyCode());
                    kpiDeliveryRate.setCriticality(((Company)companies.get(0)).getCriticalityName());
                    kpiDeliveryRate.setSymbiosis(((Company)companies.get(0)).getSymbiosis());
                    kpiDeliveryRate.setProductImportance(((Company)companies.get(0)).getProductImportanceName());
                }
                kpiDeliveryRate.setUpdateTime(new Date());
                kpiDeliveryRate.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
                kpiDeliveryRate.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
                kpiDeliveryRate.setYear(String.valueOf(Year));
                kpiDeliveryRate.setMonth(String.valueOf(Month));
            }
            this.kpiDeliveryRateService.ImportFromExcel(list);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5bfc\u51fa\u4ea4\u8d27\u53ca\u65f6\u7387\u539f\u59cb\u6570\u636e")
    @RequestMapping(value={"service/dowloadExcel"})
    @ResponseBody
    public ResponseResult<FileData> dowloadExcel(@RequestBody(required=false) QueryParamWapper wapper) {
        KpiDeliveryRateExample example = new KpiDeliveryRateExample();
        KpiDeliveryRateExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" CREATE_TIME DESC");
        List kpiDeliveryRates = this.kpiDeliveryRateService.queryAllObjByExample((IExample)example);
        FileData fileData = new FileData();
        try {
            String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format("\u4ea4\u8d27\u53ca\u65f6\u7387-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
            fileData = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray(false);
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)fos, titleAndModelKeys, (List)kpiDeliveryRates, (String)"\u7ee9\u6548\u5bfc\u5165\u6a21\u677f", null, (int)0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();
        }
        catch (IOException exx) {
            exx.printStackTrace();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return ResponseResult.success((Object)fileData);
    }

    @ApiOperation(httpMethod="POST", value="\u5bfc\u51fa\u4ea4\u8d27\u53ca\u65f6\u7387\u539f\u59cb\u6570\u636e(\u4f9b\u5e94\u5546)")
    @RequestMapping(value={"service/sup/dowloadExcel"})
    @ResponseBody
    public ResponseResult<FileData> supplerDowloadExcel(@RequestBody(required=false) QueryParamWapper wapper) {
        KpiDeliveryRateExample example = new KpiDeliveryRateExample();
        KpiDeliveryRateExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" CREATE_TIME DESC");
        List kpiDeliveryRates = this.kpiDeliveryRateService.queryAllObjByExample((IExample)example);
        FileData fileData = new FileData();
        try {
            String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format("\u4ea4\u8d27\u53ca\u65f6\u7387-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
            fileData = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray(false);
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)fos, titleAndModelKeys, (List)kpiDeliveryRates, (String)"\u7ee9\u6548\u5bfc\u5165\u6a21\u677f", null, (int)0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();
        }
        catch (IOException exx) {
            exx.printStackTrace();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return ResponseResult.success((Object)fileData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u4ea4\u4ed8\u7387 \u539f\u59cb\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiOriginalExport", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findReportByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiOriginalExport>> findReportByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiOriginalExportExample example = new KpiOriginalExportExample();
        example.setPageView((PageView<KpiOriginalExport>)new PageView(pageNo, pageSize));
        KpiOriginalExportExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" YEAR DESC");
        PageView<KpiOriginalExport> pageData = this.kpiDeliveryRateService.queryReportObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5bfc\u51fa\u4ea4\u8d27\u53ca\u65f6\u7387\u539f\u59cb\u6570\u636e")
    @RequestMapping(value={"service/dowloadReportExcel"})
    @ResponseBody
    public ResponseResult<FileData> dowloadReportExcel(@RequestBody(required=false) QueryParamWapper wapper) {
        KpiOriginalExportExample example = new KpiOriginalExportExample();
        KpiOriginalExportExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" YEAR DESC");
        List<KpiOriginalExport> kpiOriginalExports = this.kpiDeliveryRateService.queryReportAllObjByExample(example);
        FileData fileData = new FileData();
        try {
            String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format("\u4ea4\u8d27\u53ca\u65f6\u7387\u5e74\u5ea6\u62a5\u8868-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
            fileData = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());
            List<TitleAndModelKey> titleAndModelKeys = this.createReportTitleAndModelKeyArray();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)fos, titleAndModelKeys, kpiOriginalExports, (String)"\u4ea4\u8d27\u53ca\u65f6\u7387\u5e74\u5ea6\u62a5\u8868", null, (int)0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();
        }
        catch (IOException exx) {
            exx.printStackTrace();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return ResponseResult.success((Object)fileData);
    }

    private List<TitleAndModelKey> createReportTitleAndModelKeyArray() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u4ee3\u7801", (String)"supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5206\u7c7b", (String)"category"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e1a\u52a1\u5458", (String)"salesMan"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u53d1\u7ecf\u7406", (String)"developmentManager"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e74\u4efd", (String)"year"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e00\u6708(\u7cfb\u7edf\u6570\u636e)", (String)"January1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e00\u6708(\u5b9e\u9645\u6570\u636e)", (String)"January2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e8c\u6708(\u7cfb\u7edf\u6570\u636e)", (String)"February1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e8c\u6708(\u5b9e\u9645\u6570\u636e)", (String)"February2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e09\u6708(\u7cfb\u7edf\u6570\u636e)", (String)"March1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e09\u6708(\u5b9e\u9645\u6570\u636e)", (String)"March2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56db\u6708(\u7cfb\u7edf\u6570\u636e)", (String)"April1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56db\u6708(\u5b9e\u9645\u6570\u636e)", (String)"April2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e94\u6708(\u7cfb\u7edf\u6570\u636e)", (String)"May1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e94\u6708(\u5b9e\u9645\u6570\u636e)", (String)"May2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u516d\u6708(\u7cfb\u7edf\u6570\u636e)", (String)"June1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u516d\u6708(\u5b9e\u9645\u6570\u636e)", (String)"June2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e03\u6708(\u7cfb\u7edf\u6570\u636e)", (String)"July1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e03\u6708(\u5b9e\u9645\u6570\u636e)", (String)"July2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u516b\u6708(\u7cfb\u7edf\u6570\u636e)", (String)"August1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u516b\u6708(\u5b9e\u9645\u6570\u636e)", (String)"August2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e5d\u6708(\u7cfb\u7edf\u6570\u636e)", (String)"September1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e5d\u6708(\u5b9e\u9645\u6570\u636e)", (String)"September2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5341\u6708(\u7cfb\u7edf\u6570\u636e)", (String)"October1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5341\u6708(\u5b9e\u9645\u6570\u636e)", (String)"October2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5341\u4e00\u6708(\u7cfb\u7edf\u6570\u636e)", (String)"November1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5341\u4e00\u6708(\u5b9e\u9645\u6570\u636e)", (String)"November2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5341\u4e8c\u6708(\u7cfb\u7edf\u6570\u636e)", (String)"December1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5341\u4e8c\u6708(\u5b9e\u9645\u6570\u636e)", (String)"December2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e73\u5747(\u7cfb\u7edf\u6570\u636e)", (String)"AvgValue1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e73\u5747(\u5b9e\u9645\u6570\u636e)", (String)"AvgValue2"));
        return titleAndModelKeys;
    }
}

