/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.performance.entity.KpiEvaluateSection;
import com.els.base.performance.entity.KpiEvaluateSectionExample;
import com.els.base.performance.service.KpiEvaluateSectionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u8bc4\u4f30\u533a\u95f4")
@Controller
@RequestMapping(value={"kpiEvaluateSection"})
public class KpiEvaluateSectionController {
    @Resource
    protected KpiEvaluateSectionService kpiEvaluateSectionService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8bc4\u4f30\u533a\u95f4")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiEvaluateSection kpiEvaluateSection) {
        if (kpiEvaluateSection.getStartSection() == null || kpiEvaluateSection.getEndSection() == null || kpiEvaluateSection.getScore() == null) {
            throw new CommonException("\u8bf7\u8f93\u5165\u5206\u6570\uff01\uff01");
        }
        this.checkSection(kpiEvaluateSection);
        kpiEvaluateSection.setCreateTime(new Date());
        kpiEvaluateSection.setCreateUser(SpringSecurityUtils.getLoginUserName());
        kpiEvaluateSection.setLastUpdateUser(SpringSecurityUtils.getLoginUserName());
        this.kpiEvaluateSectionService.addObj(kpiEvaluateSection);
        return ResponseResult.success((Object)kpiEvaluateSection.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8bc4\u4f30\u533a\u95f4")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiEvaluateSection kpiEvaluateSection) {
        Assert.isNotBlank((String)kpiEvaluateSection.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.checkSection(kpiEvaluateSection);
        this.kpiEvaluateSectionService.modifyObj(kpiEvaluateSection);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8bc4\u4f30\u533a\u95f4")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        KpiEvaluateSectionExample example = new KpiEvaluateSectionExample();
        example.createCriteria().andIdIn((List)ids);
        this.kpiEvaluateSectionService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8bc4\u4f30\u533a\u95f4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiEvaluateSection", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiEvaluateSection>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiEvaluateSectionExample example = new KpiEvaluateSectionExample();
        example.setPageView((PageView<KpiEvaluateSection>)new PageView(pageNo, pageSize));
        KpiEvaluateSectionExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.kpiEvaluateSectionService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    private void checkSection(KpiEvaluateSection section) {
        KpiEvaluateSectionExample example = new KpiEvaluateSectionExample();
        KpiEvaluateSectionExample.Criteria criteria = example.createCriteria();
        criteria.andStartSectionLessThan(section.getStartSection()).andEndSectionGreaterThan(section.getStartSection()).andProjectTypeEqualTo(section.getProjectType());
        if (StringUtils.isNotEmpty((String)section.getId())) {
            criteria.andIdNotEqualTo(section.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)this.kpiEvaluateSectionService.queryAllObjByExample((IExample)example))) {
            throw new CommonException("\u4fdd\u5b58\u5931\u8d25\uff0c\u5f00\u59cb\u503c\u3010" + section.getStartSection() + "\u3011\u5df2\u7ecf\u5b58\u5728\u4ea4\u96c6");
        }
        example.clear();
        KpiEvaluateSectionExample.Criteria criteria1 = example.createCriteria();
        criteria1.andStartSectionLessThan(section.getEndSection()).andEndSectionGreaterThan(section.getEndSection()).andProjectTypeEqualTo(section.getProjectType());
        if (StringUtils.isNotEmpty((String)section.getId())) {
            criteria1.andIdNotEqualTo(section.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)this.kpiEvaluateSectionService.queryAllObjByExample((IExample)example))) {
            throw new CommonException("\u4fdd\u5b58\u5931\u8d25\uff0c\u7ed3\u675f\u503c\u3010" + section.getEndSection() + "\u3011\u5df2\u7ecf\u5b58\u5728\u4ea4\u96c6");
        }
    }
}

