/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.web.controller;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.performance.entity.KpiEvaluateSection;
import com.els.base.performance.entity.KpiEvaluateSectionExample;
import com.els.base.performance.entity.KpiForm;
import com.els.base.performance.entity.KpiFormAndCompany;
import com.els.base.performance.entity.KpiFormAndCompanyExample;
import com.els.base.performance.entity.KpiFormExample;
import com.els.base.performance.entity.KpiOriginalScore;
import com.els.base.performance.entity.KpiOriginalScoreExample;
import com.els.base.performance.entity.KpiScoreExample;
import com.els.base.performance.entity.KpiTemplateItem;
import com.els.base.performance.entity.KpiTemplateItemExample;
import com.els.base.performance.entity.ReportQueryParams;
import com.els.base.performance.entity.ReportShow;
import com.els.base.performance.entity.vo.ExcelVO;
import com.els.base.performance.entity.vo.KpiFormVo;
import com.els.base.performance.service.KpiEvaluateSectionService;
import com.els.base.performance.service.KpiFormAndCompanyService;
import com.els.base.performance.service.KpiFormService;
import com.els.base.performance.service.KpiOriginalScoreService;
import com.els.base.performance.service.KpiScoreService;
import com.els.base.performance.service.KpiTemplateItemService;
import com.els.base.performance.utils.ExcelEvaluateUtil;
import com.els.base.performance.vo.TemplateExcelVo;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Api(value="\u7ee9\u6548\u7ba1\u7406-\u8bc4\u4f30\u8868")
@Controller
@RequestMapping(value={"kpiForm"})
public class KpiFormController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    protected KpiFormService kpiFormService;
    @Resource
    protected KpiScoreService kpiScoreService;
    @Resource
    protected KpiFormAndCompanyService kpiFormAndCompanyService;
    @Resource
    protected CompanyPurRefService companyPurRefService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected KpiTemplateItemService kpiTemplateItemService;
    @Resource
    protected KpiEvaluateSectionService kpiEvaluateSectionService;
    @Resource
    protected KpiOriginalScoreService kpiOriginalScoreService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8bc4\u4f30\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiForm kpiForm) {
        if (CollectionUtils.isEmpty(kpiForm.getKpiFormAndCompanyList())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u4f9b\u5e94\u5546\u4fe1\u606f"});
        }
        if (kpiForm.getFormName().getBytes().length > 255) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        kpiForm.setCompany(company);
        kpiForm.setUser(user);
        this.kpiFormService.addObject(kpiForm);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8bc4\u4f30\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiForm kpiForm) {
        if (StringUtils.isBlank((String)kpiForm.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        if (kpiForm.getFormName().getBytes().length > 255) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        kpiForm.setCompany(company);
        kpiForm.setUser(user);
        this.kpiFormService.modifyObject(kpiForm);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8bc4\u4f30\u8868")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.kpiFormService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u67e5\u8be2\u8bc4\u4f30\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiForm", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiForm>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiFormExample example = new KpiFormExample();
        KpiFormExample.Criteria criteria = example.createCriteria();
        criteria.andPurCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        example.setOrderByClause(" CREATE_TIME DESC ");
        example.setPageView((PageView<KpiForm>)new PageView(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        List loginUserRoleList = SpringSecurityUtils.getLoginUserRoleList();
        ArrayList<String> roleCodeList = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)loginUserRoleList) && i < loginUserRoleList.size(); ++i) {
            roleCodeList.add(((Role)loginUserRoleList.get(i)).getRoleCode());
        }
        List companyList = this.companyPurRefService.queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), null);
        ArrayList<String> srmCompanyIdList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)companyList)) {
            for (Company c : companyList) {
                srmCompanyIdList.add(c.getId());
            }
        }
        List<KpiForm> finalKpiForms = this.kpiFormService.queryfinalKpiForms(srmCompanyIdList, roleCodeList, SpringSecurityUtils.getLoginUser(), this.kpiFormService.queryAllObjByExampleCoustom(example));
        PageView pageData = new PageView(pageNo, pageSize);
        pageData.setRowCount(CollectionUtils.isEmpty(finalKpiForms) ? 0 : finalKpiForms.size());
        pageData.setQueryResult(finalKpiForms.subList(pageData.getStartRowNo(), pageData.getEndRowNo()));
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u8bc4\u5206\u8a73\u60c5")
    @RequestMapping(value={"service/lookKpiFormDetails"})
    @ResponseBody
    public ResponseResult<KpiForm> lookKpiFormDetails(@RequestParam String kpiFormId) {
        if (StringUtils.isBlank((String)kpiFormId)) {
            throw new CommonException("\u67e5\u770b\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        KpiForm kpiForm = this.kpiFormService.lookKpiFormDetails(kpiFormId);
        return ResponseResult.success((Object)kpiForm);
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u5e03")
    @RequestMapping(value={"service/releaseKpiFrom"})
    @ResponseBody
    public ResponseResult<String> releaseKpiFrom(@RequestBody KpiForm kpiForm) {
        if (kpiForm == null) {
            throw new CommonException("\u53d1\u5e03\u5931\u8d25,data\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        kpiForm.setCompany(company);
        kpiForm.setUser(user);
        this.kpiFormService.releaseKpiFrom(kpiForm);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7ed3\u6848\u8bc4\u4f30\u8868")
    @RequestMapping(value={"service/finishForm"})
    @ResponseBody
    public ResponseResult<String> finishForm(@RequestBody KpiForm kpiForm) {
        if (StringUtils.isBlank((String)kpiForm.getId())) {
            throw new CommonException("\u8bc4\u4f30\u8868\u4e3b\u952eid\u4e3a\u7a7a\u4e0d\u80fd\u8fdb\u884c\u7ed3\u6848", "base_canot_be_null", new Object[]{"\u8bc4\u4f30\u8868\u4e3b\u952eid"});
        }
        if (StringUtils.isBlank((String)kpiForm.getFormCode())) {
            throw new CommonException("\u8bc4\u4f30\u8868\u7f16\u7801\u4e3a\u7a7a\u4e0d\u80fd\u8fdb\u884c\u7ed3\u6848", "base_canot_be_null", new Object[]{"\u8bc4\u4f30\u8868\u7f16\u7801"});
        }
        KpiScoreExample kpiScoreExample = new KpiScoreExample();
        KpiScoreExample.Criteria criteria = kpiScoreExample.createCriteria();
        criteria.andFormCodeEqualTo(kpiForm.getFormCode());
        criteria.andScoreStateEqualTo("0");
        List kpiScoreList = this.kpiScoreService.queryAllObjByExample((IExample)kpiScoreExample);
        if (kpiScoreList.size() > 0) {
            throw new CommonException("\u8be5\u8bc4\u4f30\u8868\u8fd8\u6709\u672a\u8bc4\u5206\u7684\u6570\u636e\u4e0d\u80fd\u8fdb\u884c\u7ed3\u6848\u64cd\u4f5c", "finish_status", new Object[]{"\u64cd\u4f5c\u5931\u8d25\uff01\u8be5\u8bc4\u4f30\u8868\u3010\u8bc4\u4f30\u8868\u7f16\u7801:" + kpiForm.getFormCode() + "\u3011\u8fd8\u6709\u672a\u63d0\u4ea4\u8bc4\u5206\u7684\u6570\u636e\uff0c\u4e0d\u80fd\u8fdb\u884c\u7ed3\u6848\uff01"});
        }
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        kpiForm.setCompany(company);
        kpiForm.setUser(user);
        this.kpiFormService.finishForm(kpiForm);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u67e5\u770b\u8bc4\u5206")
    @RequestMapping(value={"service/lookAtTheScore"})
    @ResponseBody
    public ResponseResult<KpiFormVo> lookAtTheScore(@RequestBody KpiForm kpiForm) {
        if (kpiForm == null) {
            throw new CommonException("\u67e5\u770b\u8bc4\u5206\u5931\u8d25,data\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        List loginUserRoleList = SpringSecurityUtils.getLoginUserRoleList();
        ArrayList<String> roleCodeList = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)loginUserRoleList) && i < loginUserRoleList.size(); ++i) {
            roleCodeList.add(((Role)loginUserRoleList.get(i)).getRoleCode());
        }
        kpiForm.setCompany(company);
        kpiForm.setUser(user);
        kpiForm.setRoleCodeList(roleCodeList);
        KpiFormVo kpiFormVo = this.kpiFormService.lookAtTheScore(kpiForm);
        return ResponseResult.success((Object)kpiFormVo);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u67e5\u770b\u8bc4\u5206")
    @RequestMapping(value={"service/lookAtTheScoreAll"})
    @ResponseBody
    public ResponseResult<KpiFormVo> lookAtTheScoreAll(@RequestBody KpiForm kpiForm) {
        if (kpiForm == null) {
            throw new CommonException("\u67e5\u770b\u8bc4\u5206\u5931\u8d25,data\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        List loginUserRoleList = SpringSecurityUtils.getLoginUserRoleList();
        ArrayList<String> roleCodeList = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)loginUserRoleList) && i < loginUserRoleList.size(); ++i) {
            roleCodeList.add(((Role)loginUserRoleList.get(i)).getRoleCode());
        }
        kpiForm.setCompany(company);
        kpiForm.setUser(user);
        kpiForm.setRoleCodeList(roleCodeList);
        KpiFormVo kpiFormVo = this.kpiFormService.lookAtTheScore(kpiForm);
        return ResponseResult.success((Object)kpiFormVo);
    }

    @ApiOperation(httpMethod="POST", value="\u4fdd\u5b58\u8bc4\u5206")
    @RequestMapping(value={"service/saveAtTheScore"})
    @ResponseBody
    public ResponseResult<String> saveAtTheScore(@RequestBody KpiFormVo kpiFormVo, @RequestParam String saveOrSubmit) {
        if (kpiFormVo == null) {
            throw new CommonException("\u4fdd\u5b58\u8bc4\u5206\u5931\u8d25,data\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        kpiFormVo.setCompany(company);
        kpiFormVo.setUser(user);
        this.kpiFormService.saveAtTheScore(kpiFormVo, saveOrSubmit);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f5c\u5e9f")
    @RequestMapping(value={"service/toVoidDocument"})
    @ResponseBody
    public ResponseResult<String> toVoidDocument(String id) {
        this.kpiFormService.toVoidDocument(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7b49\u7ea7\u8c03\u6574")
    @RequestMapping(value={"service/rankAdjustMent"})
    @ResponseBody
    public ResponseResult<String> rankAdjustMent(@RequestParam String supplierSrmCode, @RequestParam String classLevel) {
        if (StringUtils.isBlank((String)supplierSrmCode) || StringUtils.isBlank((String)classLevel)) {
            throw new CommonException("\u7b49\u7ea7\u8c03\u6574\u5931\u8d25,supplierSrmCode,classLevel\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.kpiFormService.rankAdjustMent(supplierSrmCode, classLevel);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6708\u5ea6\u62a5\u8868")
    @RequestMapping(value={"service/queryMonthlyReport"})
    @ResponseBody
    public ResponseResult<ReportShow> queryMonthlyReport(@RequestBody ReportQueryParams reportQueryParams) {
        ReportShow monthlyReport = this.kpiFormService.queryMonthlyReport(reportQueryParams);
        return ResponseResult.success((Object)monthlyReport);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5b63\u5ea6\u6216\u5e74\u5ea6\u62a5\u8868")
    @RequestMapping(value={"service/queryQuarterOrYearReport"})
    @ResponseBody
    public ResponseResult<ReportShow> queryQuarterOrYearReport(@RequestBody ReportQueryParams reportQueryParams) {
        ReportShow quarterReportShow = this.kpiFormService.queryQuarterOrYearReport(reportQueryParams);
        return ResponseResult.success((Object)quarterReportShow);
    }

    @ApiOperation(httpMethod="POST", value="\u9001\u7b7e\u7ee9\u6548\u7ed3\u679c")
    @RequestMapping(value={"service/sendToSing"})
    @ResponseBody
    public ResponseResult<String> sendToSing(@RequestBody KpiForm kpiForm) {
        if (kpiForm == null) {
            throw new CommonException("\u9001\u7b7e\u5931\u8d25,\u6240\u9009\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)kpiForm.getId())) {
            throw new CommonException("\u9001\u7b7e\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.kpiFormService.sendToSing(kpiForm.getId());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4e0b\u8f7d\u7ee9\u6548\u6253\u5206\u6a21\u677f")
    @RequestMapping(value={"service/dowloadTemplateExcel"})
    @ResponseBody
    public ResponseResult<FileData> dowloadTemplateExcel(@RequestBody KpiForm kpiForm) {
        if (kpiForm == null) {
            throw new CommonException("\u67e5\u770b\u8bc4\u5206\u5931\u8d25,data\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        List loginUserRoleList = SpringSecurityUtils.getLoginUserRoleList();
        ArrayList<String> roleCodeList = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)loginUserRoleList) && i < loginUserRoleList.size(); ++i) {
            roleCodeList.add(((Role)loginUserRoleList.get(i)).getRoleCode());
        }
        kpiForm.setCompany(company);
        kpiForm.setUser(user);
        kpiForm.setRoleCodeList(roleCodeList);
        KpiFormVo kpiFormVo = this.kpiFormService.lookAtTheScore(kpiForm);
        FileData fileData = new FileData();
        try {
            String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format("\u7ee9\u6548\u5bfc\u5165\u6a21\u677f-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
            fileData = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());
            ArrayList<TemplateExcelVo> voList = new ArrayList<TemplateExcelVo>();
            KpiFormAndCompanyExample example = new KpiFormAndCompanyExample();
            example.createCriteria().andKpiFormIdEqualTo(kpiForm.getId()).andFormCodeEqualTo(kpiForm.getFormCode());
            List kpiFormAndCompanies = this.kpiFormAndCompanyService.queryAllObjByExample((IExample)example);
            if (CollectionUtils.isNotEmpty((Collection)kpiFormAndCompanies)) {
                for (KpiFormAndCompany kpiFormAndCompany : kpiFormAndCompanies) {
                    TemplateExcelVo templateExcelVo = new TemplateExcelVo();
                    templateExcelVo.setSupCompanyCode(kpiFormAndCompany.getSupCompanySapCode());
                    templateExcelVo.setSupCompanyName(kpiFormAndCompany.getSupCompanyName());
                    templateExcelVo.setCategoryName(kpiFormAndCompany.getCategoryName());
                    templateExcelVo.setSupCompanySrmCode(kpiFormAndCompany.getSupCompanySrmCode());
                    voList.add(templateExcelVo);
                }
            }
            ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u4ee3\u7801", (String)"supCompanyCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546SRM\u7f16\u7801", (String)"supCompanySrmCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u5206\u7c7b", (String)"categoryName"));
            List<Map<String, String>> mapList = kpiFormVo.getTitles();
            if (mapList.size() > 0) {
                for (int i = 1; i <= mapList.size(); ++i) {
                    String nameFied = mapList.get(i - 1).get("projectName");
                    String valueFied = "kpiScore" + i;
                    titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)nameFied, (String)valueFied));
                }
            }
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)fos, titleAndModelKeys, voList, (String)"\u7ee9\u6548\u5bfc\u5165\u6a21\u677f", null, (int)0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();
        }
        catch (IOException exx) {
            exx.printStackTrace();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return ResponseResult.success((Object)fileData);
    }

    @ApiOperation(httpMethod="POST", value="\u5bfc\u5165\u8bc4\u5206")
    @RequestMapping(value={"service/importToEvaluate"})
    @ResponseBody
    public ResponseResult<List<Map<String, Object>>> importToEvaluate(MultipartFile file, String dataJson) throws IOException {
        if (StringUtils.isEmpty((String)dataJson)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.logger.info("dataJson" + dataJson);
        ExcelVO excelVO = (ExcelVO)JsonUtils.convertValue((String)dataJson, ExcelVO.class);
        String formId = excelVO.getList().get(0).getKpiFormId();
        String templateCode = excelVO.getList().get(0).getTemplateCode();
        List<Map<String, Map<String, String>>> maps = ExcelEvaluateUtil.excel2List(file, excelVO);
        if (CollectionUtils.isEmpty(maps)) {
            throw new CommonException("\u6ca1\u6709\u5339\u914d\u7684\u4f9b\u5e94\u5546\uff01");
        }
        ArrayList resultList = new ArrayList();
        for (Map<String, Map<String, String>> map : maps) {
            HashMap companyMap = new HashMap();
            map.forEach((companyCode, scoreMap) -> {
                companyMap.put("supplierSrmCode", companyCode);
                KpiOriginalScore score = new KpiOriginalScore();
                scoreMap.forEach((projectCode, originalScore) -> {
                    KpiTemplateItemExample example = new KpiTemplateItemExample();
                    example.createCriteria().andTemplateCodeEqualTo(templateCode).andProjectCodeEqualTo((String)projectCode);
                    List kpiTemplateItems = this.kpiTemplateItemService.queryAllObjByExample((IExample)example);
                    if (CollectionUtils.isNotEmpty((Collection)kpiTemplateItems)) {
                        String type = ((KpiTemplateItem)kpiTemplateItems.get(0)).getProjectType();
                        companyMap.put(projectCode, this.switchScore((String)originalScore, type, score));
                    }
                });
                this.saveOriginalScore(formId, (String)companyCode, score);
            });
            resultList.add(companyMap);
        }
        return ResponseResult.success(resultList);
    }

    private void saveOriginalScore(String formId, String srmCode, KpiOriginalScore score) {
        KpiOriginalScoreExample example = new KpiOriginalScoreExample();
        example.createCriteria().andKpiFormIdEqualTo(formId).andCompanySrmCodeEqualTo(srmCode);
        List scoreList = this.kpiOriginalScoreService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)scoreList)) {
            this.kpiOriginalScoreService.updateByExampleSelective(example, score);
        } else {
            score.setKpiFormId(formId);
            score.setCompanySrmCode(srmCode);
            this.kpiOriginalScoreService.addObj(score);
        }
    }

    private Map<String, String> switchScore(String originalScoreStr, String type, KpiOriginalScore score) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)originalScoreStr)) {
            map.put("score", null);
            map.put("originalScore", null);
            return map;
        }
        Double originalScore = 0.0;
        String originalScorePer = "";
        originalScorePer = originalScoreStr.length() - 1 == originalScoreStr.lastIndexOf("%") ? originalScoreStr.substring(0, originalScoreStr.length() - 1) : originalScoreStr;
        try {
            originalScore = Double.parseDouble(originalScorePer);
        }
        catch (Exception e) {
            throw new CommonException("\u8bf7\u5bfc\u5165\u6b63\u786e\u5206\u6570\uff01");
        }
        switch (type) {
            case "deliver": {
                score.setOriginalDeliver(originalScoreStr);
                break;
            }
            case "service": {
                score.setOriginalService(originalScoreStr);
                break;
            }
            case "price": {
                score.setOriginalPrice(originalScoreStr);
                break;
            }
            case "quality": {
                score.setOriginalQuality(originalScoreStr);
                break;
            }
            case "qualityCount": {
                score.setOriginalQualityCount(originalScoreStr);
            }
        }
        KpiEvaluateSectionExample example = new KpiEvaluateSectionExample();
        example.createCriteria().andStartSectionLessThanOrEqualTo(originalScore).andProjectTypeEqualTo(type).andEndSectionGreaterThanOrEqualTo(originalScore);
        List kpiEvaluateSections = this.kpiEvaluateSectionService.queryAllObjByExample((IExample)example);
        map.put("originalScore", originalScoreStr);
        if (CollectionUtils.isEmpty((Collection)kpiEvaluateSections)) {
            map.put("score", originalScoreStr);
            return map;
        }
        map.put("score", ((KpiEvaluateSection)kpiEvaluateSections.get(0)).getScore().toString());
        return map;
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Company", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findSupplerByPage"})
    @ResponseBody
    public ResponseResult<PageView<Company>> findSupplerByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=true) int Year, @RequestParam(required=true) int Month, @RequestBody(required=false) QueryParamWapper wapper) {
        List<String> CompanySapCodes = this.kpiFormService.queryCompanySapCode(String.valueOf(Year), String.valueOf(Month));
        CompanyExample example = new CompanyExample();
        CompanyExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(CompanySapCodes)) {
            criteria.andCompanySapCodeIn(CompanySapCodes);
        } else {
            criteria.andCompanySapCodeIsNotNull().andCompanyCodeNotEqualTo("50000000");
        }
        example.setPageView(new PageView(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.companyService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

