/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.performance.entity.KpiDeliveryRate;
import com.els.base.performance.entity.KpiDeliveryRateExample;
import com.els.base.performance.entity.KpiQualifiedBatch;
import com.els.base.performance.entity.KpiQualifiedBatchExample;
import com.els.base.performance.service.KpiDeliveryRateService;
import com.els.base.performance.service.KpiQualifiedBatchService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u8fc7\u7a0b\u8d28\u91cf\u6279\u6b21\u539f\u59cb\u6570\u636e")
@Controller
@RequestMapping(value={"kpiQualifiedBatch"})
public class KpiQualifiedBatchController {
    @Resource
    protected KpiQualifiedBatchService kpiQualifiedBatchService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected KpiDeliveryRateService kpiDeliveryRateService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8fc7\u7a0b\u8d28\u91cf\u6279\u6b21\u539f\u59cb\u6570\u636e")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiQualifiedBatch kpiQualifiedBatch) {
        this.kpiQualifiedBatchService.addObj(kpiQualifiedBatch);
        return ResponseResult.success((Object)kpiQualifiedBatch.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8fc7\u7a0b\u8d28\u91cf\u6279\u6b21\u539f\u59cb\u6570\u636e")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiQualifiedBatch kpiQualifiedBatch) {
        Assert.isNotBlank((String)kpiQualifiedBatch.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.kpiQualifiedBatchService.modifyObj(kpiQualifiedBatch);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8fc7\u7a0b\u8d28\u91cf\u6279\u6b21\u539f\u59cb\u6570\u636e")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        KpiQualifiedBatchExample example = new KpiQualifiedBatchExample();
        example.createCriteria().andIdIn((List)ids);
        this.kpiQualifiedBatchService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8fc7\u7a0b\u8d28\u91cf\u6279\u6b21\u539f\u59cb\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiQualifiedBatch", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiQualifiedBatch>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiQualifiedBatchExample example = new KpiQualifiedBatchExample();
        example.setPageView((PageView<KpiQualifiedBatch>)new PageView(pageNo, pageSize));
        KpiQualifiedBatchExample.Criteria criteria = example.createCriteria();
        if (CompanyUtils.isSupCompany()) {
            criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" CREATE_TIME DESC");
        PageView pageData = this.kpiQualifiedBatchService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8fc7\u7a0b\u8d28\u91cf\u6279\u6b21\u539f\u59cb\u6570\u636e(\u4f9b\u5e94\u5546)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiQualifiedBatch", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiQualifiedBatch>> supplierFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiQualifiedBatchExample example = new KpiQualifiedBatchExample();
        example.setPageView((PageView<KpiQualifiedBatch>)new PageView(pageNo, pageSize));
        KpiQualifiedBatchExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" CREATE_TIME DESC");
        PageView pageData = this.kpiQualifiedBatchService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u5165\u8fc7\u7a0b\u8d28\u91cf\u6279\u6b21\u539f\u59cb\u6570\u636e\u6a21\u677f\u4e0b\u8f7d", httpMethod="GET")
    @RequestMapping(value={"service/dowloadTemplateExcel"})
    @ResponseBody
    public ModelAndView dowloadTemplateExcel(HttpServletResponse response) {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "\u8d28\u91cf\u6279\u6b21\u5bfc\u5165\u6a21\u677f" + System.currentTimeMillis() + ".xls";
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ArrayList kpiQualifiedBatches = new ArrayList();
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray(true);
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, kpiQualifiedBatches, (String)"\u8d28\u91cf\u6279\u6b21\u6a21\u677f", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    private List<TitleAndModelKey> createTitleAndModelKeyArray(boolean template) {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e8f\u53f7", (String)"serialNumber"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7f16\u53f7", (String)"billNo"));
        if (!template) {
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u4ee3\u7801", (String)"supCompanySapCode"));
        }
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u65b9\u540d\u79f0", (String)"supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u5177\u539f\u56e0", (String)"openReason"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u63a5\u6536\u65e5\u671f", (String)"receieDate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"remark"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e74\u5ea6", (String)"year"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6708\u4efd", (String)"month"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u53d1\u751f\u5730\u70b9", (String)"takePlace"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9879\u76ee", (String)"project"));
        if (template) {
            return titleAndModelKeys;
        }
        return titleAndModelKeys;
    }

    @ApiOperation(value="\u5bfc\u5165\u8d28\u91cf\u6279\u6b21\u539f\u59cb\u6570\u636e", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importFromExcel"})
    public ResponseResult<String> importFromExcel(MultipartHttpServletRequest request) {
        Map fileMap = request.getFileMap();
        if (MapUtils.isEmpty((Map)fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
        }
        String key = (String)fileMap.keySet().iterator().next();
        MultipartFile uploadFile = (MultipartFile)fileMap.get(key);
        List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray(true);
        List<KpiQualifiedBatch> list = new ArrayList();
        try {
            list = ExcelUtils.importExcelDataToMap((InputStream)uploadFile.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, KpiQualifiedBatch.class);
        }
        catch (Exception e) {
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty(list)) {
            for (KpiQualifiedBatch kpiQualifiedBatch : list) {
                CompanyExample example = new CompanyExample();
                example.createCriteria().andCompanyNameEqualTo(kpiQualifiedBatch.getSupCompanyName());
                List companies = this.companyService.queryAllObjByExample((IExample)example);
                if (CollectionUtils.isNotEmpty((Collection)companies)) {
                    kpiQualifiedBatch.setSupCompanySapCode(((Company)companies.get(0)).getCompanySapCode());
                    kpiQualifiedBatch.setSupCompanySrmCode(((Company)companies.get(0)).getCompanyCode());
                    kpiQualifiedBatch.setCriticality(((Company)companies.get(0)).getCriticalityName());
                    kpiQualifiedBatch.setSymbiosis(((Company)companies.get(0)).getSymbiosis());
                    kpiQualifiedBatch.setProductImportance(((Company)companies.get(0)).getProductImportanceName());
                } else {
                    KpiDeliveryRateExample example1 = new KpiDeliveryRateExample();
                    example1.createCriteria().andSupCompanyNameEqualTo(kpiQualifiedBatch.getSupCompanyName()).andYearEqualTo(kpiQualifiedBatch.getYear()).andMonthEqualTo(kpiQualifiedBatch.getMonth());
                    List kpiDeliveryRates = this.kpiDeliveryRateService.queryAllObjByExample((IExample)example1);
                    if (CollectionUtils.isNotEmpty((Collection)kpiDeliveryRates)) {
                        kpiQualifiedBatch.setSupCompanySapCode(((KpiDeliveryRate)kpiDeliveryRates.get(0)).getSupCompanySapCode());
                        kpiQualifiedBatch.setSupCompanySrmCode(((KpiDeliveryRate)kpiDeliveryRates.get(0)).getSupCompanySrmCode());
                        kpiQualifiedBatch.setCriticality(((KpiDeliveryRate)kpiDeliveryRates.get(0)).getCriticality());
                        kpiQualifiedBatch.setSymbiosis(((KpiDeliveryRate)kpiDeliveryRates.get(0)).getSymbiosis());
                        kpiQualifiedBatch.setProductImportance(((KpiDeliveryRate)kpiDeliveryRates.get(0)).getProductImportance());
                    }
                }
                kpiQualifiedBatch.setUpdateTime(new Date());
                kpiQualifiedBatch.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
                kpiQualifiedBatch.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            }
            this.kpiQualifiedBatchService.ImportFromExcel(list);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5bfc\u51fa\u8d28\u91cf\u6279\u6b21\u539f\u59cb\u6570\u636e")
    @RequestMapping(value={"service/dowloadExcel"})
    @ResponseBody
    public ResponseResult<FileData> dowloadExcel(@RequestBody(required=false) QueryParamWapper wapper) {
        KpiQualifiedBatchExample example = new KpiQualifiedBatchExample();
        KpiQualifiedBatchExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" CREATE_TIME DESC");
        List kpiQualifiedRates = this.kpiQualifiedBatchService.queryAllObjByExample((IExample)example);
        FileData fileData = new FileData();
        try {
            String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format("\u8d28\u91cf\u6279\u6b21-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
            fileData = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray(false);
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)fos, titleAndModelKeys, (List)kpiQualifiedRates, (String)"\u7ee9\u6548\u5bfc\u5165\u6a21\u677f", null, (int)0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();
        }
        catch (IOException exx) {
            exx.printStackTrace();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return ResponseResult.success((Object)fileData);
    }

    @ApiOperation(httpMethod="POST", value="\u5bfc\u51fa\u8d28\u91cf\u6279\u6b21\u539f\u59cb\u6570\u636e(\u4f9b\u5e94\u5546)")
    @RequestMapping(value={"service/sup/dowloadExcel"})
    @ResponseBody
    public ResponseResult<FileData> supplerDowloadExcel(@RequestBody(required=false) QueryParamWapper wapper) {
        KpiQualifiedBatchExample example = new KpiQualifiedBatchExample();
        KpiQualifiedBatchExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" CREATE_TIME DESC");
        List kpiQualifiedRates = this.kpiQualifiedBatchService.queryAllObjByExample((IExample)example);
        FileData fileData = new FileData();
        try {
            String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format("\u8d28\u91cf\u6279\u6b21-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
            fileData = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray(false);
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)fos, titleAndModelKeys, (List)kpiQualifiedRates, (String)"\u7ee9\u6548\u5bfc\u5165\u6a21\u677f", null, (int)0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();
        }
        catch (IOException exx) {
            exx.printStackTrace();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return ResponseResult.success((Object)fileData);
    }
}

