/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.web.controller;

import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.performance.entity.KpiRanking;
import com.els.base.performance.entity.KpiRankingExample;
import com.els.base.performance.entity.vo.KpiRankingVo;
import com.els.base.performance.service.KpiRankingService;
import com.els.base.performance.vo.KpiRankingExcelVo;
import com.els.base.performance.vo.KpiRankingScoreVo;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u7ee9\u6548\u7ba1\u7406-\u6392\u540d\u8868")
@Controller
@RequestMapping(value={"kpiRanking"})
public class KpiRankingController {
    @Resource
    protected KpiRankingService kpiRankingService;
    @Resource
    protected CompanyService companyService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u6392\u540d\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiRanking kpiRanking) {
        this.kpiRankingService.addObj(kpiRanking);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u6392\u540d\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiRanking kpiRanking) {
        if (StringUtils.isBlank((String)kpiRanking.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.kpiRankingService.modifyObj(kpiRanking);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u6392\u540d\u8868")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.kpiRankingService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u67e5\u8be2\u6392\u540d\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiRanking", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiRanking>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiRankingExample example = new KpiRankingExample();
        example.setPageView((PageView<KpiRanking>)new PageView(pageNo, pageSize));
        KpiRankingExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        example.setOrderByClause("LAST_UPDATE_TIME DESC");
        PageView pageData = this.kpiRankingService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    private List<TitleAndModelKey> createTitleAndModelKeyArray(boolean ispur) {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8bc4\u4f30\u8868\u7f16\u7801", (String)"formCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8bc4\u4f30\u8868\u540d\u79f0", (String)"formName"));
        TitleAndModelKey titleAndModelKey = ExcelUtils.createTitleAndModelKey((String)"\u5f00\u59cb\u65f6\u95f4", (String)"formPublishTime");
        DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKey.setToObjConverter((StrToObjConverter)dateConverter);
        titleAndModelKey.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(titleAndModelKey);
        TitleAndModelKey titleAndModelKey2 = ExcelUtils.createTitleAndModelKey((String)"\u5b9e\u9645\u5b8c\u6210\u65f6\u95f4", (String)"formFactTime");
        DateConverter dateConverter2 = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKey2.setToObjConverter((StrToObjConverter)dateConverter2);
        titleAndModelKey2.setToStrConverter((ObjToStrConverter)dateConverter2);
        titleAndModelKeys.add(titleAndModelKey2);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u53f7", (String)"supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8003\u6838\u7b49\u7ea7", (String)"purCheckRank"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5206\u6570", (String)"rankingScore"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6392\u540d\u5347\u964d", (String)"ranking"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u540d\u6b21", (String)"rankingCount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u53c2\u8bc4\u5bb6\u6570", (String)"companyNumber"));
        if (ispur) {
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u5206\u7c7b", (String)"category"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5206\u7c7b\u6392\u540d", (String)"categoryRank"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5206\u7c7b\u53c2\u8bc4\u5bb6\u6570", (String)"categoryCount"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91cd\u70b9\u6807\u8bc6", (String)"importantFlag"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e1a\u52a1\u5458", (String)"salesMan"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u53d1\u7ecf\u7406", (String)"developmentManager"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u662f\u5426\u5408\u683c\u4f9b\u5e94\u5546", (String)"qualifiedFlag"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u662f\u5426\u4e0a\u7ebfSRM", (String)"onlineSrmFlag"));
        }
        return titleAndModelKeys;
    }

    @ApiOperation(httpMethod="POST", value="\u7ee9\u6548\u7ed3\u679c\u5bfc\u51faExcel")
    @RequestMapping(value={"service/downloadExcel"})
    @ResponseBody
    public ResponseResult<FileData> downloadExcel(@RequestBody(required=false) QueryParamWapper wapper) {
        KpiRankingExample example = new KpiRankingExample();
        KpiRankingExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause("LAST_UPDATE_TIME DESC");
        List KpiRankingList = this.kpiRankingService.queryAllObjByExample((IExample)example);
        FileData fileData = new FileData();
        ArrayList<KpiRankingExcelVo> kpiRankingVos = new ArrayList<KpiRankingExcelVo>();
        try {
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray(true);
            if (CollectionUtils.isNotEmpty((Collection)KpiRankingList)) {
                int index = 0;
                for (KpiRanking kpiRanking : KpiRankingList) {
                    if ("1".equals(kpiRanking.getRanking())) {
                        kpiRanking.setRanking("\u5347");
                    } else if ("2".equals(kpiRanking.getRanking())) {
                        kpiRanking.setRanking("\u964d");
                    } else if ("3".equals(kpiRanking.getRanking())) {
                        kpiRanking.setRanking("\u5e73");
                    }
                    KpiRankingExcelVo kpiRankingExcelVo = new KpiRankingExcelVo();
                    BeanUtils.copyProperties((Object)kpiRanking, (Object)kpiRankingExcelVo);
                    if (Constant.YES_INT.equals(kpiRanking.getQualifiedFlag())) {
                        kpiRankingExcelVo.setQualifiedFlag("\u662f");
                    } else {
                        kpiRankingExcelVo.setRanking("\u5426");
                    }
                    if (Constant.YES_INT.equals(kpiRanking.getOnlineSrmFlag())) {
                        kpiRankingExcelVo.setOnlineSrmFlag("\u662f");
                    } else {
                        kpiRankingExcelVo.setOnlineSrmFlag("\u5426");
                    }
                    String kpiScoreDesc = kpiRanking.getProjectTypeScore();
                    if (StringUtils.isNotEmpty((String)kpiScoreDesc)) {
                        kpiScoreDesc = kpiScoreDesc.replace("|", ",");
                        kpiScoreDesc = "[" + kpiScoreDesc + "]";
                        List kpiRankingScoreVos = new ArrayList();
                        ObjectMapper objectMapper = new ObjectMapper();
                        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{KpiRankingScoreVo.class});
                        kpiRankingScoreVos = (List)objectMapper.readValue(kpiScoreDesc, javaType);
                        for (int i = 0; i < kpiRankingScoreVos.size(); ++i) {
                            KpiRankingScoreVo kpiRankingScoreVo = (KpiRankingScoreVo)kpiRankingScoreVos.get(i);
                            if (i == 0) {
                                kpiRankingExcelVo.setOriginalScore1(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue1(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore1(kpiRankingScoreVo.getScore());
                            }
                            if (i == 1) {
                                kpiRankingExcelVo.setOriginalScore2(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue2(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore2(kpiRankingScoreVo.getScore());
                            }
                            if (i == 2) {
                                kpiRankingExcelVo.setOriginalScore3(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue3(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore3(kpiRankingScoreVo.getScore());
                            }
                            if (i == 3) {
                                kpiRankingExcelVo.setOriginalScore4(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue4(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore4(kpiRankingScoreVo.getScore());
                            }
                            if (i == 4) {
                                kpiRankingExcelVo.setOriginalScore5(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue5(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore5(kpiRankingScoreVo.getScore());
                            }
                            if (i == 5) {
                                kpiRankingExcelVo.setOriginalScore6(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue6(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore6(kpiRankingScoreVo.getScore());
                            }
                            if (i == 6) {
                                kpiRankingExcelVo.setOriginalScore7(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue7(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore7(kpiRankingScoreVo.getScore());
                            }
                            if (i == 7) {
                                kpiRankingExcelVo.setOriginalScore8(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue8(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore8(kpiRankingScoreVo.getScore());
                            }
                            if (index != 0) continue;
                            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)(kpiRankingScoreVo.getName() + "\u539f\u59cb\u503c"), (String)("originalScore" + (i + 1))));
                            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)(kpiRankingScoreVo.getName() + "\u4fee\u6b63\u503c"), (String)("correctionValue" + (i + 1))));
                            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)(kpiRankingScoreVo.getName() + "\u5206\u6570"), (String)("score" + (i + 1))));
                        }
                        ++index;
                    }
                    kpiRankingVos.add(kpiRankingExcelVo);
                }
            }
            String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format(((KpiRanking)KpiRankingList.get(0)).getFormName() + "-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
            fileData = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)fos, titleAndModelKeys, kpiRankingVos, (String)"\u7ee9\u6548\u7ed3\u679c", null, (int)0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();
        }
        catch (IOException exx) {
            exx.printStackTrace();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return ResponseResult.success((Object)fileData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u67e5\u8be2\u6392\u540d\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiRanking", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/supFindByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiRanking>> supFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiRankingExample example = new KpiRankingExample();
        example.setPageView((PageView<KpiRanking>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        KpiRankingExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        criteria.andSupCompanySrmCodeEqualTo(CompanyUtils.currentCompany().getCompanyCode());
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        example.setOrderByClause("LAST_UPDATE_TIME DESC");
        PageView pageData = this.kpiRankingService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u65b9\u67e5\u8be2\u6392\u540d\u8868\u660e\u7ec6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiRanking", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/purFindByRanking"})
    @ResponseBody
    public ResponseResult<Map<String, Object>> purFindByRanking(@RequestBody(required=false) QueryParamWapper wapper) throws JsonParseException, JsonMappingException, IOException {
        KpiRankingExample example = new KpiRankingExample();
        KpiRankingExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC");
        List kpiRanking = this.kpiRankingService.queryAllObjByExample((IExample)example);
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        HashMap<String, Cloneable> mapRanking = new HashMap<String, Cloneable>();
        if (CollectionUtils.isNotEmpty((Collection)kpiRanking)) {
            for (KpiRanking r : kpiRanking) {
                map.put("formCode", r.getFormCode());
                map.put("formName", r.getFormName());
                map.put("formPublishTime", r.getFormPublishTime());
                map.put("formFactTime", r.getFormFactTime());
                map.put("supCompanySrmCode", r.getSupCompanySrmCode());
                map.put("supCompanyName", r.getSupCompanyName());
                map.put("purCompanyCategory", r.getPurCompanyCategory());
                map.put("purCompanyRank", r.getPurCompanyRank());
                map.put("rankingCount", r.getRankingCount());
                map.put("companyNumber", r.getCompanyNumber());
                map.put("categoryRank", r.getCategoryRank());
                map.put("categoryCount", r.getCategoryCount());
                map.put("category", r.getCategory());
                String[] sourceStrArray = r.getProjectTypeScore().split("\\|");
                for (int j = 0; j < sourceStrArray.length; ++j) {
                    String jsonMessage = sourceStrArray[j];
                    KpiRankingScoreVo kpi = (KpiRankingScoreVo)JsonUtils.convertValue((String)jsonMessage, KpiRankingScoreVo.class);
                    map.put(kpi.getCode(), kpi.getScore());
                    map.put(kpi.getCode() + "originalScore", kpi.getOriginalScore());
                    map.put(kpi.getCode() + "correctionValue", kpi.getCorrectionValue());
                    HashMap<String, String> mapTitle = new HashMap<String, String>();
                    mapTitle.put("projectCode", kpi.getCode() + "originalScore");
                    mapTitle.put("projectName", kpi.getName() + "\u539f\u59cb\u503c");
                    list.add(mapTitle);
                    mapTitle = new HashMap();
                    mapTitle.put("projectCode", kpi.getCode() + "correctionValue");
                    mapTitle.put("projectName", kpi.getName() + "\u4fee\u6b63\u503c");
                    list.add(mapTitle);
                    mapTitle = new HashMap();
                    mapTitle.put("projectCode", kpi.getCode());
                    mapTitle.put("projectName", kpi.getName() + "\u5206\u6570");
                    list.add(mapTitle);
                }
                map.put("rankingScore", r.getRankingScore());
                map.put("ranking", r.getRanking());
                Company company = (Company)this.companyService.queryObjById((Object)r.getSupCompanyId());
                map.put("classificationThree", company.getClassificationThree());
                String secondCompanyType = company.getSecondCompanyType();
                if (!StringUtils.isNotBlank((String)secondCompanyType)) continue;
                String[] classType = secondCompanyType.split(",");
                map.put("secondCompanyType", classType[0]);
            }
        }
        mapRanking.put("kpiRankingList", map);
        mapRanking.put("titles", list);
        return ResponseResult.success(mapRanking);
    }

    @ApiOperation(httpMethod="POST", value="\u7ee9\u6548\u7ed3\u679c\u5bfc\u51faExcel")
    @RequestMapping(value={"service/sup/downloadExcel"})
    @ResponseBody
    public ResponseResult<FileData> supplerDownloadExcel(@RequestBody(required=false) QueryParamWapper wapper) {
        KpiRankingExample example = new KpiRankingExample();
        KpiRankingExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        example.setOrderByClause("LAST_UPDATE_TIME DESC");
        List KpiRankingList = this.kpiRankingService.queryAllObjByExample((IExample)example);
        FileData fileData = new FileData();
        ArrayList<KpiRankingExcelVo> kpiRankingVos = new ArrayList<KpiRankingExcelVo>();
        try {
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray(false);
            if (CollectionUtils.isNotEmpty((Collection)KpiRankingList)) {
                int index = 0;
                for (KpiRanking kpiRanking : KpiRankingList) {
                    if ("1".equals(kpiRanking.getRanking())) {
                        kpiRanking.setRanking("\u5347");
                    } else if ("2".equals(kpiRanking.getRanking())) {
                        kpiRanking.setRanking("\u964d");
                    } else if ("3".equals(kpiRanking.getRanking())) {
                        kpiRanking.setRanking("\u5e73");
                    }
                    KpiRankingExcelVo kpiRankingExcelVo = new KpiRankingExcelVo();
                    BeanUtils.copyProperties((Object)kpiRanking, (Object)kpiRankingExcelVo);
                    String kpiScoreDesc = kpiRanking.getProjectTypeScore();
                    if (StringUtils.isNotEmpty((String)kpiScoreDesc)) {
                        kpiScoreDesc = kpiScoreDesc.replace("|", ",");
                        kpiScoreDesc = "[" + kpiScoreDesc + "]";
                        List kpiRankingScoreVos = new ArrayList();
                        ObjectMapper objectMapper = new ObjectMapper();
                        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{KpiRankingScoreVo.class});
                        kpiRankingScoreVos = (List)objectMapper.readValue(kpiScoreDesc, javaType);
                        for (int i = 0; i < kpiRankingScoreVos.size(); ++i) {
                            KpiRankingScoreVo kpiRankingScoreVo = (KpiRankingScoreVo)kpiRankingScoreVos.get(i);
                            if (i == 0) {
                                kpiRankingExcelVo.setOriginalScore1(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue1(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore1(kpiRankingScoreVo.getScore());
                            }
                            if (i == 1) {
                                kpiRankingExcelVo.setOriginalScore2(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue2(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore2(kpiRankingScoreVo.getScore());
                            }
                            if (i == 2) {
                                kpiRankingExcelVo.setOriginalScore3(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue3(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore3(kpiRankingScoreVo.getScore());
                            }
                            if (i == 3) {
                                kpiRankingExcelVo.setOriginalScore4(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue4(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore4(kpiRankingScoreVo.getScore());
                            }
                            if (i == 4) {
                                kpiRankingExcelVo.setOriginalScore5(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue5(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore5(kpiRankingScoreVo.getScore());
                            }
                            if (i == 5) {
                                kpiRankingExcelVo.setOriginalScore6(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue6(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore6(kpiRankingScoreVo.getScore());
                            }
                            if (i == 6) {
                                kpiRankingExcelVo.setOriginalScore7(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue7(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore7(kpiRankingScoreVo.getScore());
                            }
                            if (i == 7) {
                                kpiRankingExcelVo.setOriginalScore8(kpiRankingScoreVo.getOriginalScore());
                                kpiRankingExcelVo.setCorrectionValue8(kpiRankingScoreVo.getCorrectionValue());
                                kpiRankingExcelVo.setScore8(kpiRankingScoreVo.getScore());
                            }
                            if (index != 0) continue;
                            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)(kpiRankingScoreVo.getName() + "\u539f\u59cb\u503c"), (String)("originalScore" + i)));
                            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)(kpiRankingScoreVo.getName() + "\u4fee\u6b63\u503c"), (String)("correctionValue" + i)));
                            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)(kpiRankingScoreVo.getName() + "\u5206\u6570"), (String)("score" + i)));
                        }
                        ++index;
                    }
                    kpiRankingVos.add(kpiRankingExcelVo);
                }
            }
            String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format(((KpiRanking)KpiRankingList.get(0)).getFormName() + "-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
            fileData = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)fos, titleAndModelKeys, kpiRankingVos, (String)"\u7ee9\u6548\u7ed3\u679c", null, (int)0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();
        }
        catch (IOException exx) {
            exx.printStackTrace();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return ResponseResult.success((Object)fileData);
    }

    private void addScore2KpiRanking(List<KpiRanking> list) {
        try {
            for (KpiRanking kpiRanking : list) {
                for (String json : kpiRanking.getProjectTypeScore().split("\\|")) {
                    KpiRankingVo vo = (KpiRankingVo)JsonUtils.convertValue((String)json, KpiRankingVo.class);
                    this.switchScore(kpiRanking, vo);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void switchScore(KpiRanking kpiRanking, KpiRankingVo vo) {
        switch (vo.getCode()) {
            case "delivery": {
                break;
            }
            case "price": {
                break;
            }
            case "service": {
                break;
            }
            case "quality": {
                break;
            }
        }
    }
}

