/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.performance.entity.KpiOriginalExport;
import com.els.base.performance.entity.KpiOriginalExportExample;
import com.els.base.performance.entity.KpiService;
import com.els.base.performance.entity.KpiServiceExample;
import com.els.base.performance.entity.KpiServiceForm;
import com.els.base.performance.service.KpiServiceService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import jxl.write.WritableWorkbook;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f9b\u5e94\u5546\u670d\u52a1\u539f\u59cb\u6570\u636e")
@Controller
@RequestMapping(value={"kpiService"})
public class KpiServiceController {
    @Resource
    protected KpiServiceService kpiServiceService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u670d\u52a1\u539f\u59cb\u6570\u636e")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiService kpiService) {
        this.kpiServiceService.addObj(kpiService);
        return ResponseResult.success((Object)kpiService.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u670d\u52a1\u539f\u59cb\u6570\u636e")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiService kpiService) {
        Assert.isNotBlank((String)kpiService.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.kpiServiceService.modifyObj(kpiService);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f9b\u5e94\u5546\u670d\u52a1\u539f\u59cb\u6570\u636e")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        KpiServiceExample example = new KpiServiceExample();
        example.createCriteria().andIdIn((List)ids);
        this.kpiServiceService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u589e\u52a0\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/addSuuplerByIds"})
    @ResponseBody
    public ResponseResult<String> addSuuplerByIds(@RequestBody(required=true) List<String> ids, @RequestParam(required=true) String FormId) {
        Assert.isNotEmpty(ids, (String)"\u65b0\u589e\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.kpiServiceService.AddSupplerByIds(ids, FormId);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4fdd\u5b58\u5206\u6570")
    @RequestMapping(value={"service/saveScore"})
    @ResponseBody
    public ResponseResult<String> saveScore(@RequestBody(required=true) KpiServiceForm kpiServiceForm) {
        List<KpiService> kpiServiceList = kpiServiceForm.getKpiServiceList();
        Assert.isNotEmpty(kpiServiceList, (String)"\u4fdd\u5b58\u5931\u8d25,\u53c2\u6570\u4e3a\u7a7a");
        this.kpiServiceService.saveScore(kpiServiceList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u589e\u52a0\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/submitScore"})
    @ResponseBody
    public ResponseResult<String> submitScore(@RequestBody(required=true) KpiServiceForm kpiServiceForm) {
        List<KpiService> kpiServiceList = kpiServiceForm.getKpiServiceList();
        Assert.isNotEmpty(kpiServiceList, (String)"\u63d0\u4ea4\u5931\u8d25,\u53c2\u6570\u4e3a\u7a7a");
        this.kpiServiceService.submitScore(kpiServiceList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u670d\u52a1\u539f\u59cb\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiService", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiService>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiServiceExample example = new KpiServiceExample();
        example.setPageView((PageView<KpiService>)new PageView(pageNo, pageSize));
        KpiServiceExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" CREATE_TIME DESC");
        PageView pageData = this.kpiServiceService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5bfc\u51fa\u670d\u52a1\u539f\u59cb\u6570\u636e")
    @RequestMapping(value={"service/dowloadExcel"})
    @ResponseBody
    public ResponseResult<FileData> dowloadExcel(@RequestBody(required=false) QueryParamWapper wapper) {
        KpiServiceExample example = new KpiServiceExample();
        KpiServiceExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" CREATE_TIME DESC");
        List kpiQualifiedRates = this.kpiServiceService.queryAllObjByExample((IExample)example);
        FileData fileData = new FileData();
        try {
            String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format("\u670d\u52a1-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
            fileData = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)fos, titleAndModelKeys, (List)kpiQualifiedRates, (String)"\u7ee9\u6548\u5bfc\u5165\u6a21\u677f", null, (int)0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();
        }
        catch (IOException exx) {
            exx.printStackTrace();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return ResponseResult.success((Object)fileData);
    }

    private List<TitleAndModelKey> createTitleAndModelKeyArray() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u4ee3\u7801", (String)"supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u65b9\u540d\u79f0", (String)"supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5206\u7c7b", (String)"category"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e1a\u52a1\u5458", (String)"salesMan"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u53d1\u7ecf\u7406", (String)"developmentManager"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0d\u53ca\u65f6\u6b21\u6570", (String)"laterCount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u670d\u52a1\u5206\u6570", (String)"score"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e74\u5ea6", (String)"year"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6708\u4efd", (String)"month"));
        return titleAndModelKeys;
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u670d\u52a1\u539f\u59cb\u6570\u636e(\u4f9b\u5e94\u5546)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiService", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiService>> supplerFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiServiceExample example = new KpiServiceExample();
        example.setPageView((PageView<KpiService>)new PageView(pageNo, pageSize));
        KpiServiceExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" CREATE_TIME DESC");
        PageView pageData = this.kpiServiceService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5bfc\u51fa\u670d\u52a1\u539f\u59cb\u6570\u636e(\u4f9b\u5e94\u5546)")
    @RequestMapping(value={"service/sup/dowloadExcel"})
    @ResponseBody
    public ResponseResult<FileData> supplerDowloadExcel(@RequestBody(required=false) QueryParamWapper wapper) {
        KpiServiceExample example = new KpiServiceExample();
        KpiServiceExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        List kpiQualifiedRates = this.kpiServiceService.queryAllObjByExample((IExample)example);
        FileData fileData = new FileData();
        try {
            String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format("\u670d\u52a1-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
            fileData = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)fos, titleAndModelKeys, (List)kpiQualifiedRates, (String)"\u7ee9\u6548\u5bfc\u5165\u6a21\u677f", null, (int)0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();
        }
        catch (IOException exx) {
            exx.printStackTrace();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return ResponseResult.success((Object)fileData);
    }

    @ApiOperation(httpMethod="POST", value="\u670d\u52a1\u6253\u5206\u539f\u59cb\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiOriginalExport", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findReportByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiOriginalExport>> findReportByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiOriginalExportExample example = new KpiOriginalExportExample();
        example.setPageView((PageView<KpiOriginalExport>)new PageView(pageNo, pageSize));
        KpiOriginalExportExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" YEAR DESC");
        PageView<KpiOriginalExport> pageData = this.kpiServiceService.queryReportObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5bfc\u51fa\u670d\u52a1\u6253\u5206\u539f\u59cb\u6570\u636e")
    @RequestMapping(value={"service/dowloadReportExcel"})
    @ResponseBody
    public ResponseResult<FileData> dowloadReportExcel(@RequestBody(required=false) QueryParamWapper wapper) {
        KpiOriginalExportExample example = new KpiOriginalExportExample();
        KpiOriginalExportExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" YEAR DESC");
        List<KpiOriginalExport> kpiOriginalExports = this.kpiServiceService.queryReportAllObjByExample(example);
        FileData fileData = new FileData();
        try {
            String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format("\u7ee9\u6548\u670d\u52a1\u5e74\u5ea6\u62a5\u8868-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
            fileData = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());
            List<TitleAndModelKey> titleAndModelKeys = this.createReportTitleAndModelKeyArray();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)fos, titleAndModelKeys, kpiOriginalExports, (String)"\u7ee9\u6548\u670d\u52a1\u5e74\u5ea6\u62a5\u8868", null, (int)0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();
        }
        catch (IOException exx) {
            exx.printStackTrace();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return ResponseResult.success((Object)fileData);
    }

    private List<TitleAndModelKey> createReportTitleAndModelKeyArray() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u4ee3\u7801", (String)"supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5206\u7c7b", (String)"category"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e1a\u52a1\u5458", (String)"salesMan"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u53d1\u7ecf\u7406", (String)"developmentManager"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e74\u4efd", (String)"year"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e00\u6708", (String)"January1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e8c\u6708", (String)"February1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e09\u6708", (String)"March1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56db\u6708", (String)"April1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e94\u6708", (String)"May1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u516d\u6708", (String)"June1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e03\u6708", (String)"July1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u516b\u6708", (String)"August1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e5d\u6708", (String)"September1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5341\u6708", (String)"October1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5341\u4e00\u6708", (String)"November1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5341\u4e8c\u6708", (String)"December1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e73\u5747", (String)"AvgValue1"));
        return titleAndModelKeys;
    }
}

