/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.performance.entity.KpiService;
import com.els.base.performance.entity.KpiServiceForm;
import com.els.base.performance.entity.KpiServiceFormExample;
import com.els.base.performance.entity.vo.KpiServiceVo;
import com.els.base.performance.enums.KpiServiceFormStatus;
import com.els.base.performance.service.KpiServiceFormService;
import com.els.base.performance.service.KpiServiceService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(value="\u4f9b\u5e94\u5546\u670d\u52a1\u6708\u5ea6\u8868\u5355")
@Controller
@RequestMapping(value={"kpiServiceForm"})
public class KpiServiceFormController {
    @Resource
    protected KpiServiceFormService kpiServiceFormService;
    @Resource
    protected KpiServiceService kpiServiceService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u670d\u52a1\u6708\u5ea6\u8868\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiServiceForm kpiServiceForm) {
        kpiServiceForm.setCreateTime(new Date());
        kpiServiceForm.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        kpiServiceForm.setCreateUserName(SpringSecurityUtils.getLoginUserName());
        kpiServiceForm.setUpdateTime(new Date());
        kpiServiceForm.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        kpiServiceForm.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        this.kpiServiceFormService.addObj(kpiServiceForm);
        return ResponseResult.success((Object)kpiServiceForm.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u670d\u52a1\u6708\u5ea6\u8868\u5355")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiServiceForm kpiServiceForm) {
        Assert.isNotBlank((String)kpiServiceForm.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.kpiServiceFormService.saveKpiServiceForm(kpiServiceForm);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u770b\u4f9b\u5e94\u5546\u670d\u52a1\u6708\u5ea6\u8868\u5355")
    @RequestMapping(value={"service/view"})
    @ResponseBody
    public ResponseResult<KpiServiceForm> view(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u67e5\u770b\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        return ResponseResult.success((Object)this.kpiServiceFormService.viewById(id));
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f9b\u5e94\u5546\u670d\u52a1\u6708\u5ea6\u8868\u5355")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.kpiServiceFormService.deleteByIdArray(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u5e03\u4f9b\u5e94\u5546\u670d\u52a1\u6708\u5ea6\u8868\u5355")
    @RequestMapping(value={"service/publishByIds"})
    @ResponseBody
    public ResponseResult<String> publishByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.kpiServiceFormService.publishByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f5c\u5e9f\u4f9b\u5e94\u5546\u670d\u52a1\u6708\u5ea6\u8868\u5355")
    @RequestMapping(value={"service/invalidByIds"})
    @ResponseBody
    public ResponseResult<String> invalidByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.kpiServiceFormService.invalidByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u670d\u52a1\u6708\u5ea6\u8868\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiServiceForm", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiServiceForm>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiServiceFormExample example = new KpiServiceFormExample();
        example.setPageView((PageView<KpiServiceForm>)new PageView(pageNo, pageSize));
        KpiServiceFormExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" CREATE_TIME DESC");
        PageView pageData = this.kpiServiceFormService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u670d\u52a1\u6708\u5ea6\u8868\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiServiceForm", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findPublishByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiServiceForm>> findPublishByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiServiceFormExample example = new KpiServiceFormExample();
        example.setPageView((PageView<KpiServiceForm>)new PageView(pageNo, pageSize));
        KpiServiceFormExample.Criteria criteria = example.createCriteria();
        criteria.andFormStatusNotEqualTo(KpiServiceFormStatus.NEW.getValue());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause(" CREATE_TIME DESC");
        PageView pageData = this.kpiServiceFormService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u4f9b\u5e94\u5546\u670d\u52a1\u6708\u5ea6\u8868\u5355")
    @RequestMapping(value={"service/viewScore"})
    @ResponseBody
    public ResponseResult<KpiServiceForm> viewScore(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u67e5\u770b\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        return ResponseResult.success((Object)this.kpiServiceFormService.viewById(id));
    }

    @ApiOperation(httpMethod="GET", value="\u4f9b\u5e94\u5546\u670d\u52a1\u6708\u5ea6\u8868\u5355\u6253\u5206")
    @RequestMapping(value={"service/scoreById"})
    @ResponseBody
    public ResponseResult<KpiServiceForm> scoreById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u67e5\u770b\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        return ResponseResult.success((Object)this.kpiServiceFormService.scoreById(id));
    }

    @ApiOperation(httpMethod="POST", value="\u5bfc\u51fa\u670d\u52a1\u6253\u5206\u6a21\u677f")
    @RequestMapping(value={"service/dowloadExcel"})
    @ResponseBody
    public ResponseResult<FileData> dowloadExcel(@RequestParam(required=true) String id) {
        KpiServiceForm kpiServiceForm = this.kpiServiceFormService.scoreById(id);
        FileData fileData = new FileData();
        List<KpiService> kpiServices = kpiServiceForm.getKpiServiceList();
        try {
            String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
            fileData.setProjectId(ProjectUtils.getProjectId());
            fileData.setCompanyId(CompanyUtils.currentCompanyId());
            fileData.setFileName(MessageFormat.format("\u670d\u52a1\u6253\u5206-{0}", dateStr) + ".xls");
            fileData.setFileSuffix("xls");
            fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
            fileData.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
            fileData = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
            FileOutputStream fos = new FileOutputStream(fileData.toFile());
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)fos, titleAndModelKeys, kpiServices, (String)"\u7ee9\u6548\u670d\u52a1\u5bfc\u5165\u6a21\u677f", null, (int)0);
            writableWorkbook.write();
            fos.flush();
            writableWorkbook.close();
            fos.close();
        }
        catch (IOException exx) {
            exx.printStackTrace();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return ResponseResult.success((Object)fileData);
    }

    private List<TitleAndModelKey> createTitleAndModelKeyArray() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u4ee3\u7801", (String)"supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u65b9\u540d\u79f0", (String)"supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5206\u7c7b", (String)"category"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e1a\u52a1\u5458", (String)"salesMan"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u53d1\u7ecf\u7406", (String)"developmentManager"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0d\u53ca\u65f6\u6b21\u6570", (String)"laterCount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u670d\u52a1\u5206\u6570", (String)"score"));
        return titleAndModelKeys;
    }

    @ApiOperation(value="\u5bfc\u5165\u670d\u52a1\u6253\u5206", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importFromExcel"})
    public ResponseResult<String> importFromExcel(MultipartHttpServletRequest request, @RequestParam(required=true) String id) {
        Map fileMap = request.getFileMap();
        if (MapUtils.isEmpty((Map)fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
        }
        String key = (String)fileMap.keySet().iterator().next();
        MultipartFile uploadFile = (MultipartFile)fileMap.get(key);
        List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyArray();
        List list = new ArrayList();
        ArrayList<KpiService> kpiServices = new ArrayList<KpiService>();
        try {
            list = ExcelUtils.importExcelDataToMap((InputStream)uploadFile.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, KpiServiceVo.class);
        }
        catch (Exception e) {
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty(list)) {
            for (KpiServiceVo kpiServiceVo : list) {
                if (kpiServiceVo.getScore() == null) {
                    throw new CommonException("\u5206\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String StrBd = kpiServiceVo.getScore();
                BigDecimal bd = new BigDecimal(StrBd);
                KpiService kpiService = new KpiService();
                kpiService.setFormId(id);
                kpiService.setScore(bd);
                if (StringUtils.isNotEmpty((String)kpiServiceVo.getLaterCount())) {
                    Integer integer = new Integer(kpiServiceVo.getLaterCount());
                    kpiService.setLaterCount(integer);
                }
                kpiService.setSupCompanySrmCode(kpiServiceVo.getSupCompanySrmCode());
                kpiService.setSupCompanySapCode(kpiServiceVo.getSupCompanySapCode());
                kpiService.setSupCompanyName(kpiServiceVo.getSupCompanyName());
                kpiServices.add(kpiService);
            }
            this.kpiServiceService.importScore(kpiServices);
        }
        return ResponseResult.success();
    }
}

