/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.performance.entity.KpiSupWeightRank;
import com.els.base.performance.entity.KpiSupWeightRankExample;
import com.els.base.performance.entity.vo.KpiSupWeightRankVO;
import com.els.base.performance.service.KpiSupWeightRankService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f9b\u5e94\u5546\u6743\u91cd\u7b49\u7ea7\u5173\u7cfb\u8868")
@Controller
@RequestMapping(value={"kpiSupWeightRank"})
public class KpiSupWeightRankController {
    @Resource
    protected KpiSupWeightRankService kpiSupWeightRankService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u6743\u91cd\u7b49\u7ea7\u5173\u7cfb\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiSupWeightRank kpiSupWeightRank) {
        this.kpiSupWeightRankService.addObj(kpiSupWeightRank);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u6743\u91cd\u7b49\u7ea7\u5173\u7cfb\u8868\u53ca\u6743\u91cd\u591a\u7b49\u7ea7\u4fe1\u606f\u4fdd\u5b58")
    @RequestMapping(value={"service/createKpiSupWeightRank"})
    @ResponseBody
    public ResponseResult<String> createKpiSupWeightRank(@RequestBody KpiSupWeightRankVO kpiSupWeightRankVO) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((String)kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass())) {
            throw new CommonException("\u4ea7\u54c1\u5927\u7c7b\u79f0\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", new Object[]{"\u4ea7\u54c1\u5927\u7c7b"});
        }
        if (kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass() != null && KpiSupWeightRankController.getWordCountCode(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass(), "UTF-8") > 100) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        kpiSupWeightRankVO.setCompany(company);
        kpiSupWeightRankVO.setUser(user);
        this.kpiSupWeightRankService.addSupWeightRank(kpiSupWeightRankVO);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u6743\u91cd\u7b49\u7ea7\u5173\u7cfb\u8868\u53ca\u6743\u91cd\u591a\u7b49\u7ea7\u4fe1\u606f\u4fdd\u5b58")
    @RequestMapping(value={"service/editKpiSupWeightRank"})
    @ResponseBody
    public ResponseResult<String> editKpiSupWeightRank(@RequestBody KpiSupWeightRankVO kpiSupWeightRankVO) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((String)kpiSupWeightRankVO.getKpiSupWeightRank().getId())) {
            throw new CommonException("ID\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", new Object[]{"\u4e3b\u952eID"});
        }
        if (StringUtils.isBlank((String)kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass())) {
            throw new CommonException("\u4ea7\u54c1\u5927\u7c7b\u79f0\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", new Object[]{"\u4ea7\u54c1\u5927\u7c7b"});
        }
        if (kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass() != null && KpiSupWeightRankController.getWordCountCode(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass(), "UTF-8") > 100) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        kpiSupWeightRankVO.setCompany(company);
        kpiSupWeightRankVO.setUser(user);
        this.kpiSupWeightRankService.editSupWeightRank(kpiSupWeightRankVO);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f9b\u5e94\u5546\u6743\u91cd\u7b49\u7ea7\u5173\u7cfb\u8868\u53ca\u6743\u91cd\u591a\u7b49\u7ea7\u4fe1\u606f\u4fdd\u5b58")
    @RequestMapping(value={"service/deleteKpiSupWeightRank"})
    @ResponseBody
    public ResponseResult<String> deleteKpiSupWeightRank(@RequestBody KpiSupWeightRankVO kpiSupWeightRankVO) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((String)kpiSupWeightRankVO.getKpiSupWeightRank().getId())) {
            throw new CommonException("ID\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", new Object[]{"\u4e3b\u952eID"});
        }
        if (StringUtils.isBlank((String)kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass())) {
            throw new CommonException("\u4ea7\u54c1\u5927\u7c7b\u79f0\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", new Object[]{"\u4ea7\u54c1\u5927\u7c7b"});
        }
        this.kpiSupWeightRankService.deleteSupWeightRank(kpiSupWeightRankVO);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5224\u65ad\u4f9b\u5e94\u5546\u6743\u91cd\u7b49\u7ea7\u5173\u7cfb\u7684\u4ea7\u54c1\u5927\u7c7b\u662f\u5426\u5b58\u5728")
    @RequestMapping(value={"service/selectByIdExistsProductClass"})
    @ResponseBody
    public ResponseResult<String> selectByIdExistsProductClass(@RequestBody KpiSupWeightRankVO kpiSupWeightRankVO) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((String)kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass())) {
            throw new CommonException("\u4ea7\u54c1\u5927\u7c7b\u79f0\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", new Object[]{"\u4ea7\u54c1\u5927\u7c7b"});
        }
        KpiSupWeightRankExample example = new KpiSupWeightRankExample();
        KpiSupWeightRankExample.Criteria criteria = example.createCriteria();
        criteria.andProductClassEqualTo(kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass());
        List kpiSupWeightRankList = this.kpiSupWeightRankService.queryAllObjByExample((IExample)example);
        if (kpiSupWeightRankList.size() > 0) {
            throw new CommonException("\u4ea7\u54c1\u5927\u7c7b\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d", "base_is_exists", new Object[]{"\u64cd\u4f5c\u5931\u8d25\uff01\u4ea7\u54c1\u5927\u7c7b\u3010" + kpiSupWeightRankVO.getKpiSupWeightRank().getProductClass() + "\u3011"});
        }
        return ResponseResult.success();
    }

    public static int getWordCountCode(String str, String code) throws UnsupportedEncodingException {
        return str.getBytes(code).length;
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u6743\u91cd\u7b49\u7ea7\u5173\u7cfb\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiSupWeightRank kpiSupWeightRank) {
        Assert.isNotBlank((String)kpiSupWeightRank.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.kpiSupWeightRankService.modifyObj(kpiSupWeightRank);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f9b\u5e94\u5546\u6743\u91cd\u7b49\u7ea7\u5173\u7cfb\u8868")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.kpiSupWeightRankService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u6743\u91cd\u7b49\u7ea7\u5173\u7cfb\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiSupWeightRank", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiSupWeightRank>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiSupWeightRankExample example = new KpiSupWeightRankExample();
        example.setPageView((PageView<KpiSupWeightRank>)new PageView(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.kpiSupWeightRankService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

