/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.performance.entity.KpiSupplierImprove;
import com.els.base.performance.entity.KpiSupplierImproveExample;
import com.els.base.performance.enums.ImproveStatusEnum;
import com.els.base.performance.service.KpiSupplierImproveService;
import com.els.base.performance.utils.KpiSupplerImprovePdfPrintUntil;
import com.els.base.utils.SpringContextHolder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f9b\u5e94\u5546\u5f85\u6539\u5584")
@Controller
@RequestMapping(value={"kpiSupplierImprove"})
public class KpiSupplierImproveController {
    @Resource
    protected KpiSupplierImproveService kpiSupplierImproveService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected CompanyPurRefService companyPurRefService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u5f85\u6539\u5584")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiSupplierImprove kpiSupplierImprove) {
        if (StringUtils.isEmpty((String)kpiSupplierImprove.getImproveContent())) {
            throw new CommonException("\u5f85\u6539\u5584\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)kpiSupplierImprove.getImproveType())) {
            throw new CommonException("\u5f85\u6539\u5584\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)kpiSupplierImprove.getSupCompanySapCode())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
        String billNo = generateCodeService.getNextCode("IMPROVE_NO");
        kpiSupplierImprove.setImproveNo(billNo);
        User user = SpringSecurityUtils.getLoginUser();
        kpiSupplierImprove.setCreateUserId(user.getId());
        kpiSupplierImprove.setCreateUserName(user.getNickName());
        kpiSupplierImprove.setCreateTime(new Date());
        kpiSupplierImprove.setUpdateUserId(user.getId());
        kpiSupplierImprove.setUpdateUserName(user.getNickName());
        kpiSupplierImprove.setUpdateTime(new Date());
        kpiSupplierImprove.setStatus(ImproveStatusEnum.NEW.getValue());
        kpiSupplierImprove.setSendStatus(Constant.NO_INT);
        String projectId = "6";
        String companyId = "1";
        String purCompanyCode = "50000000";
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(purCompanyCode);
        List companyList = this.companyService.queryAllObjByExample((IExample)companyExample);
        if (CollectionUtils.isNotEmpty((Collection)companyList)) {
            Company c = (Company)companyList.get(0);
            projectId = c.getProjectId();
            companyId = c.getId();
        }
        kpiSupplierImprove.setProjectId(projectId);
        kpiSupplierImprove.setCompanyId(companyId);
        kpiSupplierImprove.setSummaryUserid(SpringSecurityUtils.getLoginUserId());
        kpiSupplierImprove.setSupCompanyName(SpringSecurityUtils.getLoginUserName());
        kpiSupplierImprove.setSummaryDate(new Date());
        Company supCompany = null;
        CompanyExample supompanyExample = new CompanyExample();
        supompanyExample.createCriteria().andCompanySapCodeEqualTo(kpiSupplierImprove.getSupCompanySapCode());
        List supCompanyList = this.companyService.queryAllObjByExample((IExample)supompanyExample);
        if (CollectionUtils.isNotEmpty((Collection)companyList)) {
            if (companyList.size() <= 0) {
                throw new CommonException("\u4f9b\u5e94\u5546\u4ee3\u7801\u4e3a" + kpiSupplierImprove.getSupCompanySapCode() + "\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728!");
            }
            supCompany = (Company)supCompanyList.get(0);
        }
        kpiSupplierImprove.setSupCompanyCode(supCompany.getCompanyCode());
        kpiSupplierImprove.setSupCompanyName(supCompany.getCompanyName());
        kpiSupplierImprove.setSupCompanySapCode(supCompany.getCompanySapCode());
        this.kpiSupplierImproveService.addObj(kpiSupplierImprove);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u5f85\u6539\u5584")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiSupplierImprove kpiSupplierImprove) {
        Assert.isNotBlank((String)kpiSupplierImprove.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.kpiSupplierImproveService.modifyObj(kpiSupplierImprove);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f9b\u5e94\u5546\u5f85\u6539\u5584")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        KpiSupplierImprove entity = (KpiSupplierImprove)this.kpiSupplierImproveService.queryObjById(id);
        if (entity != null && !ImproveStatusEnum.NEW.getValue().equals(entity.getStatus())) {
            throw new CommonException("\u53ea\u6709\u65b0\u589e\u5355\u636e\u624d\u53ef\u4ee5\u5220\u9664!");
        }
        this.kpiSupplierImproveService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u4f9b\u5e94\u5546\u5f85\u6539\u5584")
    @RequestMapping(value={"service/deleteByIdArray"})
    @ResponseBody
    public ResponseResult<String> deleteByIdArray(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u5355\u636e!");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (String id : list) {
            KpiSupplierImprove entity = (KpiSupplierImprove)this.kpiSupplierImproveService.queryObjById(id);
            if (entity != null && !ImproveStatusEnum.NEW.getValue().equals(entity.getStatus())) {
                throw new CommonException("\u53ea\u6709\u65b0\u589e\u5355\u636e\u624d\u53ef\u4ee5\u5220\u9664!");
            }
            this.kpiSupplierImproveService.deleteObjById(id);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u5f85\u6539\u5584")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiSupplierImprove", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiSupplierImprove>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        List companies;
        ArrayList<String> companyCodeList;
        KpiSupplierImproveExample example = new KpiSupplierImproveExample();
        example.setPageView((PageView<KpiSupplierImprove>)new PageView(pageNo, pageSize));
        KpiSupplierImproveExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        if (CollectionUtils.isNotEmpty((Collection)(companyCodeList = new ArrayList<String>(companies = this.companyPurRefService.queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), null)){
            final /* synthetic */ List val$companies;
            {
                this.val$companies = list;
                this.val$companies.forEach((? super T company) -> this.add(company.getCompanyCode()));
            }
        }))) {
            criteria.andSupCompanyCodeIn(companyCodeList);
        }
        example.setOrderByClause("CREATE_TIME DESC,UPDATE_TIME DESC");
        PageView pageData = this.kpiSupplierImproveService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u9001\u5f85\u6539\u5584\u4fe1\u606f\u5230\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/send"})
    @ResponseBody
    public ResponseResult<String> send(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u4f5c\u5e9f\u7684\u5355\u636e!");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (String id : list) {
            KpiSupplierImprove entity = (KpiSupplierImprove)this.kpiSupplierImproveService.queryObjById(id);
            if (Constant.YES_INT.equals(entity.getSendStatus())) {
                throw new CommonException("\u5355\u636e\u53f7" + entity.getImproveNo() + ",\u5df2\u7ecf\u53d1\u9001\u7ed9\u4f9b\u5e94\u5546\uff0c\u65e0\u9700\u91cd\u65b0\u65b0\u53d1\u5e03!");
            }
            entity.setSendStatus(Constant.YES_INT);
            entity.setStatus(ImproveStatusEnum.PUBLIC.getValue());
            entity.setUpdateUserId(user.getId());
            entity.setUpdateUserName(user.getNickName());
            entity.setUpdateTime(new Date());
            this.kpiSupplierImproveService.modifyObj(entity);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u786e\u8ba4\u56de\u590d")
    @RequestMapping(value={"service/acceptSupplierReply"})
    @ResponseBody
    public ResponseResult<String> acceptSupplierReply(@RequestBody KpiSupplierImprove kpiSupplierImprove) {
        if (kpiSupplierImprove == null) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u786e\u8ba4\u56de\u590d\u7684\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)kpiSupplierImprove.getConfirmationOpinions())) {
            throw new CommonException("\u786e\u8ba4\u9a8c\u8bc1\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        User user = SpringSecurityUtils.getLoginUser();
        KpiSupplierImprove entity = (KpiSupplierImprove)this.kpiSupplierImproveService.queryObjById(kpiSupplierImprove.getId());
        if (!ImproveStatusEnum.REPLY.getValue().equals(entity.getStatus())) {
            throw new CommonException("\u5355\u636e\u53f7" + entity.getImproveNo() + ",\u53ea\u80fd\u786e\u8ba4\u4f9b\u65b9\u56de\u590d\u7684\u5355\u636e!");
        }
        entity.setConfirmationOpinions(kpiSupplierImprove.getConfirmationOpinions());
        entity.setStatus(ImproveStatusEnum.CONFIRM.getValue());
        entity.setUpdateUserId(user.getId());
        entity.setUpdateUserName(user.getNickName());
        entity.setUpdateTime(new Date());
        this.kpiSupplierImproveService.modifyObj(entity);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u9a73\u56de\u56de\u590d")
    @RequestMapping(value={"service/refusedSupplierReply"})
    @ResponseBody
    public ResponseResult<String> refusedSupplierReply(@RequestBody KpiSupplierImprove kpiSupplierImprove) {
        if (kpiSupplierImprove == null) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u9a73\u56de\u7684\u5355\u636e!");
        }
        User user = SpringSecurityUtils.getLoginUser();
        if (StringUtils.isEmpty((String)kpiSupplierImprove.getRejectedOpinions())) {
            throw new CommonException("\u786e\u8ba4\u9a8c\u8bc1\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        KpiSupplierImprove entity = (KpiSupplierImprove)this.kpiSupplierImproveService.queryObjById(kpiSupplierImprove.getId());
        if (!ImproveStatusEnum.REPLY.getValue().equals(entity.getStatus())) {
            throw new CommonException("\u5355\u636e\u53f7" + entity.getImproveNo() + ",\u53ea\u80fd\u9a73\u56de\u4f9b\u65b9\u56de\u590d\u7684\u5355\u636e!");
        }
        entity.setRejectedOpinions(kpiSupplierImprove.getRejectedOpinions());
        entity.setStatus(ImproveStatusEnum.REFUSED.getValue());
        entity.setUpdateUserId(user.getId());
        entity.setUpdateUserName(user.getNickName());
        entity.setUpdateTime(new Date());
        this.kpiSupplierImproveService.modifyObj(entity);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4e0a\u4f20\u9644\u4ef6")
    @RequestMapping(value={"service/attachment"})
    @ResponseBody
    public ResponseResult<String> attachment(@RequestBody KpiSupplierImprove improve) {
        User user = SpringSecurityUtils.getLoginUser();
        if (StringUtils.isBlank((String)improve.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        KpiSupplierImprove entity = (KpiSupplierImprove)this.kpiSupplierImproveService.queryObjById(improve.getId());
        entity.setAttachment(improve.getAttachment());
        entity.setUpdateUserId(user.getId());
        entity.setUpdateUserName(user.getNickName());
        entity.setUpdateTime(new Date());
        this.kpiSupplierImproveService.modifyObj(entity);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u5f85\u6539\u5584(\u4f9b\u5e94\u5546)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiSupplierImprove", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/supplerFindByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiSupplierImprove>> supplerFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiSupplierImproveExample example = new KpiSupplierImproveExample();
        example.setPageView((PageView<KpiSupplierImprove>)new PageView(pageNo, pageSize));
        KpiSupplierImproveExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        criteria.andSendStatusEqualTo(Constant.YES_INT);
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC,UPDATE_TIME DESC");
        PageView pageData = this.kpiSupplierImproveService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u56de\u590d")
    @RequestMapping(value={"service/supplierReply"})
    @ResponseBody
    public ResponseResult<String> supplierReply(@RequestBody List<KpiSupplierImprove> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u8981\u56de\u590d\u7684\u6570\u636e!");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (KpiSupplierImprove item : list) {
            if (!ImproveStatusEnum.PUBLIC.getValue().equals(item.getStatus()) && !ImproveStatusEnum.REFUSED.getValue().equals(item.getStatus())) {
                throw new CommonException("\u5355\u636e\u53f7" + item.getImproveNo() + ",\u53ea\u6709\u53d1\u5e03\u3001\u9a73\u56de\u72b6\u6001\u7684\u624d\u53ef\u4ee5\u56de\u590d!");
            }
            KpiSupplierImprove entity = (KpiSupplierImprove)this.kpiSupplierImproveService.queryObjById(item.getId());
            entity.setSupplierReply(item.getSupplierReply());
            entity.setCauseAnalysis(item.getCauseAnalysis());
            entity.setCorrectiveAction(item.getCorrectiveAction());
            entity.setPrevent(item.getPrevent());
            entity.setMeasuresFixedLine(item.getMeasuresFixedLine());
            entity.setPreventOutflow(item.getPreventOutflow());
            entity.setProductionReason(item.getProductionReason());
            entity.setOutOfReason(item.getOutOfReason());
            entity.setProcessFlow(item.getProcessFlow());
            entity.setMeasuresFixedLine(item.getMeasuresFixedLine());
            entity.setImplementationPlan(item.getInspectionOfImplementation());
            entity.setStatus(ImproveStatusEnum.REPLY.getValue());
            entity.setInspectionOfImplementation(item.getInspectionOfImplementation());
            entity.setUserIds(item.getUserIds());
            entity.setUserNames(item.getUserNames());
            entity.setUpdateUserId(user.getId());
            entity.setUpdateUserName(user.getNickName());
            entity.setUpdateTime(new Date());
            this.kpiSupplierImproveService.modifyObj(entity);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5f85\u6539\u5584PDF\u5bfc\u51fa")
    @RequestMapping(value={"service/exportPDF"})
    @ResponseBody
    public ResponseResult<FileData> exportPDF(@ApiParam(value="\u5f85\u6539\u5584id") @RequestBody List<String> IdArray) {
        if (IdArray.isEmpty()) {
            throw new CommonException("\u5bfc\u51fa\u5931\u8d25\uff0c\u672a\u9009\u62e9\u5bfc\u51fa\u6570\u636e\uff01");
        }
        KpiSupplierImprove entity = (KpiSupplierImprove)this.kpiSupplierImproveService.queryObjById(IdArray.get(0));
        if (entity == null) {
            throw new CommonException("\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
        }
        FileData fileData = KpiSupplerImprovePdfPrintUntil.getPdfFile(entity);
        return ResponseResult.success((Object)fileData);
    }
}

