/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.performance.entity.KpiForm;
import com.els.base.performance.entity.KpiFormExample;
import com.els.base.performance.entity.KpiTemplate;
import com.els.base.performance.entity.KpiTemplateExample;
import com.els.base.performance.entity.KpiTemplateItemExample;
import com.els.base.performance.entity.KpiTemplateVO;
import com.els.base.performance.entity.KpiTemplateWeightExample;
import com.els.base.performance.service.KpiFormService;
import com.els.base.performance.service.KpiTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u7ee9\u6548\u7ba1\u7406-\u8bc4\u4f30\u6a21\u677f\u8868")
@Controller
@RequestMapping(value={"kpiTemplate"})
public class KpiTemplateController {
    @Resource
    protected KpiTemplateService kpiTemplateService;
    @Resource
    protected KpiFormService kpiFormService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8bc4\u4f30\u6a21\u677f\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiTemplate kpiTemplate) {
        this.kpiTemplateService.addObj(kpiTemplate);
        return ResponseResult.success();
    }

    public static int getWordCountCode(String str, String code) throws UnsupportedEncodingException {
        return str.getBytes(code).length;
    }

    @ApiOperation(httpMethod="POST", value="\u5224\u65ad\u6a21\u677f\u662f\u5426\u8bc4\u4f30\u8868\u5f15\u7528")
    @RequestMapping(value={"service/selectByIdExists"})
    @ResponseBody
    public ResponseResult<String> selectByIdExists(@RequestParam(required=true) String id, @RequestParam(required=true) String templateCode) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u67e5\u8be2\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u6a21\u677fid"});
        }
        if (StringUtils.isBlank((String)templateCode)) {
            throw new CommonException("\u67e5\u8be2\u5931\u8d25,\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u6a21\u677f\u7f16\u7801"});
        }
        KpiFormExample example = new KpiFormExample();
        KpiFormExample.Criteria criteria = example.createCriteria();
        criteria.andKpiTemplateIdEqualTo(id);
        List<KpiForm> kpiFormList = this.kpiFormService.queryAllObjByExampleCoustom(example);
        if (kpiFormList.size() > 0) {
            throw new CommonException("\u5df2\u88ab\u5176\u4ed6\u5f15\u7528\u4e0d\u80fd\u64cd\u4f5c", "existing_ref_ass", new Object[]{"\u64cd\u4f5c\u5931\u8d25\uff01\u8be5\u8bc4\u4f30\u6a21\u677f\u3010\u6a21\u677f\u7f16\u7801:" + templateCode + "\u3011", "\u5176\u4ed6\u8bc4\u4f30\u8868\u3010\u8bc4\u4f30\u8868\u7f16\u7801:" + kpiFormList.get(0).getFormCode() + "\u3011"});
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8bc4\u4f30\u6a21\u677f\u548c\u6a21\u677f\u7c7b\u522b\u6743\u91cd\u53ca\u660e\u7ec6")
    @RequestMapping(value={"service/createKpiTemplate"})
    @ResponseBody
    public ResponseResult<String> createKpiTemplate(@RequestBody KpiTemplateVO kpiTemplateVO) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((String)kpiTemplateVO.getKpiTemplate().getTemplateName())) {
            throw new CommonException("\u6a21\u677f\u540d\u79f0\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", new Object[]{"\u6a21\u677f\u540d\u79f0"});
        }
        if (kpiTemplateVO.getKpiTemplate().getTemplateName() != null && KpiTemplateController.getWordCountCode(kpiTemplateVO.getKpiTemplate().getTemplateName(), "UTF-8") > 100) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        kpiTemplateVO.setCompany(company);
        kpiTemplateVO.setUser(user);
        this.kpiTemplateService.addKpiTemplate(kpiTemplateVO);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8bc4\u4f30\u6a21\u677f\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiTemplate kpiTemplate) {
        if (StringUtils.isBlank((String)kpiTemplate.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.kpiTemplateService.modifyObj(kpiTemplate);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8bc4\u4f30\u6a21\u677f\u548c\u6a21\u677f\u7c7b\u522b\u6743\u91cd\u53ca\u660e\u7ec6")
    @RequestMapping(value={"service/editKpiTemplate"})
    @ResponseBody
    public ResponseResult<String> editKpiTemplate(@RequestBody KpiTemplateVO kpiTemplateVO) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((String)kpiTemplateVO.getKpiTemplate().getTemplateCode())) {
            throw new CommonException("\u6a21\u677f\u7f16\u7801\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", new Object[]{"\u6a21\u677f\u7f16\u7801"});
        }
        if (StringUtils.isBlank((String)kpiTemplateVO.getKpiTemplate().getTemplateName())) {
            throw new CommonException("\u6a21\u677f\u540d\u79f0\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", new Object[]{"\u6a21\u677f\u540d\u79f0"});
        }
        if (kpiTemplateVO.getKpiTemplate().getTemplateName() != null && KpiTemplateController.getWordCountCode(kpiTemplateVO.getKpiTemplate().getTemplateName(), "UTF-8") > 100) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        KpiTemplateWeightExample kpiTemplateWeightExample = new KpiTemplateWeightExample();
        KpiTemplateWeightExample.Criteria kpiTemplateWeightCriteria = kpiTemplateWeightExample.createCriteria();
        kpiTemplateWeightCriteria.andKpiTemplateIdEqualTo(kpiTemplateVO.getKpiTemplate().getId());
        kpiTemplateWeightCriteria.andTemplateCodeEqualTo(kpiTemplateVO.getKpiTemplate().getTemplateCode());
        KpiTemplateItemExample kpiTemplateItemExample = new KpiTemplateItemExample();
        KpiTemplateItemExample.Criteria criteria = kpiTemplateItemExample.createCriteria();
        criteria.andKpiTemplateIdEqualTo(kpiTemplateVO.getKpiTemplate().getId());
        criteria.andTemplateCodeEqualTo(kpiTemplateVO.getKpiTemplate().getTemplateCode());
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        kpiTemplateVO.setCompany(company);
        kpiTemplateVO.setUser(user);
        this.kpiTemplateService.editKpiTemplate(kpiTemplateVO, kpiTemplateWeightExample, kpiTemplateItemExample);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8bc4\u4f30\u6a21\u677f\u8868")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.kpiTemplateService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8bc4\u4f30\u6a21\u677f\u548c\u6a21\u677f\u7c7b\u522b\u6743\u91cd\u53ca\u660e\u7ec6")
    @RequestMapping(value={"service/deleteTemplate"})
    @ResponseBody
    public ResponseResult<String> deleteTemplate(@RequestBody KpiTemplateVO kpiTemplateVO) {
        if (StringUtils.isBlank((String)kpiTemplateVO.getKpiTemplate().getTemplateCode())) {
            throw new CommonException("\u6a21\u677f\u7f16\u7801\u4e3a\u7a7a\uff0c\u5220\u9664\u5931\u8d25");
        }
        if (StringUtils.isBlank((String)kpiTemplateVO.getKpiTemplate().getId())) {
            throw new NullPointerException("\u6a21\u677fid\u4e3a\u7a7a\uff0c\u5220\u9664\u5931\u8d25");
        }
        KpiTemplateWeightExample kpiTemplateWeightExample = new KpiTemplateWeightExample();
        KpiTemplateWeightExample.Criteria kpiTemplateWeightCriteria = kpiTemplateWeightExample.createCriteria();
        kpiTemplateWeightCriteria.andKpiTemplateIdEqualTo(kpiTemplateVO.getKpiTemplate().getId());
        kpiTemplateWeightCriteria.andTemplateCodeEqualTo(kpiTemplateVO.getKpiTemplate().getTemplateCode());
        KpiTemplateItemExample kpiTemplateItemExample = new KpiTemplateItemExample();
        KpiTemplateItemExample.Criteria criteria = kpiTemplateItemExample.createCriteria();
        criteria.andKpiTemplateIdEqualTo(kpiTemplateVO.getKpiTemplate().getId());
        criteria.andTemplateCodeEqualTo(kpiTemplateVO.getKpiTemplate().getTemplateCode());
        this.kpiTemplateService.deleteKpiTemplate(kpiTemplateVO, kpiTemplateWeightExample, kpiTemplateItemExample);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8bc4\u4f30\u6a21\u677f\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiTemplate", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiTemplate>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiTemplateExample example = new KpiTemplateExample();
        example.setPageView((PageView<KpiTemplate>)new PageView(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC ");
        KpiTemplateExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.kpiTemplateService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

