
CREATE TABLE T_BASE_MOULD (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"MOULD_TEMPORARY_CODE" VARCHAR2(255 BYTE) NULL ,
"MOULD_CODE" VARCHAR2(255 BYTE) NULL ,
"MOULD_DESC" VARCHAR2(255 BYTE) NULL ,
"MOULD_STATUS" NUMBER(7) DEFAULT 1  NULL ,
"MOULD_MODEL" VARCHAR2(255 BYTE) NULL ,
"PROJECT_NUMBER" VARCHAR2(255 BYTE) NULL ,
"ASSET_CONTRACT_NUMBER" VARCHAR2(255 BYTE) NULL ,
"BELONGED_YEAR" VARCHAR2(255 BYTE) NULL ,
"MOULD_SERIAL_NUMBER" VARCHAR2(255 BYTE) NULL ,
"MOULD_MATERIAL" VARCHAR2(255 BYTE) NULL ,
"MOULD_TAX" VARCHAR2(255 BYTE) NULL ,
"PAYMENT_STYLE_FORTY_PERCENT" VARCHAR2(255 BYTE) NULL ,
"PAYMENT_STYLE_SIXTY_PERCENT" VARCHAR2(255 BYTE) NULL ,
"MOULD_LIFETIME" NUMBER(13,2) DEFAULT 0  NULL ,
"MOULD_CONSUMED_LIFETIME" NUMBER(13,2) DEFAULT 0  NULL ,
"MOULD_REMAINDER_LIFETIME" NUMBER(13,2) DEFAULT 0  NULL ,
"MOULD_PROPERTY_RIGHT_STATE" VARCHAR2(255 BYTE) NULL ,
"MOULD_ASCRIPTION" VARCHAR2(255 BYTE) NULL ,
"STORAGE" VARCHAR2(255 BYTE) NULL ,
"LEADING_OFFICIAL" VARCHAR2(255 BYTE) NULL ,
"MANUFACTURER" VARCHAR2(255 BYTE) NULL ,
"REMARK" VARCHAR2(1000 BYTE) NULL ,
"IS_ENABLE" NUMBER(7) DEFAULT 1  NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"UPDATE_TIME" DATE NULL 
)

;
COMMENT ON TABLE T_BASE_MOULD IS '资产管理-模具主数据';
COMMENT ON COLUMN T_BASE_MOULD."ID" IS '主键';
COMMENT ON COLUMN T_BASE_MOULD."PROJECT_ID" IS '表的项目ID';
COMMENT ON COLUMN T_BASE_MOULD."PUR_COMPANY_ID" IS '采购商ID';
COMMENT ON COLUMN T_BASE_MOULD."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN T_BASE_MOULD."PUR_COMPANY_FULL_NAME" IS '采购商全称';
COMMENT ON COLUMN T_BASE_MOULD."PUR_COMPANY_NAME" IS '采购商简称';
COMMENT ON COLUMN T_BASE_MOULD."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN T_BASE_MOULD."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN T_BASE_MOULD."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN T_BASE_MOULD."SUP_COMPANY_FULL_NAME" IS '供应商全称';
COMMENT ON COLUMN T_BASE_MOULD."SUP_COMPANY_NAME" IS '供应商简称';
COMMENT ON COLUMN T_BASE_MOULD."MOULD_TEMPORARY_CODE" IS '模具临时编码';
COMMENT ON COLUMN T_BASE_MOULD."MOULD_CODE" IS '模具编号';
COMMENT ON COLUMN T_BASE_MOULD."MOULD_DESC" IS '模具描述';
COMMENT ON COLUMN T_BASE_MOULD."MOULD_STATUS" IS '模具状态(0=报废,1=合格)';
COMMENT ON COLUMN T_BASE_MOULD."MOULD_MODEL" IS '机型';
COMMENT ON COLUMN T_BASE_MOULD."PROJECT_NUMBER" IS '项目编号';
COMMENT ON COLUMN T_BASE_MOULD."ASSET_CONTRACT_NUMBER" IS '资产/合同编号';
COMMENT ON COLUMN T_BASE_MOULD."BELONGED_YEAR" IS '所属年份';
COMMENT ON COLUMN T_BASE_MOULD."MOULD_SERIAL_NUMBER" IS '模具序号';
COMMENT ON COLUMN T_BASE_MOULD."MOULD_MATERIAL" IS '模具材料';
COMMENT ON COLUMN T_BASE_MOULD."MOULD_TAX" IS '模具单价（RMB） 含17%增值税';
COMMENT ON COLUMN T_BASE_MOULD."PAYMENT_STYLE_FORTY_PERCENT" IS '付款方式首期40%';
COMMENT ON COLUMN T_BASE_MOULD."PAYMENT_STYLE_SIXTY_PERCENT" IS '付款方式首期60%';
COMMENT ON COLUMN T_BASE_MOULD."MOULD_LIFETIME" IS '模具寿命';
COMMENT ON COLUMN T_BASE_MOULD."MOULD_CONSUMED_LIFETIME" IS '模具已耗寿命次数';
COMMENT ON COLUMN T_BASE_MOULD."MOULD_REMAINDER_LIFETIME" IS '模具当前剩余寿命';
COMMENT ON COLUMN T_BASE_MOULD."MOULD_PROPERTY_RIGHT_STATE" IS '模具产权状况';
COMMENT ON COLUMN T_BASE_MOULD."MOULD_ASCRIPTION" IS '开模归属';
COMMENT ON COLUMN T_BASE_MOULD."STORAGE" IS '存放处';
COMMENT ON COLUMN T_BASE_MOULD."LEADING_OFFICIAL" IS '责任人';
COMMENT ON COLUMN T_BASE_MOULD."MANUFACTURER" IS '制造商';
COMMENT ON COLUMN T_BASE_MOULD."REMARK" IS '备注';
COMMENT ON COLUMN T_BASE_MOULD."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN T_BASE_MOULD."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN T_BASE_MOULD."UPDATE_TIME" IS '修改时间';

ALTER TABLE T_BASE_MOULD ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE T_BASE_MOULD ADD CHECK ("ID" IS NOT NULL);

ALTER TABLE T_BASE_MOULD ADD PRIMARY KEY ("ID");
