
CREATE TABLE T_BASE_MOULD_ADJUST_MATERIAL (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"ADJUST_DETAIL_ID" VARCHAR2(32 BYTE) NULL ,
"MATERIAL_CODE" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_DESC" VARCHAR2(255 BYTE) NULL ,
"IS_CALCULATED" NUMBER(7) DEFAULT 1  NULL ,
"PRODUCT_MOULD_QUANTITY" NUMBER(13,2) DEFAULT 0  NULL ,
"USED_MATERIAL" VARCHAR2(255 BYTE) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"UPDATE_TIME" DATE NULL ,
"ADJUST_ID" VARCHAR2(32 BYTE) NULL 
)

;
COMMENT ON TABLE T_BASE_MOULD_ADJUST_MATERIAL IS '资产管理-模具寿命/移模调整单物料明细单';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST_MATERIAL."ID" IS '主键';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST_MATERIAL."PROJECT_ID" IS '表的项目ID';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST_MATERIAL."ADJUST_DETAIL_ID" IS '模具寿命明细关联id';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST_MATERIAL."MATERIAL_CODE" IS '物料编码';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST_MATERIAL."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST_MATERIAL."IS_CALCULATED" IS '是否核算(0=不核算，1=核算)';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST_MATERIAL."PRODUCT_MOULD_QUANTITY" IS '出模数';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST_MATERIAL."USED_MATERIAL" IS '使用材料';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST_MATERIAL."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST_MATERIAL."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN T_BASE_MOULD_ADJUST_MATERIAL."ADJUST_ID" IS '单据关联ID';


ALTER TABLE T_BASE_MOULD_ADJUST_MATERIAL ADD CHECK ("ID" IS NOT NULL);


ALTER TABLE T_BASE_MOULD_ADJUST_MATERIAL ADD PRIMARY KEY ("ID");
