/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.notice.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.notice.common.CreateMouldNoticeCmd;
import com.els.base.mould.notice.common.PurModifyMouldNoticeCmd;
import com.els.base.mould.notice.common.SupModifyMouldNoticeCmd;
import com.els.base.mould.notice.entity.MouldNotice;
import com.els.base.mould.notice.entity.MouldNoticeExample;
import com.els.base.mould.notice.entity.MouldNoticeItem;
import com.els.base.mould.notice.entity.MouldNoticeItemExample;
import com.els.base.mould.notice.entity.MouldNoticeMaterial;
import com.els.base.mould.notice.entity.MouldNoticeMaterialExample;
import com.els.base.mould.notice.entity.MouldNoticePlan;
import com.els.base.mould.notice.entity.MouldNoticePlanExample;
import com.els.base.mould.notice.service.MouldNoticeItemService;
import com.els.base.mould.notice.service.MouldNoticeMaterialService;
import com.els.base.mould.notice.service.MouldNoticePlanService;
import com.els.base.mould.notice.service.MouldNoticeService;
import com.els.base.mould.notice.utils.TransFormUtils;
import com.els.base.mould.notice.vo.MouldNoticeColumnData;
import com.els.base.mould.notice.vo.MouldNoticeItemVO;
import com.els.base.mould.notice.vo.MouldNoticeVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u8d44\u4ea7\u7ba1\u7406-\u5f00\u6a21\u53d8\u66f4\u901a\u77e5\u5355")
@Controller
@RequestMapping(value={"mouldNotice"})
public class MouldNoticeController {
    @Resource
    private MouldInvorker invoker;
    @Resource
    private MouldNoticeService mouldNoticeService;
    @Resource
    private MouldNoticeItemService mouldNoticeItemService;
    @Resource
    private MouldNoticePlanService mouldNoticePlanService;
    @Resource
    private MouldNoticeMaterialService mouldNoticeMaterialService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8d44\u4ea7\u7ba1\u7406-\u5f00\u6a21\u53d8\u66f4\u901a\u77e5\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody MouldNoticeVO vo) {
        CreateMouldNoticeCmd cmd = new CreateMouldNoticeCmd(vo);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u901a\u77e5\u5355(\u91c7\u8d2d\u65b9)")
    @RequestMapping(value={"service/pur/modifyData"})
    @ResponseBody
    public ResponseResult<String> modifyDataForPur(@RequestBody MouldNoticeVO vo) {
        Assert.isNotBlank(vo.getId(), "id\u4e3a\u7a7a,\u4fee\u6539\u5355\u636e\u5931\u8d25!");
        MouldNoticeExample example = new MouldNoticeExample();
        example.createCriteria().andIdEqualTo(vo.getId()).andSendStatusEqualTo(Constant.YES_INT).andIsEnableEqualTo(Constant.YES_INT);
        List list = this.mouldNoticeService.queryAllObjByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new CommonException("\u8be5\u5355\u636e\u5df2\u53d1\u9001\u7ed9\u4f9b\u5e94\u5546,\u65e0\u6cd5\u4fee\u6539\u6570\u636e!");
        }
        PurModifyMouldNoticeCmd cmd = new PurModifyMouldNoticeCmd(vo);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u901a\u77e5\u5355(\u4f9b\u5e94\u5546\u65b9)")
    @RequestMapping(value={"service/sup/modifyData"})
    @ResponseBody
    public ResponseResult<String> modifyDataForSup(@RequestBody MouldNoticeVO vo) {
        Assert.isNotBlank(vo.getId(), "id\u4e3a\u7a7a,\u4fee\u6539\u5355\u636e\u5931\u8d25!");
        SupModifyMouldNoticeCmd cmd = new SupModifyMouldNoticeCmd(vo);
        cmd.setSupUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setSupCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u66f4\u65b0\u4f9b\u5e94\u5546\u9644\u4ef6(\u4f9b\u5e94\u5546\u65b9)")
    @RequestMapping(value={"service/sup/uploadSupAttachment"})
    @ResponseBody
    public ResponseResult<String> uploadSupAttachment(@RequestBody MouldNotice notice) {
        Assert.isNotBlank(notice.getId(), "id\u4e3a\u7a7a,\u4fee\u6539\u5355\u636e\u5931\u8d25!");
        this.mouldNoticeService.modifyObj(notice);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u53d1\u9001\u901a\u77e5\u5355")
    @RequestMapping(value={"service/pur/sendToSup"})
    @ResponseBody
    public ResponseResult<String> sendToSup(@RequestBody List<String> ids) {
        this.mouldNoticeService.sendToSup(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u786e\u8ba4\u901a\u77e5\u5355")
    @RequestMapping(value={"service/sup/confirmMouldNotices"})
    @ResponseBody
    public ResponseResult<String> confirmMouldNotices(@RequestBody List<String> ids) {
        this.mouldNoticeService.confirmMouldNotices(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u8d44\u4ea7\u7ba1\u7406-\u5f00\u6a21\u53d8\u66f4\u901a\u77e5\u5355")
    @RequestMapping(value={"service/deleteMouldNotices"})
    @ResponseBody
    public ResponseResult<String> deleteMouldNotices(@RequestBody List<String> ids) {
        Assert.isNotNull(ids, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.mouldNoticeService.deleteMouldNotices(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u6a21\u5177id\u751f\u6210\u5355\u636e\u884c\u4fe1\u606f")
    @RequestMapping(value={"service/pur/generateNoticeItemByMouldId"})
    @ResponseBody
    public ResponseResult<List<MouldNoticeItemVO>> generateNoticeItemByMouldId(@RequestBody List<String> mouldIds) {
        List<MouldNoticeItemVO> list = this.mouldNoticeService.generateNoticeItemByMouldId(mouldIds);
        return ResponseResult.success(list);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u5355\u636e\u660e\u7ec6")
    @RequestMapping(value={"service/findDetailById"})
    @ResponseBody
    public ResponseResult<MouldNoticeVO> findDetailById(@RequestParam String id) {
        Assert.isNotBlank(id, "id\u4e0d\u80fd\u4e3a\u7a7a!");
        MouldNotice mouldNotice = (MouldNotice)this.mouldNoticeService.queryObjById(id);
        if (null == mouldNotice) {
            throw new CommonException("\u67e5\u5230\u7684\u5355\u636e\u4fe1\u606f\u4e3a\u7a7a!");
        }
        MouldNoticeVO vo = new MouldNoticeVO();
        BeanUtils.copyProperties((Object)mouldNotice, (Object)vo);
        MouldNoticeItemExample itemExample = new MouldNoticeItemExample();
        itemExample.createCriteria().andMouldNoticeIdEqualTo(id);
        List noticeItemList = this.mouldNoticeItemService.queryAllObjByExample(itemExample);
        if (CollectionUtils.isEmpty(noticeItemList)) {
            return ResponseResult.success(vo);
        }
        ArrayList<MouldNoticeItemVO> itemVoList = new ArrayList<MouldNoticeItemVO>();
        for (MouldNoticeItem item : noticeItemList) {
            MouldNoticeItemVO itemVo = new MouldNoticeItemVO();
            BeanUtils.copyProperties((Object)item, (Object)itemVo);
            MouldNoticePlanExample planExample = new MouldNoticePlanExample();
            planExample.setOrderByClause("PLAN_INDEX ASC");
            planExample.createCriteria().andNoticeItemIdEqualTo(item.getId());
            List<MouldNoticePlan> noticePlanList = this.mouldNoticePlanService.queryAllObjByExample(planExample);
            List<Map<String, MouldNoticeColumnData>> planList = TransFormUtils.transform(noticePlanList);
            itemVo.setPlanList(planList);
            MouldNoticeMaterialExample materialExample = new MouldNoticeMaterialExample();
            materialExample.createCriteria().andNoticeItemIdEqualTo(item.getId());
            List<MouldNoticeMaterial> materialList = this.mouldNoticeMaterialService.queryAllObjByExample(materialExample);
            itemVo.setMaterialList(materialList);
            itemVoList.add(itemVo);
        }
        vo.setItemVoList(itemVoList);
        return ResponseResult.success(vo);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8d44\u4ea7\u7ba1\u7406-\u5f00\u6a21\u53d8\u66f4\u901a\u77e5\u5355(\u91c7\u8d2d\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MouldNotice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MouldNotice>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MouldNoticeExample example = new MouldNoticeExample();
        example.setPageView(new PageView<MouldNotice>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        MouldNoticeExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.mouldNoticeService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8d44\u4ea7\u7ba1\u7406-\u5f00\u6a21\u53d8\u66f4\u901a\u77e5\u5355(\u91c7\u8d2d\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MouldNotice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MouldNotice>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MouldNoticeExample example = new MouldNoticeExample();
        example.setPageView(new PageView<MouldNotice>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        MouldNoticeExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andSendStatusEqualTo(Constant.YES_INT).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.mouldNoticeService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}

