/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.utils;

import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.utils.PurchaseOrderDeliveryStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderIsEnableEnum;
import java.util.List;

public abstract class PurchaseOrderUtils {
    public static Integer isAllItemEnable(List<PurchaseOrderItem> items) {
        int deleteCount = 0;
        int freezeCount = 0;
        for (PurchaseOrderItem item : items) {
            if (PurchaseOrderIsEnableEnum.DELETED.getValue().equals(item.getIsEnable())) {
                ++deleteCount;
            }
            if (!PurchaseOrderIsEnableEnum.FREEZE.getValue().equals(item.getIsEnable())) continue;
            ++freezeCount;
        }
        if (deleteCount == items.size()) {
            return PurchaseOrderIsEnableEnum.DELETED.getValue();
        }
        if (freezeCount == items.size()) {
            return PurchaseOrderIsEnableEnum.FREEZE.getValue();
        }
        if (freezeCount + deleteCount >= items.size()) {
            return PurchaseOrderIsEnableEnum.FREEZE.getValue();
        }
        return PurchaseOrderIsEnableEnum.ENABLE.getValue();
    }

    public static Integer isAllItemFinish(List<PurchaseOrderItem> items) {
        int finishItemCount = 0;
        for (PurchaseOrderItem item : items) {
            if (!"Y".equals(item.getFinishFlag())) continue;
            ++finishItemCount;
        }
        if (finishItemCount == 0) {
            return PurchaseOrderDeliveryStatusEnum.RECEVIED_NONE.getValue();
        }
        if (finishItemCount == items.size()) {
            return PurchaseOrderDeliveryStatusEnum.RECEIVED_ALL.getValue();
        }
        return PurchaseOrderDeliveryStatusEnum.RECEIVED_PART.getValue();
    }
}

