/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.web.controller;

import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.entity.SupplierOrderItemExample;
import com.els.base.purchase.service.SupplierOrderItemService;
import com.els.base.purchase.service.SupplierOrderService;
import com.els.base.purchase.utils.PurchaseOrderInterTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderStatusEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u9500\u552e\u8ba2\u5355\u884c")
@Controller
@RequestMapping(value={"supplierOrderItem"})
public class SupplierOrderItemController {
    @Resource
    protected SupplierOrderItemService supplierOrderItemService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected SupplierOrderService supplierOrderService;

    @ApiOperation(httpMethod="POST", value="\u901a\u8fc7\u9500\u552e\u8ba2\u5355\u53f7\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u884c")
    @RequestMapping(value={"service/findBySupplierOrder"})
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderItem>> findBySupplierOrder(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u91c7\u8d2d\u8ba2\u5355\u53f7") String orderId, @ApiParam(value="\u662f\u5426\u5b8c\u6210\u6807\u8bc6") String finishFlag) {
        if (StringUtils.isBlank((String)orderId)) {
            throw new CommonException("\u67e5\u8be2\u5931\u8d25,\u91c7\u8d2d\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728", "do_not_exists", "\u91c7\u8d2d\u8ba2\u5355\u53f7");
        }
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.setPageView(new PageView<SupplierOrderItem>(pageNo, pageSize));
        SupplierOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andOrderIdEqualTo(orderId);
        criteria.andIsEnableNotEqualTo(0);
        if (finishFlag != null) {
            criteria.andFinishFlagEqualTo(finishFlag);
        }
        example.setOrderByClause("HAVE_CHANGE DESC, MATERIAL_CODE ASC, ORDER_ITEM_NO ASC");
        PageView pageData = this.supplierOrderItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u9001\u8d27\uff0c\u65b0\u5efa\u9001\u8d27\u5355\u5217\u8868")
    @RequestMapping(value={"service/findSupplierOrderItemByPage"})
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderItem>> findSupplierOrderItemByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper queryParams) {
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.setPageView(new PageView<SupplierOrderItem>(pageNo, pageSize));
        example.setOrderByClause("MATERIAL_CODE ASC, ORDER_ITEM_NO ASC");
        example.createCriteria().andCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andProjectIdEqualTo(ProjectUtils.getProjectId()).andDeliveryAmountGreaterThan(0L).andInterTypeNotEqualTo(PurchaseOrderInterTypeEnum.FOR_HK.getValue());
        example.or().andCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andProjectIdEqualTo(ProjectUtils.getProjectId()).andDeliveryAmountGreaterThan(0L).andInterTypeIsNull();
        if (queryParams != null) {
            for (int i = 0; i < example.getOredCriteria().size(); ++i) {
                CriteriaUtils.addCriterion(example.getOredCriteria().get(i), queryParams);
            }
        }
        PageView<SupplierOrderItem> pageData = this.supplierOrderItemService.querySupplierOrderItemByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u65b0\u5efa\u9884\u4ed8\u6b3e\u5355\u67e5\u8be2\u754c\u9762")
    @RequestMapping(value={"service/findAdvancedPayBillByPage"})
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderItem>> findAdvancedPayBillByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper queryParams) {
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.setPageView(new PageView<SupplierOrderItem>(pageNo, pageSize));
        example.setOrderByClause("MATERIAL_CODE ASC, ORDER_ITEM_NO ASC");
        SupplierOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andProjectIdEqualTo(ProjectUtils.getProjectId()).andIsEnableEqualTo(Constant.YES_INT).andOrderStatusEqualTo(PurchaseOrderStatusEnum.CONFIRM.getValue()).andFinishFlagEqualTo("N").andAvailableApplyMoneyGreaterThan(BigDecimal.ZERO);
        if (queryParams != null) {
            CriteriaUtils.addCriterion(criteria, queryParams);
        }
        PageView pageData = this.supplierOrderItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5206\u9875\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u884c\uff1a\u91c7\u7528\u539f\u6765\u65e7\u7684\u4f20\u503c\u65b9\u5f0f")
    @RequestMapping(value={"service/findSupplierOrderItemByPageForInvoice"})
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderItem>> findSupplierOrderItemByPageForInvoice(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper queryParamWapper) throws ParseException {
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.setPageView(new PageView<SupplierOrderItem>(pageNo, pageSize));
        example.setOrderByClause("SUP_MATERIAL_CODE ASC, ORDER_ITEM_NO ASC");
        SupplierOrderItemExample.Criteria cri = example.createCriteria().andCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andProjectIdEqualTo(ProjectUtils.getProjectId()).andInterTypeEqualTo("3");
        if (queryParamWapper != null) {
            CriteriaUtils.addCriterion(cri, queryParamWapper);
        }
        PageView<SupplierOrderItem> pageData = this.supplierOrderItemService.querySupplierOrderItemByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5206\u9875\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u884c\uff08\u91c7\u8d2d\u65b9\uff09\uff1a\u91c7\u7528\u539f\u6765\u65e7\u7684\u4f20\u503c\u65b9\u5f0f")
    @RequestMapping(value={"service/findSupplierOrderItemForPurchaseByPageForInvoice"})
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderItem>> findSupplierOrderItemForPurchaseByPageForInvoice(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper queryParamWapper) throws ParseException {
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.setPageView(new PageView<SupplierOrderItem>(pageNo, pageSize));
        example.setOrderByClause("MATERIAL_CODE ASC, ORDER_ITEM_NO ASC");
        SupplierOrderItemExample.Criteria cri = example.createCriteria().andPurCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andProjectIdEqualTo(ProjectUtils.getProjectId()).andInterTypeEqualTo("3");
        if (queryParamWapper != null) {
            CriteriaUtils.addCriterion(cri, queryParamWapper);
        }
        PageView<SupplierOrderItem> pageData = this.supplierOrderItemService.querySupplierOrderItemByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5206\u9875\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u884c")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderItem>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u901a\u7528\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=true) QueryParamWapper wapper) {
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.setPageView(new PageView<SupplierOrderItem>(pageNo, pageSize));
        SupplierOrderItemExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        example.setOrderByClause("HAVE_CHANGE DESC, MATERIAL_CODE ASC, ORDER_ITEM_NO ASC");
        PageView pageData = this.supplierOrderItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u9500\u552e\u8ba2\u5355\u884c")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody List<SupplierOrderItem> supplierOrderItemList) {
        Assert.isNotNull(supplierOrderItemList, "\u4fdd\u5b58\u5931\u8d25");
        supplierOrderItemList.forEach(supplierOrderItem -> this.supplierOrderItemService.modifyObj(supplierOrderItem));
        return ResponseResult.success();
    }
}

