/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.command.order.CreateOrderItemCommand;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class CreateOrderCommand
extends AbstractOrderCommand<String> {
    private PurchaseOrder order;

    public CreateOrderCommand(PurchaseOrder order) {
        this.order = order;
    }

    @Override
    public String execute(OrderComandInvoker context) {
        this.valid(this.order);
        this.initOrder(this.order);
        for (PurchaseOrderItem item : this.order.getItems()) {
            Assert.isNotBlank(this.order.getId(), "\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
            CreateOrderItemCommand createOrderItemCommand = new CreateOrderItemCommand(item, this.order);
            createOrderItemCommand.copyProperties(this);
            context.invoke(createOrderItemCommand);
        }
        this.context.getPurchaseOrderService().addObj(this.order);
        return null;
    }

    private void valid(PurchaseOrder order) {
        Assert.isNotBlank(order.getOrderNo(), "\u91c7\u8d2d\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(order.getCompanyId(), "\u91c7\u8d2d\u65b9id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(order.getCompanyCode(), "\u91c7\u8d2d\u65b9SRM\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(order.getCompanyName(), "\u91c7\u8d2d\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(order.getSupCompanyId(), "\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(order.getSupCompanyName(), "\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(order.getPurSapCompanyCode(), "\u4f9b\u5e94\u5546sap code \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(order.getItems(), "\u91c7\u8d2d\u8ba2\u5355\u884c\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void initOrder(PurchaseOrder purchaseOrder) {
        purchaseOrder.setId(UUIDGenerator.generateUUID());
        purchaseOrder.setOrderStatus(PurchaseOrderStatusEnum.UNCONFIRM.getValue());
        purchaseOrder.setOrderSendStatus(PurchaseOrderSendStatusEnum.NOTSEND.getValue());
        purchaseOrder.setCreateTime(new Date());
        if (purchaseOrder.getAuditStatus() == null) {
            purchaseOrder.setAuditStatus(Constant.YES_INT);
        }
        if (StringUtils.isBlank((String)purchaseOrder.getIsAudit())) {
            purchaseOrder.setIsAudit("Y");
        }
        if (purchaseOrder.getDeliveryStatus() == null) {
            purchaseOrder.setDeliveryStatus(PurchaseOrderUtils.isAllItemFinish(purchaseOrder.getItems()));
        }
        if (purchaseOrder.getIsEnable() == null) {
            purchaseOrder.setIsEnable(PurchaseOrderUtils.isAllItemEnable(purchaseOrder.getItems()));
        }
    }
}

