/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.purchase.dao.SupplierOrderMapper;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderExample;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.entity.SupplierOrderItemExample;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.service.SupplierOrderItemService;
import com.els.base.purchase.service.SupplierOrderService;
import com.els.base.purchase.utils.OrderBusinessTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderStatusEnum;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="supplierOrderService")
public class SupplierOrderServiceImpl
implements SupplierOrderService {
    @Resource
    protected SupplierOrderMapper supplierOrderMapper;
    @Resource
    protected SupplierOrderItemService supplierOrderItemService;
    @Resource
    protected PurchaseOrderService purchaseOrderService;
    @Resource
    protected PurchaseOrderItemService purchaseOrderItemService;

    @Override
    @CacheEvict(value={"supplierOrder"}, allEntries=true)
    public void addObj(SupplierOrder t) {
        this.supplierOrderMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"supplierOrder"}, allEntries=true)
    public void deleteObjById(String id) {
        this.supplierOrderMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"supplierOrder"}, allEntries=true)
    public void modifyObj(SupplierOrder t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.supplierOrderMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"supplierOrder"}, keyGenerator="redisKeyGenerator")
    public SupplierOrder queryObjById(String id) {
        return this.supplierOrderMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"supplierOrder"}, keyGenerator="redisKeyGenerator")
    public List<SupplierOrder> queryAllObjByExample(SupplierOrderExample example) {
        return this.supplierOrderMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"supplierOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<SupplierOrder> queryObjByPage(SupplierOrderExample example) {
        PageView<SupplierOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.supplierOrderMapper.selectByExampleByPage(example));
        return pageView;
    }

    public SupplierOrder getNewestOrder(String id) {
        SupplierOrder supplierOrderTemp = new SupplierOrder();
        SupplierOrderExample example = new SupplierOrderExample();
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(PurchaseOrderStatusEnum.CONFIRM.getValue());
        values.add(PurchaseOrderStatusEnum.PART_BACK.getValue());
        example.createCriteria().andIdEqualTo(id).andOrderStatusIn(values);
        example.setOrderByClause("LAST_UPDATE_TIME DESC");
        List<SupplierOrder> supplierOrderList = this.supplierOrderMapper.selectHisByExampleByPage(example);
        if (CollectionUtils.isNotEmpty(supplierOrderList)) {
            supplierOrderTemp = supplierOrderList.get(0);
            return supplierOrderTemp;
        }
        return null;
    }

    public SupplierOrderItem getNewestOrderItem(String id) {
        SupplierOrderItem supplierOrderItemTemp = new SupplierOrderItem();
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.createCriteria().andIdEqualTo(id).andOrderStatusEqualTo(PurchaseOrderStatusEnum.CONFIRM.getValue());
        example.setOrderByClause("UPDATE_TIME DESC");
        List supplierOrderItemList = this.supplierOrderItemService.queryAllObjByExample(example);
        if (CollectionUtils.isNotEmpty(supplierOrderItemList)) {
            supplierOrderItemTemp = (SupplierOrderItem)supplierOrderItemList.get(0);
            return supplierOrderItemTemp;
        }
        return null;
    }

    @Override
    public String insertHis(String orderId, String cause) {
        String hisOrderId = UUIDGenerator.generateUUID();
        this.supplierOrderMapper.insertHis(hisOrderId, orderId, cause);
        return hisOrderId;
    }

    public void sendToPurchase(SupplierOrder supplierOrder) {
        PurchaseOrder record = new PurchaseOrder();
        record = (PurchaseOrder)this.purchaseOrderService.queryObjById(supplierOrder.getId());
        if (record != null) {
            record.setSupRemark(supplierOrder.getSupRemark());
            record.setOrderStatus(supplierOrder.getOrderStatus());
            record.setLastUpdateTime(new Date());
            PurchaseOrderExample example = new PurchaseOrderExample();
            example.createCriteria().andOrderNoEqualTo(supplierOrder.getOrderNo()).andSupCompanySapCodeEqualTo(supplierOrder.getCompanySapCode());
            this.purchaseOrderService.updateByPurcahseOrder(record, example);
        }
        List<SupplierOrderItem> supplierOrderItems = supplierOrder.getItems();
        for (SupplierOrderItem supplierOrderItem : supplierOrderItems) {
            PurchaseOrderItem recordItem = new PurchaseOrderItem();
            recordItem = (PurchaseOrderItem)this.purchaseOrderItemService.queryObjById(supplierOrderItem.getId());
            if (recordItem == null) continue;
            recordItem.setSupRemark(supplierOrderItem.getSupRemark());
            recordItem.setOrderStatus(supplierOrderItem.getOrderStatus());
            PurchaseOrderItemExample exampleItem = new PurchaseOrderItemExample();
            ArrayList<Integer> isEnableValues = new ArrayList<Integer>();
            isEnableValues.add(1);
            isEnableValues.add(2);
            exampleItem.createCriteria().andIsEnableIn(isEnableValues).andSupCompanyIdEqualTo(supplierOrderItem.getCompanyId()).andOrderNoEqualTo(supplierOrder.getOrderNo()).andOrderItemNoEqualTo(supplierOrderItem.getOrderItemNo());
            this.purchaseOrderItemService.updateByPurcahseOrder(recordItem, exampleItem);
        }
        Message message = Message.init((Object)supplierOrder).setCompanyCode(supplierOrder.getCompanySapCode()).setSenderId(supplierOrder.getUserId()).addReceiverId(supplierOrder.getPurUserId()).setMsgLevel(MessageLevelEnum.HIGH);
        if (supplierOrder.getOrderStatus() == PurchaseOrderStatusEnum.BACK.getValue()) {
            message.setBusinessTypeCode(OrderBusinessTypeEnum.PO_ALL_BACK.getCode());
        } else if (supplierOrder.getOrderStatus() == PurchaseOrderStatusEnum.PART_BACK.getValue()) {
            message.setBusinessTypeCode(OrderBusinessTypeEnum.PO_ALL_BACK.getCode());
        } else {
            message.setBusinessTypeCode(OrderBusinessTypeEnum.PO_CONFIRM.getCode());
        }
        MessageSendUtils.sendMessage((Message)message);
    }

    @Override
    @CacheEvict(value={"supplierOrder"}, allEntries=true)
    public void updateBySupplierOrder(SupplierOrder record, SupplierOrderExample example) {
        this.supplierOrderMapper.updateByExampleSelective(record, example);
    }

    @Override
    public void isHaveNewOrder(SupplierOrder supplierOrder) {
        PurchaseOrder purchaseOrder;
        List purchaseOrders;
        PurchaseOrderExample example = new PurchaseOrderExample();
        PurchaseOrderExample.Criteria criteria = example.createCriteria();
        criteria.andOrderNoEqualTo(supplierOrder.getOrderNo());
        if (StringUtils.isNotBlank((String)supplierOrder.getCompanySapCode())) {
            criteria.andSupCompanySapCodeEqualTo(supplierOrder.getCompanySapCode());
        }
        if (StringUtils.isNotBlank((String)supplierOrder.getCompanyId())) {
            criteria.andSupCompanyIdEqualTo(supplierOrder.getCompanyId());
        }
        if (CollectionUtils.isNotEmpty(purchaseOrders = this.purchaseOrderService.queryAllObjByExample(example)) && (purchaseOrder = (PurchaseOrder)purchaseOrders.get(0)) != null && purchaseOrder.getOrderSendStatus() == PurchaseOrderSendStatusEnum.UPDATE_NOTSEND.getValue()) {
            throw new CommonException("\u6b64\u8ba2\u5355\u5ba2\u6237\u5df2\u53d8\u66f4\uff0c\u4e0d\u53ef\u64cd\u4f5c\uff01");
        }
    }

    @Override
    public PageView<SupplierOrder> findByPageForAvaliableOrder(SupplierOrderExample example) {
        PageView<SupplierOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.supplierOrderMapper.selectVisableOrderByExampleByPage(example));
        return pageView;
    }

    @Override
    public boolean isSameType(Set<String> orderIdList) {
        boolean boo = true;
        ArrayList idList = new ArrayList();
        CollectionUtils.addAll(idList, orderIdList.iterator());
        SupplierOrderExample example = new SupplierOrderExample();
        example.createCriteria().andIdIn((List)idList);
        List<SupplierOrder> list = this.queryAllObjByExample(example);
        String type = null;
        for (SupplierOrder order : list) {
            if (type == null) {
                type = order.getVoucherType();
                continue;
            }
            if (type.equals(order.getVoucherType())) continue;
            return false;
        }
        return boo;
    }

    @Override
    @Cacheable(value={"supplierOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<SupplierOrder> queryAllHisOrderByExample(SupplierOrderExample example) {
        PageView<SupplierOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.supplierOrderMapper.selectHisByExampleByPage(example));
        return pageView;
    }
}

