/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.event;

import com.els.base.core.event.BaseEvent;
import com.els.base.core.exception.CommonException;
import com.els.base.utils.json.JsonUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Iterator;

public class BaseEventDeserializer
extends JsonDeserializer<BaseEvent> {
    public BaseEvent deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken currentToken = jp.getCurrentToken();
        if (currentToken != JsonToken.START_OBJECT) {
            throw new CommonException("\u53c2\u6570\u683c\u5f0f\u5f02\u5e38\uff0c\u65e0\u6cd5\u89e3\u6790", "unable_to_parse");
        }
        ObjectNode objectNode = (ObjectNode)jp.readValueAsTree();
        if (objectNode == null) {
            return null;
        }
        String projectId = null;
        String sourceJson = null;
        String sourceClass = null;
        String eventClass = null;
        Long timestamp = null;
        Iterator fieldNameIterator = objectNode.fieldNames();
        while (fieldNameIterator.hasNext()) {
            String fieldName;
            switch (fieldName = (String)fieldNameIterator.next()) {
                case "projectId": {
                    JsonNode projectIdField = objectNode.get(fieldName);
                    if (projectIdField.isNull()) break;
                    projectId = projectIdField.asText();
                    break;
                }
                case "source": {
                    JsonNode sourceField = objectNode.get(fieldName);
                    if (sourceField.isNull()) break;
                    sourceJson = sourceField.toString();
                    break;
                }
                case "sourceClass": {
                    TextNode sourceClassField = (TextNode)objectNode.get(fieldName);
                    sourceClass = sourceClassField.asText();
                    break;
                }
                case "eventClass": {
                    TextNode eventClassField = (TextNode)objectNode.get(fieldName);
                    eventClass = eventClassField.asText();
                    break;
                }
                case "timestamp": {
                    JsonNode timestampField = objectNode.get(fieldName);
                    if (timestampField.isNull()) break;
                    timestamp = timestampField.asLong();
                    break;
                }
            }
        }
        try {
            Object source = JsonUtils.convertValue(sourceJson, Class.forName(sourceClass));
            Constructor<?> constructor = Class.forName(eventClass).getConstructor(Object.class);
            BaseEvent baseEvent = (BaseEvent)((Object)constructor.newInstance(source));
            baseEvent.setProjectId(projectId);
            baseEvent.setTimestamp(timestamp);
            return baseEvent;
        }
        catch (Exception e) {
            throw new RuntimeException("baseEven json \u53cd\u5e8f\u5217\u5931\u8d25, json:\n" + objectNode.toString(), e);
        }
    }
}

