/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.adjust.service.impl;

import com.els.base.auth.entity.User;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.mould.adjust.dao.MouldAdjustMapper;
import com.els.base.mould.adjust.entity.MouldAdjust;
import com.els.base.mould.adjust.entity.MouldAdjustDetail;
import com.els.base.mould.adjust.entity.MouldAdjustDetailExample;
import com.els.base.mould.adjust.entity.MouldAdjustExample;
import com.els.base.mould.adjust.entity.MouldAdjustMaterial;
import com.els.base.mould.adjust.entity.MouldAdjustMaterialExample;
import com.els.base.mould.adjust.service.MouldAdjustDetailService;
import com.els.base.mould.adjust.service.MouldAdjustMaterialService;
import com.els.base.mould.adjust.service.MouldAdjustService;
import com.els.base.mould.adjust.util.ChangeTypeEnum;
import com.els.base.mould.adjust.vo.AdjustDetailVo;
import com.els.base.mould.his.entity.MouldAdjustHis;
import com.els.base.mould.his.service.MouldAdjustHisService;
import com.els.base.mould.im.MouldImTemplete;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.master.entity.MouldMaterial;
import com.els.base.mould.master.entity.MouldMaterialExample;
import com.els.base.mould.master.service.MouldMaterialService;
import com.els.base.mould.master.service.MouldService;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultMouldAdjustService")
public class MouldAdjustServiceImpl
implements MouldAdjustService {
    private static final String IM_CODE = "MOULD_ADJUST_IM";
    @Resource
    protected MouldAdjustMapper mouldAdjustMapper;
    @Resource
    protected ThreadPoolTaskExecutor defaultThreadPool;
    @Resource
    protected MouldService mouldService;
    @Resource
    protected MouldMaterialService mouldMaterialService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    protected MouldAdjustDetailService mouldAdjustDetailService;
    @Resource
    protected MouldAdjustHisService mouldAdjustHisService;
    @Resource
    protected MouldAdjustMaterialService mouldAdjustMaterialService;

    @Override
    @CacheEvict(value={"mouldAdjust"}, allEntries=true)
    public void addObj(MouldAdjust t) {
        this.mouldAdjustMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"mouldAdjust"}, allEntries=true)
    public void deleteObjById(String id) {
        this.mouldAdjustMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"mouldAdjust"}, allEntries=true)
    public void modifyObj(MouldAdjust t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.mouldAdjustMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"mouldAdjust"}, keyGenerator="redisKeyGenerator")
    public MouldAdjust queryObjById(String id) {
        return this.mouldAdjustMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"mouldAdjust"}, keyGenerator="redisKeyGenerator")
    public List<MouldAdjust> queryAllObjByExample(MouldAdjustExample example) {
        return this.mouldAdjustMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"mouldAdjust"}, keyGenerator="redisKeyGenerator")
    public PageView<MouldAdjust> queryObjByPage(MouldAdjustExample example) {
        PageView<MouldAdjust> pageView = example.getPageView();
        pageView.setQueryResult(this.mouldAdjustMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"mouldAdjust"}, allEntries=true)
    public void deleteAdjusts(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u5220\u9664!");
        }
        MouldAdjustExample example = new MouldAdjustExample();
        example.createCriteria().andIdIn((List)ids).andSendStatusEqualTo(Constant.YES_INT);
        if (this.mouldAdjustMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u5df2\u53d1\u9001\u7684\u5355\u636e,\u65e0\u6cd5\u5220\u9664\u5355\u636e!");
        }
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        MouldAdjust mouldAdjust = new MouldAdjust();
        mouldAdjust.setIsEnable(Constant.NO_INT);
        mouldAdjust.setUpdateTime(new Date());
        this.mouldAdjustMapper.updateByExampleSelective(mouldAdjust, example);
    }

    @Override
    @CacheEvict(value={"mouldAdjust"}, allEntries=true)
    public void sendToSup(final User loginUser, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u4f20\u9012\u7684id\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u53d1\u9001\u5355\u636e!");
        }
        MouldAdjustExample adjustExample = new MouldAdjustExample();
        adjustExample.createCriteria().andIdIn((List)ids).andSendStatusEqualTo(Constant.YES_INT);
        if (this.mouldAdjustMapper.countByExample(adjustExample) > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u5df2\u53d1\u9001\u5355\u636e,\u4e0d\u80fd\u518d\u64cd\u4f5c!");
        }
        adjustExample.clear();
        adjustExample.createCriteria().andIdIn((List)ids);
        MouldAdjust mouldAdjust = new MouldAdjust();
        mouldAdjust.setPurUserId(loginUser.getId());
        mouldAdjust.setSendStatus(Constant.YES_INT);
        mouldAdjust.setSendTime(new Date());
        this.mouldAdjustMapper.updateByExampleSelective(mouldAdjust, adjustExample);
        final List<MouldAdjust> list = this.queryAllObjByExample(adjustExample);
        Map<String, List<MouldAdjust>> group = this.groupMouldNotice(list);
        if (group == null) {
            return;
        }
        Set<String> keySet = group.keySet();
        for (String key : keySet) {
            final List<MouldAdjust> adjustList = group.get(key);
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    MouldImTemplete tem = MouldAdjustServiceImpl.this.constructImInfo(1, "\u53d1\u9001", adjustList);
                    MouldAdjustServiceImpl.this.sendMessagesToSup(loginUser, tem, (MouldAdjust)list.get(0));
                }
            });
        }
    }

    public void sendMessagesToSup(User loginUser, MouldImTemplete tem, MouldAdjust mouldAdjust) {
        com.els.base.core.entity.user.User supUser = this.companyUserRefService.queryMainUserOfCompany(mouldAdjust.getSupCompanyId());
        Message message = Message.init((Object)tem).setBusinessTypeCode(IM_CODE).setCompanyCode(mouldAdjust.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    private MouldImTemplete constructImInfo(int role, String operate, List<MouldAdjust> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u5217\u8868\u4e3a\u7a7a,\u65e0\u6cd5\u751f\u6210\u6d88\u606f\u6a21\u677f!");
        }
        MouldImTemplete tem = new MouldImTemplete();
        if (role == 1) {
            tem.setRole("\u91c7\u8d2d\u5546");
            if (StringUtils.isNotEmpty((String)list.get(0).getPurCompanyName())) {
                tem.setCompanyName(list.get(0).getPurCompanyName());
            } else {
                tem.setCompanyName("");
            }
        } else {
            tem.setRole("\u4f9b\u5e94\u5546");
            if (StringUtils.isNotEmpty((String)list.get(0).getSupCompanyName())) {
                tem.setCompanyName(list.get(0).getSupCompanyName());
            } else {
                tem.setCompanyName("");
            }
        }
        Assert.isNotBlank(operate, "\u6ca1\u6709\u4f20\u5165\u64cd\u4f5c\u5b57\u6bb5,\u65e0\u6cd5\u751f\u6210\u6d88\u606f\u6a21\u677f!");
        tem.setOperate(operate);
        tem.setOtherInfo("\u4e86\u65b0\u7684\u6a21\u5177\u5bff\u547d/\u79fb\u6a21\u8c03\u6574\u5355,\u5355\u636e\u53f7\u5305\u62ec\uff1a");
        ArrayList<String> noList = new ArrayList<String>();
        for (MouldAdjust item : list) {
            noList.add(item.getAdjustBillNo());
        }
        String billData = StringUtils.join(noList, (String)",");
        tem.setBillList(billData);
        return tem;
    }

    private Map<String, List<MouldAdjust>> groupMouldNotice(List<MouldAdjust> list) {
        if (null == list) {
            return null;
        }
        HashMap<String, List<MouldAdjust>> groupMap = new HashMap<String, List<MouldAdjust>>();
        for (MouldAdjust mouldAdjust : list) {
            String supCompanySrmCode = mouldAdjust.getSupCompanySrmCode();
            ArrayList<MouldAdjust> adjustList = (ArrayList<MouldAdjust>)groupMap.get(supCompanySrmCode);
            if (null == adjustList) {
                adjustList = new ArrayList<MouldAdjust>();
            }
            adjustList.add(mouldAdjust);
            groupMap.put(supCompanySrmCode, adjustList);
        }
        return groupMap;
    }

    @Override
    @Transactional
    @CacheEvict(value={"mouldAdjust"}, allEntries=true)
    public void confirm(User loginUser, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u4f20\u9012\u7684id\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u786e\u8ba4\u5355\u636e!");
        }
        MouldAdjustExample adjustExample = new MouldAdjustExample();
        adjustExample.createCriteria().andIdIn((List)ids).andConfirmStatusEqualTo(Constant.YES_INT);
        if (this.mouldAdjustMapper.countByExample(adjustExample) > 0) {
            throw new CommonException("\u5355\u636e\u5df2\u786e\u8ba4,\u4e0d\u80fd\u518d\u64cd\u4f5c");
        }
        adjustExample.clear();
        adjustExample.createCriteria().andIdIn((List)ids);
        MouldAdjust adjust = new MouldAdjust();
        adjust.setSupUserId(loginUser.getId());
        adjust.setConfirmStatus(Constant.YES_INT);
        adjust.setUpdateTime(new Date());
        adjust.setConfirmTime(new Date());
        this.mouldAdjustMapper.updateByExampleSelective(adjust, adjustExample);
        final List<MouldAdjust> adjusts = this.queryAllObjByExample(adjustExample);
        if (CollectionUtils.isEmpty(adjusts)) {
            throw new CommonException("\u67e5\u8be2\u7684\u5355\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u786e\u8ba4\u5355\u636e!");
        }
        this.addToMould(adjusts);
        this.addToMouldAdjustHis(adjusts);
        this.defaultThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                MouldImTemplete templet = MouldAdjustServiceImpl.this.constructImInfo(2, "\u786e\u8ba4", adjusts);
                MouldAdjustServiceImpl.this.sendMessagesToPur((MouldAdjust)adjusts.get(0), templet);
            }
        });
    }

    private void addToMould(List<MouldAdjust> adjusts) {
        for (MouldAdjust mouldAdjust : adjusts) {
            MouldAdjustDetailExample detailExample = new MouldAdjustDetailExample();
            detailExample.createCriteria().andAdjustIdEqualTo(mouldAdjust.getId());
            List adjustDetails = this.mouldAdjustDetailService.queryAllObjByExample(detailExample);
            for (MouldAdjustDetail mouldAdjustDetail : adjustDetails) {
                Mould mould;
                if (mouldAdjust.getChangeType().equals(ChangeTypeEnum.Change_Sup.getValue())) {
                    mould = new Mould();
                    mould.setId(mouldAdjustDetail.getMouldId());
                    mould.setSupCompanyId(mouldAdjust.getSupChangeCompanyId());
                    mould.setSupCompanyName(mouldAdjust.getSupChangeName());
                    mould.setSupCompanySapCode(mouldAdjust.getSupChangeSapCode());
                    mould.setSupCompanySrmCode(mouldAdjust.getSupChangeSrmCode());
                    mould.setSupCompanyFullName(mouldAdjust.getSupChangeFullName());
                    mould.setUpdateTime(new Date());
                    this.mouldService.modifyObj(mould);
                    continue;
                }
                if (mouldAdjust.getChangeType().equals(ChangeTypeEnum.Life_adjustment.getValue())) {
                    mould = new Mould();
                    mould.setId(mouldAdjustDetail.getMouldId());
                    mould.setMouldLifetime(mouldAdjustDetail.getMouldUpdateLifetime());
                    MouldExample mouldExample = new MouldExample();
                    mouldExample.createCriteria().andIdEqualTo(mould.getId());
                    List moulds = this.mouldService.queryAllObjByExample(mouldExample);
                    for (Mould mould2 : moulds) {
                        BigDecimal decimal = mould.getMouldLifetime().subtract(mould2.getMouldConsumedLifetime());
                        mould.setMouldRemainderLifetime(decimal);
                    }
                    mould.setUpdateTime(new Date());
                    this.mouldService.modifyObj(mould);
                    continue;
                }
                this.mouldMaterialService.deleteByMouldId(mouldAdjustDetail.getMouldId());
                MouldAdjustMaterialExample materialExample = new MouldAdjustMaterialExample();
                materialExample.createCriteria().andAdjustDetailIdEqualTo(mouldAdjustDetail.getId());
                List adjustMaterials = this.mouldAdjustMaterialService.queryAllObjByExample(materialExample);
                for (MouldAdjustMaterial mouldAdjustMaterial : adjustMaterials) {
                    MouldMaterial mouldMaterial = new MouldMaterial();
                    mouldMaterial.setMouldId(mouldAdjustDetail.getMouldId());
                    mouldMaterial.setProjectId(mouldAdjustMaterial.getProjectId());
                    mouldMaterial.setMaterialCode(mouldAdjustMaterial.getMaterialCode());
                    mouldMaterial.setMaterialDesc(mouldAdjustMaterial.getMaterialDesc());
                    mouldMaterial.setIsCalculated(mouldAdjustMaterial.getIsCalculated());
                    mouldMaterial.setProductMouldQuantity(mouldAdjustMaterial.getProductMouldQuantity());
                    mouldMaterial.setUsedMaterial(mouldAdjustMaterial.getUsedMaterial());
                    mouldMaterial.setUpdateTime(new Date());
                    this.mouldMaterialService.addObj(mouldMaterial);
                }
            }
        }
    }

    private void addToMouldAdjustHis(List<MouldAdjust> adjusts) {
        if (adjusts == null) {
            return;
        }
        for (MouldAdjust mouldAdjust : adjusts) {
            MouldAdjustDetailExample detailExample = new MouldAdjustDetailExample();
            detailExample.createCriteria().andAdjustIdEqualTo(mouldAdjust.getId());
            List adjustDetails = this.mouldAdjustDetailService.queryAllObjByExample(detailExample);
            for (MouldAdjustDetail adjustDetail : adjustDetails) {
                MouldAdjustHis his = new MouldAdjustHis();
                his.setProjectId(mouldAdjust.getProjectId());
                his.setPurCompanyId(mouldAdjust.getPurCompanyId());
                his.setPurCompanySrmCode(mouldAdjust.getPurCompanySrmCode());
                his.setPurCompanyName(mouldAdjust.getPurCompanyName());
                his.setPurCompanyFullName(mouldAdjust.getPurCompanyFullName());
                his.setSupCompanyId(mouldAdjust.getSupCompanyId());
                his.setSupCompanySrmCode(mouldAdjust.getSupCompanySrmCode());
                his.setSupCompanySapCode(mouldAdjust.getSupCompanySapCode());
                his.setSupCompanyName(mouldAdjust.getSupCompanyName());
                his.setSupCompanyFullName(mouldAdjust.getSupCompanyFullName());
                if (mouldAdjust.getChangeType().equals(ChangeTypeEnum.Life_adjustment.getValue())) {
                    his.setMouldLifetime(adjustDetail.getMouldUpdateLifetime());
                } else {
                    his.setMouldLifetime(adjustDetail.getMouldPrimaryLifetime());
                }
                MouldExample mouldExample = new MouldExample();
                mouldExample.createCriteria().andIdEqualTo(adjustDetail.getMouldId());
                Mould mould = (Mould)this.mouldService.queryAllObjByExample(mouldExample).get(0);
                his.setMouldCode(mould.getMouldTemporaryCode());
                his.setMouldDesc(mould.getMouldDesc());
                his.setMouldNo(mould.getMouldCode());
                his.setMouldMaterial(mould.getMouldMaterial());
                his.setHisUpdateTime(new Date());
                his.setChangeType(mouldAdjust.getChangeType());
                his.setAdjustBillNo(mouldAdjust.getAdjustBillNo());
                his.setManufacturer(mould.getManufacturer());
                his.setAssetContractNumber(mould.getAssetContractNumber());
                his.setBelongedYear(mould.getBelongedYear());
                his.setMouldAscription(mould.getMouldAscription());
                his.setLeadingOfficial(mould.getLeadingOfficial());
                his.setMouldPropertyRightState(mould.getMouldPropertyRightState());
                his.setPurRemark(mouldAdjust.getPurRemark());
                his.setSupRemark(mouldAdjust.getSupRemark());
                this.mouldAdjustHisService.addObj(his);
            }
        }
    }

    public void sendMessagesToPur(MouldAdjust mouldAdjust, MouldImTemplete templet) {
        Message message = Message.init((Object)templet).setBusinessTypeCode(IM_CODE).setCompanyCode(mouldAdjust.getSupCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(mouldAdjust.getSupUserId()).addReceiverId(mouldAdjust.getPurUserId());
        MessageSendUtils.sendMessage((Message)message);
    }

    @Override
    public List<AdjustDetailVo> generateAdjustByMouldId(List<String> mouldIds) {
        if (CollectionUtils.isEmpty(mouldIds)) {
            throw new CommonException("\u6a21\u5177id\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MouldExample example = new MouldExample();
        example.createCriteria().andIdIn((List)mouldIds);
        List mouldList = this.mouldService.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(mouldList)) {
            throw new CommonException("\u67e5\u8be2\u5230\u7684\u6a21\u5177\u4fe1\u606f\u4e3a\u7a7a");
        }
        ArrayList<AdjustDetailVo> adjustVoList = new ArrayList<AdjustDetailVo>();
        for (Mould mould : mouldList) {
            AdjustDetailVo detailVo = new AdjustDetailVo();
            BeanUtils.copyProperties((Object)mould, (Object)detailVo);
            MouldMaterialExample materialExample = new MouldMaterialExample();
            materialExample.createCriteria().andMouldIdEqualTo(mould.getId());
            List materials = this.mouldMaterialService.queryAllObjByExample(materialExample);
            if (CollectionUtils.isEmpty(materials)) {
                throw new CommonException("\u6a21\u5177\u67e5\u8be2\u7684\u7269\u6599\u4fe1\u606f\u4e3a\u7a7a!");
            }
            ArrayList<MouldAdjustMaterial> adjustMaterials = new ArrayList<MouldAdjustMaterial>();
            for (MouldMaterial mouldMaterial : materials) {
                MouldAdjustMaterial adjustMaterial = new MouldAdjustMaterial();
                adjustMaterial.setMaterialCode(mouldMaterial.getMaterialCode());
                adjustMaterial.setMaterialDesc(mouldMaterial.getMaterialDesc());
                adjustMaterial.setIsCalculated(mouldMaterial.getIsCalculated());
                adjustMaterial.setProductMouldQuantity(mouldMaterial.getProductMouldQuantity());
                adjustMaterial.setUsedMaterial(mouldMaterial.getUsedMaterial());
                adjustMaterials.add(adjustMaterial);
            }
            detailVo.setMouldAdjustMaterialList(adjustMaterials);
            adjustVoList.add(detailVo);
        }
        return adjustVoList;
    }
}

