/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order;

import com.els.base.core.utils.Assert;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.command.order.SendOrderCommand;
import com.els.base.purchase.entity.PurchaseOrder;
import java.util.ArrayList;
import java.util.List;

public class BatchSendOrderCommand
extends AbstractOrderCommand<String> {
    private List<String> orderIdList;
    private List<PurchaseOrder> orderList;

    public BatchSendOrderCommand(List<String> orderIdList) {
        this.orderIdList = orderIdList;
        this.orderList = new ArrayList<PurchaseOrder>(orderIdList.size());
    }

    @Override
    public String execute(OrderComandInvoker context) {
        this.valid();
        for (PurchaseOrder order : this.orderList) {
            SendOrderCommand orderCommand = new SendOrderCommand(order);
            orderCommand.copyProperties(this);
            context.invoke(orderCommand);
        }
        return null;
    }

    private void valid() {
        Assert.isNotEmpty(this.orderIdList, "\u8ba2\u5355\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        for (String orderId : this.orderIdList) {
            PurchaseOrder order = (PurchaseOrder)this.context.getPurchaseOrderService().queryObjById(orderId);
            Assert.isNotNull(order, String.format("\u91c7\u8d2d\u65b9\u8ba2\u5355orderId[%s]\u4e0d\u5b58\u5728", orderId));
            this.orderList.add(order);
        }
    }
}

