CREATE TABLE T_BASE_MOULD_NOTICE_PLAN (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"MOULD_NOTICE_ID" VARCHAR2(32 BYTE) NULL ,
"NOTICE_ITEM_ID" VARCHAR2(32 BYTE) NULL ,
"PLAN_TYPE" VARCHAR2(255 BYTE) NULL ,
"PLAN_INDEX" NUMBER(7) NULL ,
"PLAN_COMPLETE_TIME" DATE NULL ,
"ACTUAL_COMPLETE_TIME" DATE NULL ,
"SUBTRACT_DAY" NUMBER(7) NULL ,
"PLAN_PICTURE" VARCHAR2(2000 BYTE) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"UPDATE_TIME" DATE NULL 
)
;
COMMENT ON TABLE T_BASE_MOULD_NOTICE_PLAN IS '资产管理-开模变更通知单-计划';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_PLAN."ID" IS '主键';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_PLAN."MOULD_NOTICE_ID" IS '单据id';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_PLAN."NOTICE_ITEM_ID" IS '变更单的模具信息id';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_PLAN."PLAN_TYPE" IS '计划类型';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_PLAN."PLAN_INDEX" IS '计划类型排序索引';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_PLAN."PLAN_COMPLETE_TIME" IS '计划完成时间';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_PLAN."ACTUAL_COMPLETE_TIME" IS '实际完成时间';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_PLAN."SUBTRACT_DAY" IS '差异天数';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_PLAN."PLAN_PICTURE" IS '照片';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_PLAN."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN T_BASE_MOULD_NOTICE_PLAN."UPDATE_TIME" IS '修改时间';

ALTER TABLE T_BASE_MOULD_NOTICE_PLAN ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE T_BASE_MOULD_NOTICE_PLAN ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE T_BASE_MOULD_NOTICE_PLAN ADD CHECK ("ID" IS NOT NULL);

ALTER TABLE T_BASE_MOULD_NOTICE_PLAN ADD PRIMARY KEY ("ID");
