/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.service.MaterialCodeService;
import com.els.base.material.service.MaterialService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u91c7\u8d2d\u65b9\u63d0\u4f9b\u7684\u7684\u7269\u6599\u53f7\u4fe1\u606f\u67e5\u8be2")
@Controller
@RequestMapping(value={"materialCode"})
public class MaterialCodeController {
    @Resource
    protected MaterialCodeService materialCodeService;
    @Resource
    protected MaterialService materialService;

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u901a\u8fc7\u91c7\u8d2d\u65b9\u63d0\u4f9b\u7684\u7684\u7269\u6599\u53f7\u67e5\u8be2\u91c7\u8d2d\u65b9\u7684\u7269\u6599\u6570\u636e")
    @RequestMapping(value={"service/findByMaterialCode"})
    @ResponseBody
    public ResponseResult<Material> findByMaterialCode(@ApiParam(value="\u91c7\u8d2d\u65b9\u7269\u6599\u7f16\u7801", required=true) @RequestParam(required=true) String materialCode) {
        if (StringUtils.isEmpty((String)materialCode)) {
            throw new CommonException("materialCode\u4e0d\u80fd\u4e3a\u7a7a\uff01", "base_canot_be_null", "materialCode");
        }
        MaterialExample example = new MaterialExample();
        MaterialExample.Criteria exampleCriteria = example.createCriteria();
        exampleCriteria.andMaterialCodeEqualTo(materialCode);
        List materialList = this.materialService.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(materialList)) {
            throw new CommonException("\u7269\u6599\u4e0d\u5b58\u5728", "do_not_exists", "\u7269\u6599");
        }
        return ResponseResult.success(materialList.get(0));
    }
}

