/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.purchase.dao.PurchaseOrderChangeMapper;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderChange;
import com.els.base.purchase.entity.PurchaseOrderChangeExample;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderExample;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.entity.SupplierOrderItemExample;
import com.els.base.purchase.service.PurchaseOrderChangeService;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.service.SupplierOrderItemService;
import com.els.base.purchase.service.SupplierOrderService;
import com.els.base.purchase.utils.PurchaseOrderDeliveryStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderIsEnableEnum;
import com.els.base.purchase.utils.SysUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultPurchaseOrderChangeService")
public class PurchaseOrderChangeServiceImpl
implements PurchaseOrderChangeService {
    @Resource
    protected PurchaseOrderChangeMapper purchaseOrderChangeMapper;
    @Resource
    protected PurchaseOrderItemService purchaseOrderItemService;
    @Resource
    protected SupplierOrderItemService supplierOrderItemService;
    @Resource
    protected PurchaseOrderService purchaseOrderService;
    @Resource
    protected SupplierOrderService supplierOrderService;

    @Override
    @CacheEvict(value={"purchaseOrderChange"}, allEntries=true)
    public void addObj(PurchaseOrderChange t) {
        this.purchaseOrderChangeMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"purchaseOrderChange"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseOrderChangeMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"purchaseOrderChange"}, allEntries=true)
    public void modifyObj(PurchaseOrderChange t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.purchaseOrderChangeMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"purchaseOrderChange"}, keyGenerator="redisKeyGenerator")
    public PurchaseOrderChange queryObjById(String id) {
        return this.purchaseOrderChangeMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"purchaseOrderChange"}, key="'PurchaseOrderChangeService_' + #root.methodName + '_'+ T(com.els.base.utils.encryption.Md5Utils).md5Object(#example)")
    public List<PurchaseOrderChange> queryAllObjByExample(PurchaseOrderChangeExample example) {
        return this.purchaseOrderChangeMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"purchaseOrderChange"}, key="'PurchaseOrderChangeService_' + #root.methodName + '_'+ T(com.els.base.utils.encryption.Md5Utils).md5Object(#example)")
    public PageView<PurchaseOrderChange> queryObjByPage(PurchaseOrderChangeExample example) {
        PageView<PurchaseOrderChange> pageView = example.getPageView();
        List<PurchaseOrderChange> selectByExampleByPage = this.purchaseOrderChangeMapper.selectByExampleByPage(example);
        pageView.setQueryResult(selectByExampleByPage);
        return pageView;
    }

    @Override
    @CacheEvict(value={"purchaseOrderChange"}, allEntries=true)
    public void importFromSap(List<PurchaseOrderChange> purchaseOrderChangeList) {
        if (CollectionUtils.isEmpty(purchaseOrderChangeList)) {
            throw new CommonException("SAP\u6570\u636e\u4e3a\u7a7a");
        }
        for (PurchaseOrderChange purchaseOrderChange : purchaseOrderChangeList) {
            PurchaseOrderItem purchaseOrderItem;
            List supplierOrderList;
            Serializable temp;
            BigDecimal canDeliveryAmount;
            BigDecimal cancellApplyNum = purchaseOrderChange.getCancellApplyNum() == null ? BigDecimal.ZERO : purchaseOrderChange.getCancellApplyNum();
            BigDecimal quantity = purchaseOrderChange.getQuantity() == null ? BigDecimal.ZERO : purchaseOrderChange.getQuantity();
            String orderNo = purchaseOrderChange.getOrderNo();
            String orderItemNo = purchaseOrderChange.getOrderItemNo();
            PurchaseOrderChangeExample purchaseOrderChangeExample = new PurchaseOrderChangeExample();
            purchaseOrderChangeExample.createCriteria().andOrderNoEqualTo(orderNo).andOrderItemNoEqualTo(orderItemNo);
            List<PurchaseOrderChange> selectByExample = this.purchaseOrderChangeMapper.selectByExample(purchaseOrderChangeExample);
            if (CollectionUtils.isNotEmpty(selectByExample)) {
                for (PurchaseOrderChange purchaseOrderChange2 : selectByExample) {
                    purchaseOrderChange2.setConfirmStatus("2");
                    purchaseOrderChange2.setStatus("CLOSE");
                    this.purchaseOrderChangeMapper.updateByPrimaryKeySelective(purchaseOrderChange2);
                }
            }
            if (purchaseOrderChange.getStatus().equalsIgnoreCase("NEW")) {
                PurchaseOrderItem purchaseOrderItem2;
                this.purchaseOrderChangeMapper.insert(purchaseOrderChange);
                SupplierOrderItem supplierOrderItem = this.querySupplierData(orderNo, orderItemNo);
                if (supplierOrderItem != null) {
                    BigDecimal canDeliveryAmount2 = SysUtil.getCanDeliveryAmount(supplierOrderItem.getQuantity(), supplierOrderItem.getOnwayQuantity(), supplierOrderItem.getReceivedQuantity(), cancellApplyNum);
                    SupplierOrderItem temp2 = new SupplierOrderItem();
                    temp2.setId(supplierOrderItem.getId());
                    temp2.setFreezeQuantity(cancellApplyNum);
                    temp2.setDeliveryAmount(canDeliveryAmount2);
                    this.supplierOrderItemService.modifyObj(temp2);
                }
                if ((purchaseOrderItem2 = this.queryPurchaseData(orderNo, orderItemNo)) == null) continue;
                canDeliveryAmount = SysUtil.getCanDeliveryAmount(purchaseOrderItem2.getQuantity(), purchaseOrderItem2.getOnwayQuantity(), purchaseOrderItem2.getReceivedQuantity(), cancellApplyNum);
                temp = new PurchaseOrderItem();
                ((PurchaseOrderItem)temp).setId(purchaseOrderItem2.getId());
                ((PurchaseOrderItem)temp).setFreezeQuantity(cancellApplyNum);
                ((PurchaseOrderItem)temp).setDeliveryAmount(canDeliveryAmount);
                this.purchaseOrderItemService.modifyObj(temp);
                continue;
            }
            if (!purchaseOrderChange.getStatus().equalsIgnoreCase("CLOSE")) continue;
            SupplierOrderExample supplierOrderExample = new SupplierOrderExample();
            supplierOrderExample.createCriteria().andOrderNoEqualTo(orderNo);
            SupplierOrderItem supplierOrderItem = this.querySupplierData(orderNo, orderItemNo);
            if (supplierOrderItem != null) {
                canDeliveryAmount = SysUtil.getCanDeliveryAmount(quantity, supplierOrderItem.getOnwayQuantity(), supplierOrderItem.getReceivedQuantity(), cancellApplyNum);
                temp = new SupplierOrderItem();
                ((SupplierOrderItem)temp).setFinishFlag(quantity.compareTo(supplierOrderItem.getReceivedQuantity()) > 0 ? "N" : "Y");
                ((SupplierOrderItem)temp).setId(supplierOrderItem.getId());
                ((SupplierOrderItem)temp).setFreezeQuantity(cancellApplyNum);
                ((SupplierOrderItem)temp).setQuantity(quantity);
                ((SupplierOrderItem)temp).setDeliveryAmount(canDeliveryAmount);
                ((SupplierOrderItem)temp).setOrderValue(purchaseOrderChange.getAmount());
                ((SupplierOrderItem)temp).setPriceTaxTotal(purchaseOrderChange.getItemPriceTaxTotal().toString());
                this.supplierOrderItemService.modifyObj(temp);
            }
            if (CollectionUtils.isNotEmpty(supplierOrderList = this.supplierOrderService.queryAllObjByExample(supplierOrderExample))) {
                SupplierOrder supplierOrder = (SupplierOrder)supplierOrderList.get(0);
                SupplierOrder temp3 = new SupplierOrder();
                boolean boo = this.queryOrderItemIsFinish(orderNo, "sup");
                if (!boo) {
                    temp3.setDeliveryStatus(PurchaseOrderDeliveryStatusEnum.RECEIVED_ALL.getValue());
                }
                temp3.setId(supplierOrder.getId());
                temp3.setTotalAmount(new BigDecimal(purchaseOrderChange.getOrderHeadAmount()));
                temp3.setPriceTaxTotal(purchaseOrderChange.getHeadPriceTaxTotal().toString());
                this.supplierOrderService.modifyObj(temp3);
            }
            if ((purchaseOrderItem = this.queryPurchaseData(orderNo, orderItemNo)) != null) {
                BigDecimal canDeliveryAmount3 = SysUtil.getCanDeliveryAmount(quantity, purchaseOrderItem.getOnwayQuantity(), purchaseOrderItem.getReceivedQuantity(), cancellApplyNum);
                PurchaseOrderItem temp4 = new PurchaseOrderItem();
                temp4.setFinishFlag(quantity.compareTo(purchaseOrderItem.getReceivedQuantity()) > 0 ? "N" : "Y");
                temp4.setId(purchaseOrderItem.getId());
                temp4.setFreezeQuantity(cancellApplyNum);
                temp4.setQuantity(quantity);
                temp4.setDeliveryAmount(canDeliveryAmount3);
                temp4.setOrderValue(purchaseOrderChange.getAmount());
                temp4.setPriceTaxTotal(purchaseOrderChange.getItemPriceTaxTotal().toString());
                this.purchaseOrderItemService.modifyObj(temp4);
            }
            PurchaseOrderExample purchaseOrderExample = new PurchaseOrderExample();
            purchaseOrderExample.createCriteria().andOrderNoEqualTo(orderNo);
            List purchaseOrderList = this.purchaseOrderService.queryAllObjByExample(purchaseOrderExample);
            if (!CollectionUtils.isNotEmpty(purchaseOrderList)) continue;
            PurchaseOrder purchaseOrder = (PurchaseOrder)purchaseOrderList.get(0);
            PurchaseOrder temp5 = new PurchaseOrder();
            boolean boo = this.queryOrderItemIsFinish(orderNo, "pur");
            if (!boo) {
                temp5.setDeliveryStatus(PurchaseOrderDeliveryStatusEnum.RECEIVED_ALL.getValue());
            }
            temp5.setId(purchaseOrder.getId());
            temp5.setTaxAmount(new BigDecimal(purchaseOrderChange.getOrderHeadAmount()));
            temp5.setPriceTaxTotal(purchaseOrderChange.getHeadPriceTaxTotal().toString());
            this.purchaseOrderService.modifyObj(temp5);
        }
    }

    private boolean queryOrderItemIsFinish(String orderNo, String str) {
        if (str.equals("sup")) {
            SupplierOrderItemExample supplierOrderItemExample = new SupplierOrderItemExample();
            supplierOrderItemExample.createCriteria().andOrderNoEqualTo(orderNo).andFinishFlagEqualTo("N").andIsEnableNotEqualTo(PurchaseOrderIsEnableEnum.DELETED.getValue());
            List queryAllObjByExample = this.supplierOrderItemService.queryAllObjByExample(supplierOrderItemExample);
            if (CollectionUtils.isNotEmpty(queryAllObjByExample)) {
                return queryAllObjByExample.size() > 0;
            }
        } else if (str.equals("pur")) {
            PurchaseOrderItemExample purchaseOrderItemExample = new PurchaseOrderItemExample();
            purchaseOrderItemExample.createCriteria().andOrderNoEqualTo(orderNo).andFinishFlagEqualTo("N").andIsEnableNotEqualTo(PurchaseOrderIsEnableEnum.DELETED.getValue());
            List purchaseOrderItemList = this.purchaseOrderItemService.queryAllObjByExample(purchaseOrderItemExample);
            if (CollectionUtils.isNotEmpty(purchaseOrderItemList)) {
                return purchaseOrderItemList.size() > 0;
            }
        }
        return false;
    }

    private SupplierOrderItem querySupplierData(String orderNo, String orderItemNo) {
        SupplierOrderItemExample supplierOrderItemExample = new SupplierOrderItemExample();
        supplierOrderItemExample.createCriteria().andOrderNoEqualTo(orderNo).andOrderItemNoEqualTo(orderItemNo);
        List supplierOrderItemList = this.supplierOrderItemService.queryAllObjByExample(supplierOrderItemExample);
        if (CollectionUtils.isNotEmpty(supplierOrderItemList)) {
            SupplierOrderItem supplierOrderItem = (SupplierOrderItem)supplierOrderItemList.get(0);
            return supplierOrderItem;
        }
        return null;
    }

    private PurchaseOrderItem queryPurchaseData(String orderNo, String orderItemNo) {
        PurchaseOrderItemExample purchaseOrderItemExample = new PurchaseOrderItemExample();
        purchaseOrderItemExample.createCriteria().andOrderNoEqualTo(orderNo).andOrderItemNoEqualTo(orderItemNo);
        List purchaseOrderItemList = this.purchaseOrderItemService.queryAllObjByExample(purchaseOrderItemExample);
        if (CollectionUtils.isNotEmpty(purchaseOrderItemList)) {
            PurchaseOrderItem purchaseOrderItem = (PurchaseOrderItem)purchaseOrderItemList.get(0);
            return purchaseOrderItem;
        }
        return null;
    }
}

