/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.entity.MaterialPropKey;
import com.els.base.material.entity.MaterialPropKeyExample;
import com.els.base.material.entity.MaterialPropKeyGroup;
import com.els.base.material.entity.MaterialPropKeyGroupExample;
import com.els.base.material.entity.MaterialPropValue;
import com.els.base.material.entity.MaterialPropValueExample;
import com.els.base.material.entity.SupplierMaterial;
import com.els.base.material.entity.SupplierMaterialExample;
import com.els.base.material.service.MaterialPropKeyGroupService;
import com.els.base.material.service.MaterialPropKeyService;
import com.els.base.material.service.MaterialPropValueService;
import com.els.base.material.service.MaterialService;
import com.els.base.material.service.SupplierMaterialService;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.master.service.MouldService;
import com.els.base.purchase.dao.PurchaseOrderItemMapper;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.utils.PurchaseOrderIsEnableEnum;
import com.els.base.purchase.utils.PurchaseOrderStatusEnum;
import com.els.base.purchase.utils.SysUtil;
import com.els.base.purchase.web.vo.MaterialHisVo;
import com.els.base.purchase.web.vo.MouldHisVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="purchaseOrderItemService")
public class PurchaseOrderItemServiceImpl
implements PurchaseOrderItemService {
    @Resource
    protected MouldService mouldService;
    @Resource
    protected MaterialService materialService;
    @Resource
    protected MaterialPropKeyGroupService materialPropKeyGroupService;
    @Resource
    protected MaterialPropKeyService materialPropKeyService;
    @Resource
    protected MaterialPropValueService materialPropValueService;
    @Resource
    protected SupplierMaterialService supplierMaterialService;
    @Resource
    protected PurchaseOrderItemMapper purchaseOrderItemMapper;
    @Resource
    protected PurchaseOrderService purchaseOrderService;

    @Override
    @CacheEvict(value={"purchaseOrderItem"}, allEntries=true)
    public void addObj(PurchaseOrderItem t) {
        this.purchaseOrderItemMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"purchaseOrderItem"}, allEntries=true)
    public void deleteObjById(String id) {
        PurchaseOrderItem item = new PurchaseOrderItem();
        item.setId(id);
        item.setIsEnable(PurchaseOrderIsEnableEnum.DELETED.getValue());
        this.purchaseOrderItemMapper.updateByPrimaryKeySelective(item);
    }

    @Override
    @CacheEvict(value={"purchaseOrderItem"}, allEntries=true)
    public void modifyObj(PurchaseOrderItem t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        t.setUpdateTime(new Date());
        this.purchaseOrderItemMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    public PurchaseOrderItem queryObjById(String id) {
        return this.purchaseOrderItemMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PurchaseOrderItem> queryAllObjByExample(PurchaseOrderItemExample example) {
        return this.purchaseOrderItemMapper.selectByExample(example);
    }

    @Override
    public PageView<PurchaseOrderItem> queryObjByPage(PurchaseOrderItemExample example) {
        PageView<PurchaseOrderItem> pageView = example.getPageView();
        List<PurchaseOrderItem> items = this.purchaseOrderItemMapper.selectByExampleByPage(example);
        for (PurchaseOrderItem purchaseOrderItem : items) {
            PurchaseOrder purchaseOrder;
            if ("Y".equals(purchaseOrderItem.getFinishFlag())) {
                purchaseOrderItem.setDeliveryAmount(BigDecimal.ZERO);
                continue;
            }
            if (purchaseOrderItem.getDeliveryAmount() == null) {
                purchaseOrderItem.setDeliveryAmount(SysUtil.getCanDeliveryAmount(purchaseOrderItem.getQuantity(), purchaseOrderItem.getOnwayQuantity(), purchaseOrderItem.getReceivedQuantity(), purchaseOrderItem.getFreezeQuantity()));
            }
            if (!(purchaseOrder = (PurchaseOrder)this.purchaseOrderService.queryObjById(purchaseOrderItem.getOrderId())).getOrderStatus().equals(PurchaseOrderStatusEnum.UNCONFIRM.getValue())) continue;
            purchaseOrderItem.setOrderStatus(PurchaseOrderStatusEnum.UNCONFIRM.getValue());
            purchaseOrderItem.setSupRemark(null);
        }
        pageView.setQueryResult(items);
        return pageView;
    }

    @Override
    public PageView<PurchaseOrderItem> queryHisAllObjByExample(PurchaseOrderItemExample example) {
        PageView<PurchaseOrderItem> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseOrderItemMapper.selectHisByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"purchaseOrderItem"}, allEntries=true)
    public void deleteByOrderId(String orderId) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria().andOrderIdEqualTo(orderId);
        this.purchaseOrderItemMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"purchaseOrderItem"}, allEntries=true)
    @Transactional
    public void insertHisByOrderId(String orderHisId, String orderId, String cause) {
        this.purchaseOrderItemMapper.insertHisByOrderId(orderHisId, orderId, cause);
    }

    @Override
    public PageView<PurchaseOrderItem> queryPurchaseOrderItemByPage(Map<String, Object> map) {
        PageView pageView = (PageView)map.get("pageView");
        List<PurchaseOrderItem> items = this.purchaseOrderItemMapper.selectPurchaseOrderItemByPage(map);
        pageView.setQueryResult(items);
        return pageView;
    }

    @Override
    public String selectMaxVersion() {
        return this.purchaseOrderItemMapper.selectMaxVersion();
    }

    @Override
    @CacheEvict(value={"purchaseOrderItem"}, allEntries=true)
    public void updateByPurcahseOrder(PurchaseOrderItem record, PurchaseOrderItemExample example) {
        this.purchaseOrderItemMapper.updateByExampleSelective(record, example);
    }

    @Override
    public PurchaseOrderItem queryByMaterialCode(String materialCode, String supCompanyCode) {
        PurchaseOrderItem purchaseOrderItem = new PurchaseOrderItem();
        SupplierMaterialExample supplierMaterialExample = new SupplierMaterialExample();
        supplierMaterialExample.createCriteria().andCompanySapCodeEqualTo(supCompanyCode).andMaterialCodeEqualTo(materialCode);
        List supplierMaterialList = this.supplierMaterialService.queryAllObjByExample(supplierMaterialExample);
        if (!CollectionUtils.isEmpty(supplierMaterialList)) {
            for (SupplierMaterial sm : supplierMaterialList) {
                if (!StringUtils.isNotBlank((String)sm.getSupplierMaterial())) continue;
                purchaseOrderItem.setSupMaterialCode(sm.getSupplierMaterial());
                break;
            }
        }
        double onwayQuantity = this.purchaseOrderItemMapper.calculateOnwayQuantity(materialCode, supCompanyCode);
        purchaseOrderItem.setOnwayQuantity(new BigDecimal(onwayQuantity));
        return purchaseOrderItem;
    }

    @Override
    public List<PurchaseOrderItem> selectForExcel(PurchaseOrderExample purchaseOrder) {
        return this.purchaseOrderItemMapper.selectForExcel(purchaseOrder);
    }

    @Override
    public PurchaseOrderItem queryByOrderItemNo(String orderNo, String orderItemNo) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria().andOrderNoEqualTo(orderNo).andOrderItemNoEqualTo(orderItemNo);
        List<PurchaseOrderItem> list = this.queryAllObjByExample(example);
        if (list != null && list.size() > 1) {
            throw new CommonException("\u51fa\u73b0\u91cd\u590d\u8ba2\u5355\u53f7\u7684\u95ee\u9898");
        }
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public PageView<MaterialHisVo> findMaterialHisByPage(String projectId, String currentCompanyId, MaterialExample example, int pageNo, int pageSize, String historyPurchaseCycle) {
        PageView pageData = this.materialService.queryObjByPage(example);
        List materialList = pageData.getQueryResult();
        if (CollectionUtils.isNotEmpty(materialList)) {
            for (Material material : materialList) {
                if (StringUtils.isBlank((String)material.getCategoryId())) continue;
                MaterialPropKeyGroupExample materialPropKeyGroupExample = new MaterialPropKeyGroupExample();
                MaterialPropKeyGroupExample.Criteria materialPropKeyGroupExampleCriteria = materialPropKeyGroupExample.createCriteria();
                materialPropKeyGroupExampleCriteria.andProjectIdEqualTo(material.getProjectId());
                materialPropKeyGroupExampleCriteria.andCompanyIdEqualTo(material.getCompanyId());
                materialPropKeyGroupExampleCriteria.andMaterialCategoryIdEqualTo(material.getCategoryId());
                List<MaterialPropKeyGroup> materialPropKeyGroupList = this.materialPropKeyGroupService.queryAllObjByExample(materialPropKeyGroupExample);
                if (CollectionUtils.isNotEmpty(materialPropKeyGroupList)) {
                    for (MaterialPropKeyGroup materialPropKeyGroup : materialPropKeyGroupList) {
                        MaterialPropKeyExample materialPropKeyExampleExample = new MaterialPropKeyExample();
                        MaterialPropKeyExample.Criteria materialPropKeyExampleCriteria = materialPropKeyExampleExample.createCriteria();
                        materialPropKeyExampleCriteria.andProjectIdEqualTo(projectId);
                        materialPropKeyExampleCriteria.andCompanyIdEqualTo(currentCompanyId);
                        materialPropKeyExampleCriteria.andPropKeyGroupIdEqualTo(materialPropKeyGroup.getId());
                        List<MaterialPropKey> materialPropKeyList = this.materialPropKeyService.queryAllObjByExample(materialPropKeyExampleExample);
                        if (CollectionUtils.isNotEmpty(materialPropKeyList)) {
                            for (MaterialPropKey materialPropKey : materialPropKeyList) {
                                MaterialPropValueExample materialPropValueExample = new MaterialPropValueExample();
                                MaterialPropValueExample.Criteria materialPropValueExampleCriteria = materialPropValueExample.createCriteria();
                                materialPropValueExampleCriteria.andProjectIdEqualTo(material.getProjectId());
                                materialPropValueExampleCriteria.andCompanyIdEqualTo(material.getCompanyId());
                                materialPropValueExampleCriteria.andMaterialIdEqualTo(material.getId());
                                materialPropValueExampleCriteria.andPropKeyGroupIdEqualTo(materialPropKeyGroup.getId());
                                materialPropValueExampleCriteria.andPropKeyIdEqualTo(materialPropKey.getId());
                                materialPropValueExampleCriteria.andPropKeyEqualTo(materialPropKey.getPropKey());
                                List materialPropValueList = this.materialPropValueService.queryAllObjByExample(materialPropValueExample);
                                if (!CollectionUtils.isNotEmpty(materialPropValueList) || materialPropValueList.size() <= 0) continue;
                                MaterialPropValue materialPropValue = (MaterialPropValue)materialPropValueList.get(0);
                                materialPropKey.setPropValue(materialPropValue.getPropValue());
                            }
                        }
                        materialPropKeyGroup.setMaterialPropKeyList(materialPropKeyList);
                    }
                }
                material.setMaterialPropKeyGroupList(materialPropKeyGroupList);
            }
        }
        PageView<MaterialHisVo> pageView = new PageView<MaterialHisVo>(pageNo, pageSize);
        List materials = pageData.getQueryResult();
        ArrayList<MaterialHisVo> list = new ArrayList<MaterialHisVo>();
        if (materials != null && !materials.isEmpty()) {
            for (Material material : materials) {
                MaterialHisVo vo = new MaterialHisVo();
                BeanUtils.copyProperties((Object)material, (Object)vo);
                vo.setHistoryPurchaseCycle(historyPurchaseCycle);
                if (StringUtils.isNotBlank((String)historyPurchaseCycle) && StringUtils.isNotBlank((String)material.getMaterialCode())) {
                    String historyPurchaseQty = this.queryHisQuantity(historyPurchaseCycle, material.getMaterialCode());
                    vo.setHistoryPurchaseQty(historyPurchaseQty);
                } else {
                    vo.setHistoryPurchaseQty("0");
                }
                list.add(vo);
            }
        }
        pageView.setRowCount(pageData.getRowCount());
        pageView.setQueryResult(list);
        return pageView;
    }

    @Override
    public PageView<MouldHisVo> findMouldHisByPage(MouldExample example, int pageNo, int pageSize, String historyPurchaseCycle) {
        PageView pageData = this.mouldService.queryObjByPage(example);
        PageView<MouldHisVo> pageView = new PageView<MouldHisVo>(pageNo, pageSize);
        List moulds = pageData.getQueryResult();
        ArrayList<MouldHisVo> list = new ArrayList<MouldHisVo>();
        if (moulds != null && !moulds.isEmpty()) {
            for (Mould mould : moulds) {
                MouldHisVo vo = new MouldHisVo();
                BeanUtils.copyProperties((Object)mould, (Object)vo);
                vo.setHistoryPurchaseCycle(historyPurchaseCycle);
                if (StringUtils.isNotBlank((String)historyPurchaseCycle) && StringUtils.isNotBlank((String)mould.getMouldCode())) {
                    String historyPurchaseQty = this.queryHisQuantity(historyPurchaseCycle, mould.getMouldCode());
                    vo.setHistoryPurchaseQty(historyPurchaseQty);
                } else {
                    vo.setHistoryPurchaseQty("0");
                }
                list.add(vo);
            }
        }
        pageView.setRowCount(pageData.getRowCount());
        pageView.setQueryResult(list);
        return pageView;
    }

    private String queryHisQuantity(String historyPurchaseCycle, String code) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        switch (historyPurchaseCycle) {
            case "0": {
                calendar.add(2, -3);
                break;
            }
            case "1": {
                calendar.add(2, -6);
                break;
            }
            case "2": {
                calendar.add(2, -12);
                break;
            }
            default: {
                calendar.add(2, 0);
            }
        }
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andMaterialCodeEqualTo(code).andOrderDateGreaterThanOrEqualTo(calendar.getTime()).andOrderDateLessThanOrEqualTo(new Date());
        List<PurchaseOrderItem> purchaseOrderItemList = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(purchaseOrderItemList)) {
            return "0";
        }
        BigDecimal historyPurchaseQty = purchaseOrderItemList.stream().map(PurchaseOrderItem::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        return historyPurchaseQty.toString();
    }
}

