/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.material.entity.MaterialPropValue;
import com.els.base.material.entity.MaterialPropValueExample;
import com.els.base.material.service.MaterialPropValueService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u7269\u6599\u5c5e\u6027\u503c")
@Controller
@RequestMapping(value={"materialPropValue"})
public class MaterialPropValueController {
    @Resource
    protected MaterialPropValueService materialPropValueService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7269\u6599\u5c5e\u6027\u503c")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody MaterialPropValue materialPropValue) {
        materialPropValue.setId(null);
        materialPropValue.setProjectId(ProjectUtils.getProjectId());
        materialPropValue.setCompanyId(CompanyUtils.currentCompanyId());
        this.materialPropValueService.addObj(materialPropValue);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u7269\u6599\u5c5e\u6027\u503c")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody MaterialPropValue materialPropValue) {
        materialPropValue.setProjectId(ProjectUtils.getProjectId());
        materialPropValue.setCompanyId(CompanyUtils.currentCompanyId());
        if (StringUtils.isBlank((String)materialPropValue.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "id_is_blank");
        }
        this.materialPropValueService.modifyObj(materialPropValue);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u7269\u6599\u5c5e\u6027\u503c")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u5220\u9664\u5931\u8d25", "id_is_blank");
        }
        this.materialPropValueService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7269\u6599\u5c5e\u6027\u503c")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MaterialPropValue>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialPropValue") @RequestBody(required=false) List<QueryParam> params) {
        MaterialPropValueExample example = new MaterialPropValueExample();
        example.setPageView(new PageView<MaterialPropValue>(pageNo, pageSize));
        if (CollectionUtils.isNotEmpty(params)) {
            MaterialPropValueExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion(criteria, params);
        }
        PageView pageData = this.materialPropValueService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}

