/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;

public class ModifyOrderItemCommand
extends AbstractOrderCommand<String> {
    private PurchaseOrder order;
    private PurchaseOrderItem item;

    public ModifyOrderItemCommand(PurchaseOrderItem item, PurchaseOrder order) {
        this.item = item;
        this.order = order;
    }

    @Override
    public String execute(OrderComandInvoker context) {
        this.valid();
        this.clearOrderItem(this.item);
        this.item.setIsUpdated(Constant.YES_INT);
        context.getPurchaseOrderItemService().modifyObj(this.item);
        return null;
    }

    private void valid() {
        Assert.isNotBlank(this.item.getId(), "\u91c7\u8d2d\u5355\u884cId\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void clearOrderItem(PurchaseOrderItem item) {
        item.setProjectId(null);
        item.setPurCompanyId(null);
        item.setPurCompanyName(null);
        item.setPurCompanyOcde(null);
        item.setSapPurCompanyCode(null);
        item.setSapSupCompanyCode(null);
        item.setSupCompanyId(null);
        item.setSupCompanyName(null);
        item.setOrderNo(null);
        item.setOrderId(null);
    }
}

