/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.material.entity.SupplierMaterial;
import com.els.base.material.utils.MaterailUtils;
import com.els.base.purchase.dao.DeliveryOrderMapper;
import com.els.base.purchase.entity.DeliveryOrder;
import com.els.base.purchase.entity.DeliveryOrderExample;
import com.els.base.purchase.entity.DeliveryOrderItem;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.service.DeliveryOrderItemService;
import com.els.base.purchase.service.DeliveryOrderService;
import com.els.base.purchase.service.DeliveryPackageService;
import com.els.base.purchase.service.SupplierOrderItemService;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="deliveryOrderService")
public class DeliveryOrderServiceImpl
implements DeliveryOrderService {
    @Resource
    protected DeliveryOrderMapper deliveryOrderMapper;
    @Resource
    protected DeliveryOrderItemService deliveryOrderItemService;
    @Resource
    protected SupplierOrderItemService supplierOrderItemService;
    @Resource
    protected DeliveryPackageService deliveryPackageService;

    @Override
    @CacheEvict(value={"deliveryOrder", "deliveryOrderItem"}, allEntries=true)
    public void addObj(DeliveryOrder deliveryOrder) {
        this.deliveryOrderMapper.insertSelective(deliveryOrder);
    }

    @Override
    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    public void deleteObjById(String id) {
        this.deliveryOrderMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    public void modifyObj(DeliveryOrder t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.deliveryOrderMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"deliveryOrder"}, keyGenerator="redisKeyGenerator")
    public DeliveryOrder queryObjById(String id) {
        return this.deliveryOrderMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"deliveryOrder"}, keyGenerator="redisKeyGenerator")
    public List<DeliveryOrder> queryAllObjByExample(DeliveryOrderExample example) {
        return this.deliveryOrderMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"deliveryOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryOrder> queryObjByPage(DeliveryOrderExample example) {
        PageView<DeliveryOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryOrderMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"deliveryOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryOrder> queryHisObjByPage(DeliveryOrderExample example) {
        PageView<DeliveryOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryOrderMapper.selectHisByExampleByPage(example));
        return pageView;
    }

    @Override
    public PageView<DeliveryOrder> queryDeliveryOrderByPage(DeliveryOrderExample example) {
        PageView<DeliveryOrder> pageView = example.getPageView();
        pageView = ((DeliveryOrderServiceImpl)SpringContextHolder.getOneBean(this.getClass())).queryObjByPage(example);
        if (CollectionUtils.isEmpty(pageView.getQueryResult())) {
            return new PageView<DeliveryOrder>(1, pageView.getPageSize());
        }
        for (DeliveryOrder deliveryOrder : pageView.getQueryResult()) {
            List<DeliveryOrderItem> itemList = this.deliveryOrderItemService.queryByDeliveryOrderId(deliveryOrder.getId());
            if (CollectionUtils.isEmpty(itemList)) continue;
            for (DeliveryOrderItem deliveryOrderItem : itemList) {
                if (StringUtils.isNotBlank((String)deliveryOrderItem.getSupplierMaterialNumber()) && StringUtils.isNotBlank((String)deliveryOrderItem.getSupplierMaterialName())) continue;
                this.setSupplierMaterialCode(deliveryOrderItem);
            }
            deliveryOrder.setItems(itemList);
        }
        return pageView;
    }

    private void setSupplierMaterialCode(DeliveryOrderItem deliveryOrderItem) {
        SupplierMaterial supplierMaterial = MaterailUtils.querySupplierMaterial(deliveryOrderItem.getCompanyId(), deliveryOrderItem.getCompanyCode(), deliveryOrderItem.getMaterialNo(), null);
        if (supplierMaterial == null) {
            return;
        }
        deliveryOrderItem.setSupplierMaterialName(supplierMaterial.getSupplierMaterialDesc());
        deliveryOrderItem.setSupplierMaterialNumber(supplierMaterial.getSupplierMaterial());
    }

    @Override
    public DeliveryOrder queryDeliveryOrderId(String deliveryOrderId) {
        DeliveryOrder deliveryOrder = ((DeliveryOrderServiceImpl)SpringContextHolder.getOneBean(this.getClass())).queryObjById(deliveryOrderId);
        List<DeliveryOrderItem> items = this.deliveryOrderItemService.queryByDeliveryOrderId(deliveryOrderId);
        for (DeliveryOrderItem deliveryOrderItem : items) {
            SupplierOrderItem supplierOrderItem;
            if (StringUtils.isBlank((String)deliveryOrderItem.getSupplierMaterialNumber()) || StringUtils.isBlank((String)deliveryOrderItem.getSupplierMaterialName())) {
                this.setSupplierMaterialCode(deliveryOrderItem);
            }
            if ((supplierOrderItem = (SupplierOrderItem)this.supplierOrderItemService.queryObjById(deliveryOrderItem.getPurOrderItemId())) != null) {
                deliveryOrderItem.setQuantity(supplierOrderItem.getQuantity() == null ? BigDecimal.ZERO : supplierOrderItem.getQuantity());
                if (supplierOrderItem.getDeliveryAmount() != null) {
                    deliveryOrderItem.setCanDeliveryQuantity(supplierOrderItem.getDeliveryAmount());
                }
                if (supplierOrderItem.getReceivedQuantity() != null) {
                    deliveryOrderItem.setReceiptQuantity(supplierOrderItem.getReceivedQuantity().toString());
                }
                if (supplierOrderItem.getOnwayQuantity() != null) {
                    deliveryOrderItem.setOnwayQuantity(supplierOrderItem.getOnwayQuantity());
                }
                deliveryOrderItem.setFreezeQuantity(supplierOrderItem.getFreezeQuantity() == null ? BigDecimal.ZERO : supplierOrderItem.getFreezeQuantity());
            }
            deliveryOrderItem.setDeliveryPackageLists(this.deliveryPackageService.queryByDeliveryOrderItemId(deliveryOrderItem.getId()));
        }
        deliveryOrder.setItems(items);
        return deliveryOrder;
    }

    @Override
    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    @Transactional
    public void modifyAndAddHis(DeliveryOrder deliveryOrder, String string) {
        Assert.isNotNull(deliveryOrder, "\u9001\u8d27\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(deliveryOrder.getId(), "\u9001\u8d27\u5355id\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Date date = new Date();
        this.deliveryOrderMapper.insertHis(UUIDGenerator.generateUUID(), deliveryOrder.getId(), "\u53d1\u9001\u53d1\u8d27\u5355", date);
        this.modifyObj(deliveryOrder);
    }

    @Override
    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    @Transactional
    public void deleteAndAddHis(String deliveryOrderId, String string) {
        Assert.isNotBlank(deliveryOrderId, "\u9001\u8d27\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        Date date = new Date();
        this.deliveryOrderMapper.insertHis(UUIDGenerator.generateUUID(), deliveryOrderId, "\u53d1\u9001\u53d1\u8d27\u5355", date);
        this.deliveryOrderMapper.deleteByPrimaryKey(deliveryOrderId);
    }

    @Override
    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    public void modifyByExample(DeliveryOrder deliveryOrder, DeliveryOrderExample example) {
        this.deliveryOrderMapper.updateByExampleSelective(deliveryOrder, example);
    }
}

