
CREATE TABLE T_BASE_MOULD_MATERIAL (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"MOULD_ID" VARCHAR2(32 BYTE) NULL ,
"MATERIAL_CODE" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_DESC" VARCHAR2(255 BYTE) NULL ,
"IS_CALCULATED" NUMBER(7) DEFAULT 1  NULL ,
"PRODUCT_MOULD_QUANTITY" NUMBER(13,2) DEFAULT 0  NULL ,
"USED_MATERIAL" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_CONSUMED_LIFETIME" NUMBER(13,2) DEFAULT 0  NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"UPDATE_TIME" DATE NULL 
)

;
COMMENT ON TABLE T_BASE_MOULD_MATERIAL IS '资产管理-模具主数据物料信息';
COMMENT ON COLUMN T_BASE_MOULD_MATERIAL."ID" IS '主键';
COMMENT ON COLUMN T_BASE_MOULD_MATERIAL."PROJECT_ID" IS '表的项目ID';
COMMENT ON COLUMN T_BASE_MOULD_MATERIAL."MOULD_ID" IS '模具主数据id';
COMMENT ON COLUMN T_BASE_MOULD_MATERIAL."MATERIAL_CODE" IS '物料编码';
COMMENT ON COLUMN T_BASE_MOULD_MATERIAL."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN T_BASE_MOULD_MATERIAL."IS_CALCULATED" IS '是否核算(0=不核算，1=核算)';
COMMENT ON COLUMN T_BASE_MOULD_MATERIAL."PRODUCT_MOULD_QUANTITY" IS '出模数';
COMMENT ON COLUMN T_BASE_MOULD_MATERIAL."USED_MATERIAL" IS '使用材料';
COMMENT ON COLUMN T_BASE_MOULD_MATERIAL."MATERIAL_CONSUMED_LIFETIME" IS '物料已耗寿命次数';
COMMENT ON COLUMN T_BASE_MOULD_MATERIAL."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN T_BASE_MOULD_MATERIAL."UPDATE_TIME" IS '修改时间';

ALTER TABLE T_BASE_MOULD_MATERIAL ADD CHECK ("ID" IS NOT NULL);


ALTER TABLE T_BASE_MOULD_MATERIAL ADD PRIMARY KEY ("ID");
