/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.dao.PurchaseOrderMapper;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.utils.PurchaseOrderDeliveryStatusEnum;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="purchaseOrderService")
public class PurchaseOrderServiceImpl
implements PurchaseOrderService {
    @Resource
    protected PurchaseOrderMapper purchaseOrderMapper;
    @Resource
    protected CompanyService companyService;

    @Override
    @Transactional
    @CacheEvict(value={"purchaseOrder", "purchaseOrderItem"}, allEntries=true)
    public void addObj(PurchaseOrder purchaseOrder) {
        this.purchaseOrderMapper.insertSelective(purchaseOrder);
    }

    @Override
    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseOrderMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void modifyObj(PurchaseOrder t) {
        Assert.isNotBlank(t.getId(), "id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        this.purchaseOrderMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PurchaseOrder queryObjById(String id) {
        return this.purchaseOrderMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseOrder> queryAllObjByExample(PurchaseOrderExample example) {
        return this.purchaseOrderMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseOrder> queryObjByPage(PurchaseOrderExample example) {
        PageView<PurchaseOrder> pageView = example.getPageView();
        List<PurchaseOrder> list = this.purchaseOrderMapper.selectByExampleByPage(example);
        for (PurchaseOrder purchaseOrder : list) {
            Company company = (Company)this.companyService.queryObjById(purchaseOrder.getSupCompanyId());
            if (company == null) continue;
            purchaseOrder.setSupShortName(company.getCompanyName());
        }
        pageView.setQueryResult(list);
        return pageView;
    }

    @Override
    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseOrder> queryHisObjByPage(PurchaseOrderExample example) {
        PageView<PurchaseOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseOrderMapper.selectHisByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void updateByPurcahseOrder(PurchaseOrder record, PurchaseOrderExample example) {
        this.purchaseOrderMapper.updateByExampleSelective(record, example);
    }

    @Override
    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseOrder> queryObjNoItemsByPage(PurchaseOrderExample example, String purUserId, String materialCode, String brand) {
        PageView<PurchaseOrder> pageView = example.getPageView();
        List<PurchaseOrder> list = this.purchaseOrderMapper.selectForPurUserByExampleByPage(example, pageView, purUserId, materialCode, brand);
        pageView.setQueryResult(list);
        return pageView;
    }

    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public PurchaseOrder updateOrderHeaderStatus(PurchaseOrder purchaseOrder, int isDeleteNum, int isFrozenNum, int finishFlagDeleteNum, int finishFlagNoDeleteNum) {
        PurchaseOrder purchaseOrderTemp;
        int finishFlagNum = isDeleteNum + finishFlagNoDeleteNum;
        System.out.println(purchaseOrder.getOrderNo() + "------------finishFlagNoDeleteNum---" + finishFlagNoDeleteNum + "------------isDeleteNum--- " + isDeleteNum + "------------------------finishFlagNum---" + finishFlagNum + "--------------------------purchaseOrder.getItems().size()--" + purchaseOrder.getItems().size());
        if (isDeleteNum == purchaseOrder.getItems().size()) {
            purchaseOrder.setIsEnable(0);
        } else if (isFrozenNum == purchaseOrder.getItems().size() || isFrozenNum + isDeleteNum == purchaseOrder.getItems().size()) {
            purchaseOrder.setIsEnable(2);
        }
        if (finishFlagNum == purchaseOrder.getItems().size()) {
            purchaseOrder.setDeliveryStatus(PurchaseOrderDeliveryStatusEnum.RECEIVED_ALL.getValue());
        }
        System.out.println(purchaseOrder.getOrderNo() + "------------------------finishFlagNum---" + finishFlagNum + "--------------------------purchaseOrder.getItems().size()--" + purchaseOrder.getItems().size());
        if (StringUtils.isNotBlank((String)purchaseOrder.getId()) && (purchaseOrderTemp = this.purchaseOrderMapper.selectByPrimaryKey(purchaseOrder.getId())) != null) {
            if (purchaseOrderTemp.getIsEnable() != null && purchaseOrderTemp.getIsEnable() == 0) {
                System.out.println(purchaseOrder.getOrderNo() + "------------------------isDeleteNum---" + isDeleteNum + "-----------isFrozenNum---" + isFrozenNum + "------------purchaseOrder.getItems().size()--" + purchaseOrder.getItems().size());
                if (isDeleteNum < purchaseOrder.getItems().size()) {
                    purchaseOrder.setIsEnable(1);
                }
            }
            if (purchaseOrderTemp.getIsEnable() != null && purchaseOrderTemp.getIsEnable() == 2 && isFrozenNum + isDeleteNum < purchaseOrder.getItems().size()) {
                purchaseOrder.setIsEnable(1);
            }
            if (purchaseOrderTemp.getDeliveryStatus() != null && purchaseOrderTemp.getDeliveryStatus() == 2 && finishFlagNum < purchaseOrder.getItems().size()) {
                purchaseOrder.setDeliveryStatus(PurchaseOrderDeliveryStatusEnum.RECEVIED_NONE.getValue());
            }
        }
        return purchaseOrder;
    }

    @Override
    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PurchaseOrder queryByOrderNo(String projectId, String orderNo) {
        PurchaseOrderExample example = new PurchaseOrderExample();
        example.createCriteria().andProjectIdEqualTo(projectId).andOrderNoEqualTo(orderNo);
        List<PurchaseOrder> list = this.queryAllObjByExample(example);
        if (list != null && list.size() > 1) {
            throw new CommonException("\u51fa\u73b0\u91cd\u590d\u8ba2\u5355\u53f7\u7684\u95ee\u9898");
        }
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public String insertHis(String orderId, String cause) {
        String uuid = UUIDGenerator.generateUUID();
        this.purchaseOrderMapper.insertHis(uuid, orderId, cause);
        return uuid;
    }
}

