/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.SupplierMaterial;
import com.els.base.material.utils.MaterailUtils;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class CreateOrderItemCommand
extends AbstractOrderCommand<String> {
    private PurchaseOrderItem item;
    private PurchaseOrder order;

    public CreateOrderItemCommand(PurchaseOrderItem item, PurchaseOrder order) {
        this.item = item;
        this.order = order;
    }

    @Override
    public String execute(OrderComandInvoker context) {
        this.valid();
        this.init(this.item, this.order);
        this.context.getPurchaseOrderItemService().addObj(this.item);
        return null;
    }

    private void init(PurchaseOrderItem item, PurchaseOrder order) {
        Material material;
        SupplierMaterial supplierMaterial;
        item.setOrderId(order.getId());
        item.setOrderNo(order.getOrderNo());
        item.setProjectId(order.getProjectId());
        item.setPurCompanyId(order.getCompanyId());
        item.setPurCompanyName(order.getCompanyName());
        item.setPurUserId(order.getUserId());
        item.setPurUserName(order.getUserName());
        item.setSupCompanyId(order.getSupCompanyId());
        item.setSupCompanyName(order.getSupCompanyName());
        item.setSapSupCompanyCode(order.getSupCompanySapCode());
        item.setSupUserId(order.getSupUserId());
        item.setSupUserName(order.getSupUserName());
        item.setCurrency(order.getCurrency());
        item.setUpdateTime(new Date());
        item.setIsUpdated(Constant.NO_INT);
        item.setHaveChange(Constant.NO_INT);
        if (item.getOrderDate() == null) {
            item.setOrderDate(order.getOrderDate());
        }
        if (item.getOnwayQuantity() == null) {
            item.setOnwayQuantity(BigDecimal.ZERO);
        }
        if (item.getReceivedQuantity() == null) {
            item.setReceivedQuantity(BigDecimal.ZERO);
        }
        if (item.getFreezeQuantity() == null) {
            item.setFreezeQuantity(BigDecimal.ZERO);
        }
        if (item.getAlreadyApplyMoney() == null) {
            item.setAlreadyApplyMoney(BigDecimal.ZERO);
        }
        if ((supplierMaterial = MaterailUtils.querySupplierMaterial(item.getSupCompanyId(), item.getSapSupCompanyCode(), item.getMaterialCode(), item.getVersion())) != null) {
            item.setSupMaterialCode(supplierMaterial.getSupplierMaterial());
            item.setSupMaterialDesc(supplierMaterial.getSupplierMaterialDesc());
            item.setBrand(supplierMaterial.getBrand());
        }
        if ((material = MaterailUtils.queryMaterial(item.getMaterialCode())) != null) {
            item.setMaterialCategoryId(material.getCategoryId());
            item.setMaterialCategoryName(material.getCategoryName());
            item.setMaterialId(material.getId());
            item.setDeliveryMaterialName(material.getMaterialName());
            if (StringUtils.isNotBlank((String)material.getBrandName())) {
                item.setBrand(material.getBrandName());
            }
        }
        if (StringUtils.isBlank((String)item.getPriceTaxTotal())) {
            item.setAvailableApplyMoney(BigDecimal.ZERO);
        } else {
            item.setAvailableApplyMoney(new BigDecimal(item.getPriceTaxTotal()));
        }
        BigDecimal canDeliveryQuantity = item.getQuantity().subtract(item.getOnwayQuantity()).subtract(item.getReceivedQuantity()).subtract(item.getFreezeQuantity());
        item.setDeliveryAmount(canDeliveryQuantity);
        if (item.getQuantity().compareTo(item.getReceivedQuantity()) <= 0) {
            item.setFinishFlag("Y");
        } else {
            item.setFinishFlag("N");
        }
    }

    private void valid() {
        Assert.isNotBlank(this.order.getId(), "\u91c7\u8d2d\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(this.order.getOrderNo(), "\u91c7\u8d2d\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(this.order.getCompanyId(), "\u91c7\u8d2d\u65b9id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(this.order.getCompanyCode(), "\u91c7\u8d2d\u65b9SRM\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(this.order.getCompanyName(), "\u91c7\u8d2d\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(this.order.getSupCompanyId(), "\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(this.order.getSupCompanyName(), "\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(this.order.getPurSapCompanyCode(), "\u4f9b\u5e94\u5546sap code \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(this.item.getOrderItemNo(), "\u91c7\u8d2d\u5355\u884c\u9879\u76ee\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(this.item.getIsEnable(), "\u8ba2\u5355\u884c\u662f\u5426\u53ef\u7528\u7684\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(this.item.getMaterialCode(), "\u91c7\u8d2d\u5355\u884c\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(this.item.getQuantity(), "\u8ba2\u5355\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(this.item.getPriceTaxTotal(), "\u7a0e\u4ef7\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

