/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.dao.DeliveryOrderItemMapper;
import com.els.base.purchase.entity.DeliveryOrderItem;
import com.els.base.purchase.entity.DeliveryOrderItemExample;
import com.els.base.purchase.service.DeliveryOrderItemService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="deliveryOrderItemService")
public class DeliveryOrderItemServiceImpl
implements DeliveryOrderItemService {
    @Resource
    protected DeliveryOrderItemMapper deliveryOrderItemMapper;

    @Override
    @CacheEvict(value={"deliveryOrderItem"}, allEntries=true)
    public void addObj(DeliveryOrderItem t) {
        this.deliveryOrderItemMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"deliveryOrderItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.deliveryOrderItemMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"deliveryOrderItem"}, allEntries=true)
    public void modifyObj(DeliveryOrderItem t) {
        Assert.isNotBlank(t.getId(), "id \u4e0d\u80fd\u4e3a\u7a7a", "id_is_blank");
        this.deliveryOrderItemMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"deliveryOrderItem"}, keyGenerator="redisKeyGenerator")
    public DeliveryOrderItem queryObjById(String id) {
        return this.deliveryOrderItemMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"deliveryOrderItem"}, keyGenerator="redisKeyGenerator")
    public List<DeliveryOrderItem> queryByDeliveryOrderId(String deliveryOrderId) {
        DeliveryOrderItemExample itemExample = new DeliveryOrderItemExample();
        itemExample.createCriteria().andDeliveryOrderIdEqualTo(deliveryOrderId);
        itemExample.setOrderByClause("DELIVERY_ORDER_ITEM_NO ASC,MATERIAL_NO ASC ,DELIVERY_DATE DESC");
        return this.deliveryOrderItemMapper.selectByExample(itemExample);
    }

    @Override
    @Cacheable(value={"deliveryOrderItem"}, keyGenerator="redisKeyGenerator")
    public List<DeliveryOrderItem> queryAllObjByExample(DeliveryOrderItemExample example) {
        return this.deliveryOrderItemMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"deliveryOrderItem"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryOrderItem> queryObjByPage(DeliveryOrderItemExample example) {
        PageView<DeliveryOrderItem> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryOrderItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"deliveryOrderItem"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryOrderItem> queryHisObjByPage(DeliveryOrderItemExample example) {
        PageView<DeliveryOrderItem> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryOrderItemMapper.selectHisByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"deliveryOrderItem"}, allEntries=true)
    public void updateDeliveryOrderItem(DeliveryOrderItem record, DeliveryOrderItemExample example) {
        this.deliveryOrderItemMapper.updateByExampleSelective(record, example);
    }

    @Override
    @CacheEvict(value={"deliveryOrderItem"}, allEntries=true)
    public void deleteByExample(DeliveryOrderItemExample example) {
        if (example == null || CollectionUtils.isEmpty(example.getOredCriteria())) {
            return;
        }
        this.deliveryOrderItemMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"deliveryOrderItem"}, allEntries=true)
    public void insertHis(String hisItemId, String id, String cause, Date operateTime) {
        this.deliveryOrderItemMapper.insertHis(hisItemId, id, cause, operateTime);
    }
}

