/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.utils.query;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.query.QueryConditionEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;

@ApiModel(value="\u901a\u7528\u67e5\u8be2\u6761\u4ef6")
public class QueryParam
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotEmpty
    @ApiModelProperty(value="\u5c5e\u6027\u540d")
    public String property;
    @NotEmpty
    @ApiModelProperty(value="\u67e5\u8be2\u6761\u4ef6\u5305\u62ec: = (eq),!= (neq), > (gt), >= (gte), <(lt), <=(lte), like, notLike, isNotNull, isNull, in")
    public String condition;
    @NotEmpty
    @ApiModelProperty(value="\u5c5e\u6027\u503c")
    public String value;

    public String getCriteriaMethod() {
        StringBuffer methodName = new StringBuffer("and");
        methodName.append(StringUtils.capitalize((String)this.getProperty()));
        methodName.append(StringUtils.capitalize((String)this.getFullCondition()));
        return methodName.toString();
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property == null ? null : property.trim();
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition == null ? null : condition.trim();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value == null ? null : value.trim();
    }

    public String getFullCondition() {
        switch (this.getCondition()) {
            case "like": 
            case "notLike": 
            case "isNotNull": 
            case "isNull": 
            case "in": {
                return this.getCondition();
            }
            case "=": 
            case "eq": {
                return QueryConditionEnum.EQUAL_TO.getFullName();
            }
            case "!=": 
            case "neq": {
                return QueryConditionEnum.NOT_EQUAL_TO.getFullName();
            }
            case ">": 
            case "gt": {
                return QueryConditionEnum.GREATER_THAN.getFullName();
            }
            case ">=": 
            case "gte": {
                return QueryConditionEnum.GREATER_THAN_OR_EQUAL_TO.getFullName();
            }
            case "<": 
            case "lt": {
                return QueryConditionEnum.LESS_THAN.getFullName();
            }
            case "<=": 
            case "lte": {
                return QueryConditionEnum.LESS_THAN_OR_EQUAL_TO.getFullName();
            }
        }
        throw new CommonException("condition\u4e0d\u5408\u6cd5", "base_illegal_opertion");
    }

    public String toString() {
        return "QueryParam [property=" + this.property + ", condition=" + this.condition + ", value=" + this.value + "]";
    }
}

