/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.notice.utils;

import com.els.base.mould.notice.entity.MouldNoticePlan;
import com.els.base.mould.notice.vo.MouldNoticeColumnData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class TransFormUtils {
    public static List<Map<String, MouldNoticeColumnData>> transform(List<MouldNoticePlan> noticePlanList) {
        if (null == noticePlanList) {
            return null;
        }
        HashMap<String, MouldNoticeColumnData> planCompleteList = new HashMap<String, MouldNoticeColumnData>();
        HashMap<String, MouldNoticeColumnData> actualCompleteList = new HashMap<String, MouldNoticeColumnData>();
        HashMap<String, MouldNoticeColumnData> subtractDayList = new HashMap<String, MouldNoticeColumnData>();
        HashMap<String, MouldNoticeColumnData> planPictureList = new HashMap<String, MouldNoticeColumnData>();
        for (MouldNoticePlan plan : noticePlanList) {
            MouldNoticeColumnData planComplete = new MouldNoticeColumnData();
            planComplete.setId(plan.getId());
            planComplete.setPlanType(plan.getPlanType());
            planComplete.setValue(plan.getPlanCompleteTime());
            planComplete.setField("planCompleteTime");
            planCompleteList.put(plan.getPlanIndex().toString(), planComplete);
            MouldNoticeColumnData actualComplete = new MouldNoticeColumnData();
            actualComplete.setId(plan.getId());
            actualComplete.setPlanType(plan.getPlanType());
            actualComplete.setValue(plan.getActualCompleteTime());
            actualComplete.setField("actualCompleteTime");
            actualCompleteList.put(plan.getPlanIndex().toString(), actualComplete);
            MouldNoticeColumnData subtractDay = new MouldNoticeColumnData();
            subtractDay.setId(plan.getId());
            subtractDay.setPlanType(plan.getPlanType());
            if (StringUtils.isEmpty((Object)plan.getId())) {
                subtractDay.setValue(0);
            } else {
                subtractDay.setValue(0);
                if (plan.getPlanCompleteTime() != null && plan.getActualCompleteTime() != null) {
                    BigDecimal planTime = new BigDecimal(plan.getPlanCompleteTime().getTime());
                    BigDecimal actualTime = new BigDecimal(plan.getActualCompleteTime().getTime());
                    BigDecimal subTime = actualTime.subtract(planTime).divide(new BigDecimal(86400000), 0, 4);
                    subtractDay.setValue(subTime);
                }
            }
            subtractDay.setField("subtractDay");
            subtractDayList.put(plan.getPlanIndex().toString(), subtractDay);
            MouldNoticeColumnData planPicture = new MouldNoticeColumnData();
            planPicture.setId(plan.getId());
            planPicture.setPlanType(plan.getPlanType());
            planPicture.setValue(plan.getPlanPicture());
            planPicture.setField("planPicture");
            planPictureList.put(plan.getPlanIndex().toString(), planPicture);
        }
        ArrayList<Map<String, MouldNoticeColumnData>> data = new ArrayList<Map<String, MouldNoticeColumnData>>();
        data.add(planCompleteList);
        data.add(actualCompleteList);
        data.add(subtractDayList);
        data.add(planPictureList);
        return data;
    }
}

