/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.service.impl;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.dao.CompanyMapper;
import com.els.base.company.dao.CompanyPartnerMapper;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.CompanyPartner;
import com.els.base.company.entity.CompanyPartnerExample;
import com.els.base.company.entity.CompanyProductType;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.event.CompanyCreatedSuccessEvent;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyStusChgLogService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.CompanyExecutionEnum;
import com.els.base.company.utils.FinishFlagUtils;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.company.utils.SupplierCompanyExcelImportUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.project.ProjectService;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.uuid.UUIDGenerator;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service(value="defaultCompanyService")
public class CompanyServiceImpl
implements CompanyService {
    @Resource
    private CompanyMapper companyMapper;
    @Resource
    private CompanyPartnerMapper companyPartnerMapper;
    @Resource
    private UserService userService;
    @Resource
    private GenerateCodeService generateCodeService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private ProjectService projectService;
    @Resource
    private RoleService roleService;
    @Resource
    private UserRoleService userRoleService;

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public Integer isFinish(Company company) {
        if (!Constant.YES_INT.equals((company = this.queryObjById(company.getId())).getIsEnable())) {
            return Constant.NO_INT;
        }
        if (!Constant.YES_INT.equals(company.getFinishFlag())) {
            FinishFlagUtils.getFinishFlag(company);
        }
        return Constant.YES_INT;
    }

    @Override
    @Transactional
    @CacheEvict(value={"company"}, allEntries=true)
    public void addObj(Company t) {
        if (StringUtils.isBlank((String)t.getCompanyFullName())) {
            throw new CommonException("CompanyFullNam\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "CompanyFullNam");
        }
        CompanyExample companyExample = new CompanyExample();
        CompanyExample.Criteria companyExampleCriteria = companyExample.createCriteria();
        companyExampleCriteria.andCompanyFullNameEqualTo(t.getCompanyFullName());
        int count = this.companyMapper.countByExample(companyExample);
        if (count > 0) {
            throw new CommonException("\u516c\u53f8\u540d\u79f0 " + t.getCompanyFullName() + "\u5df2\u5b58\u5728", "base_is_exists", "CompanyFullName");
        }
        t.setId(null);
        t.setCompanyCode(this.generateCodeService.getNextCompanyCode());
        this.companyMapper.insertSelective(t);
        SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)new CompanyCreatedSuccessEvent(t));
    }

    @Override
    @Transactional
    @CacheEvict(value={"company"}, allEntries=true)
    public void deleteObjById(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id\u4e0d\u80fd\u4e3a\u7a7a", "id_is_blank");
        }
        Company company = this.companyMapper.selectByPrimaryKey(id);
        if (company == null) {
            throw new CommonException("companyId\u4e0d\u80fd\u4e3a\u7a7a", "id_is_blank");
        }
        company.setIsEnable(Constant.NO_INT);
        this.companyMapper.updateByPrimaryKey(company);
    }

    @Override
    @Transactional
    @CacheEvict(value={"company"}, allEntries=true)
    public void modifyObj(Company t) {
        t.setCompanyCode(null);
        if (StringUtils.isBlank((String)t.getId())) {
            throw new CommonException("companyId\u4e3a\u7a7a", "id_is_blank");
        }
        if (!(t.getCompanyFullName() == null || t.getCompanyFullName().length() <= 255 && t.getCompanyFullName().matches("[\\u4e00-\\u9fa5\\w\\-\\_\\(\uff08\\)\uff09]+"))) {
            throw new CommonException("\u683c\u5f0f\u4e0d\u6b63\u786e", "base_invaild_format", "\u4f01\u4e1a\u5168\u79f0");
        }
        if (!(t.getCompanyName() == null || t.getCompanyName().length() <= 255 && t.getCompanyName().matches("[\\u4e00-\\u9fa5\\w\\-\\_\\(\uff08\\)\uff09]+"))) {
            throw new CommonException("\u683c\u5f0f\u4e0d\u6b63\u786e", "base_invaild_format", "\u4f01\u4e1a\u7b80\u79f0");
        }
        this.companyMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"company"}, allEntries=true)
    public void modifyCompanyData(Company t) {
        t.setCompanyCode(null);
        if (StringUtils.isBlank((String)t.getId())) {
            throw new CommonException("companyId\u4e3a\u7a7a", "id_is_blank");
        }
        if (StringUtils.isNotBlank((String)t.getCompanyFullName()) && (t.getCompanyFullName().length() > 255 || !t.getCompanyFullName().matches("[\\u4e00-\\u9fa5\\w\\-\\_\\(\uff08\\)\uff09]+"))) {
            throw new CommonException("\u683c\u5f0f\u4e0d\u6b63\u786e", "base_invaild_format", "\u4f01\u4e1a\u5168\u79f0");
        }
        if (StringUtils.isNotBlank((String)t.getCompanyName()) && (t.getCompanyName().length() > 255 || !t.getCompanyName().matches("[\\u4e00-\\u9fa5\\w\\-\\_\\(\uff08\\)\uff09]+"))) {
            throw new CommonException("\u683c\u5f0f\u4e0d\u6b63\u786e", "base_invaild_format", "\u4f01\u4e1a\u7b80\u79f0");
        }
        this.companyMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"company"}, allEntries=true)
    public void modifyCompanyExecution(String companyId) {
        Assert.isNotBlank(companyId, "\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a!");
        Company t = new Company();
        t.setId(companyId);
        t.setCompanyCode(null);
        if (StringUtils.isBlank((String)t.getId())) {
            throw new CommonException("companyId\u4e3a\u7a7a", "id_is_blank");
        }
        t.setExecution(CompanyExecutionEnum.STATUS_CHANGE_UN_SUBMIT.getStatus());
        this.companyMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public Company queryObjById(String id) {
        return this.companyMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public List<Company> queryAllObjByExample(CompanyExample example) {
        return this.companyMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public PageView<Company> queryObjByPage(CompanyExample example) {
        PageView<Company> pageView = example.getPageView();
        pageView.setQueryResult(this.companyMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public PageView<Company> querySupplerCompanies(String purCompanyId, CompanyExample companyExample) {
        PageView<Company> pageView = companyExample.getPageView();
        List<Company> companyList = this.companyMapper.selectSupCompanyByPage(companyExample, purCompanyId);
        pageView.setQueryResult(companyList);
        return pageView;
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public PageView<Company> queryPurchaseCompaniesByPage(String companyId, CompanyExample companyExample) {
        CompanyPartnerExample partnerExample = new CompanyPartnerExample();
        partnerExample.createCriteria().andPartnerCompanyIdEqualTo(companyId);
        List<CompanyPartner> partnerList = this.companyPartnerMapper.selectByExample(partnerExample);
        if (CollectionUtils.isEmpty(partnerList)) {
            return companyExample.getPageView();
        }
        ArrayList<String> partnerIdList = new ArrayList<String>();
        for (CompanyPartner partner : partnerList) {
            partnerIdList.add(partner.getCompanyId());
        }
        if (CollectionUtils.isEmpty(companyExample.getOredCriteria())) {
            companyExample.createCriteria().andIdIn(partnerIdList).andIsEnableEqualTo(Constant.YES_INT);
        } else {
            for (int i = 0; i < companyExample.getOredCriteria().size(); ++i) {
                companyExample.getOredCriteria().get(i).andIdIn(partnerIdList).andIsEnableEqualTo(Constant.YES_INT);
            }
        }
        List<Company> companyList = this.companyMapper.selectByExampleByPage(companyExample);
        return companyExample.getPageView().setQueryResult(companyList);
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public List<Company> queryPurchaseCompanies(String companyId, CompanyExample companyExample) {
        CompanyPartnerExample partnerExample = new CompanyPartnerExample();
        partnerExample.createCriteria().andPartnerCompanyIdEqualTo(companyId);
        List<CompanyPartner> partnerList = this.companyPartnerMapper.selectByExample(partnerExample);
        if (CollectionUtils.isEmpty(partnerList)) {
            return null;
        }
        ArrayList<String> partnerIdList = new ArrayList<String>();
        for (CompanyPartner partner : partnerList) {
            partnerIdList.add(partner.getCompanyId());
        }
        if (companyExample == null) {
            companyExample = new CompanyExample();
        }
        if (CollectionUtils.isEmpty(companyExample.getOredCriteria())) {
            companyExample.createCriteria().andIdIn(partnerIdList).andIsEnableEqualTo(Constant.YES_INT);
        } else {
            for (int i = 0; i < companyExample.getOredCriteria().size(); ++i) {
                companyExample.getOredCriteria().get(i).andIdIn(partnerIdList).andIsEnableEqualTo(Constant.YES_INT);
            }
        }
        return this.companyMapper.selectByExample(companyExample);
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public Company queryPurchaseCompanies(String supCompanyId) {
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
        List<Company> list = this.queryPurchaseCompanies(supCompanyId, companyExample);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        if (list.size() > 1) {
            throw new CommonException("\u8be5\u4f9b\u5e94\u5546\u6709\u591a\u4e2a\u91c7\u8d2d\u5546");
        }
        return list.get(0);
    }

    @Override
    @Transactional
    @CacheEvict(value={"company"}, allEntries=true)
    public void addCompanyAsSupplier(CompanyPartner companyPartner) {
        if (StringUtils.isBlank((String)companyPartner.getCompanyId())) {
            throw new CommonException("\u91c7\u8d2d\u5546id\u4e0d\u80fd\u4e3a\u7a7a", "id_is_blank");
        }
        if (companyPartner.getPartner() == null) {
            throw new CommonException("\u4f9b\u5e94\u5546\u7684\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u4f9b\u5e94\u5546\u7684\u4fe1\u606f");
        }
        Company partner = companyPartner.getPartner();
        this.addObj(partner);
        companyPartner.setPartnerCompanyId(partner.getId());
        this.companyPartnerMapper.insertSelective(companyPartner);
    }

    @Override
    @CacheEvict(value={"company"}, allEntries=true)
    public void changeCompanyPartnerRole(String companyId, String supplierCompanyId, String roleCode) {
        CompanyPartnerExample partnerExample = new CompanyPartnerExample();
        partnerExample.createCriteria().andCompanyIdEqualTo(companyId).andPartnerCompanyIdEqualTo(supplierCompanyId);
        List<CompanyPartner> list = this.companyPartnerMapper.selectByExample(partnerExample);
        if (CollectionUtils.isEmpty(list)) {
            CompanyPartner partner = new CompanyPartner();
            partner.setCompanyId(companyId);
            partner.setPartnerCompanyId(supplierCompanyId);
            partner.setPartnerCompanyName(this.queryObjById(supplierCompanyId).getCompanyName());
            partner.setPartnerRoleCode(roleCode);
            this.companyPartnerMapper.insertSelective(partner);
        } else {
            CompanyPartner partner = new CompanyPartner();
            partner.setPartnerRoleCode(roleCode);
            this.companyPartnerMapper.updateByExampleSelective(partner, partnerExample);
        }
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public int isEnable(String companyId, Integer isEnable) {
        Company company = new Company();
        company.setId(companyId);
        company.setIsEnable(isEnable);
        return this.companyMapper.updateByPrimaryKeySelective(company);
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public List<Company> queryAllSupplerCompanies(String purCompanyId, CompanyExample companyExample) {
        if (CollectionUtils.isNotEmpty(companyExample.getOredCriteria())) {
            companyExample.getOredCriteria().get(0).andIsEnableEqualTo(Constant.YES_INT);
        }
        List<Company> companyList = this.companyMapper.selectSupCompany(companyExample, purCompanyId);
        return companyList;
    }

    @Override
    public PageView<Company> querySupplerCompanies(String purCompanyId, CompanyExample companyExample, String roleEnum) {
        PageView<Company> pageView = companyExample.getPageView();
        List<Company> list = this.companyMapper.selectPartnerByExampleByPage(purCompanyId, companyExample, roleEnum);
        pageView.setQueryResult(list);
        return pageView;
    }

    @Override
    public PageView<Company> querySupplerCompaniesForApply(String purCompanyId, CompanyExample companyExample, String roleEnum) {
        PageView<Company> pageView = companyExample.getPageView();
        List<Company> list = this.companyMapper.selectPartnerByExampleForApplyByPage(purCompanyId, companyExample, roleEnum);
        pageView.setQueryResult(list);
        return pageView;
    }

    @Override
    public PageView<Company> querySupplerCompaniesForApplyRecognize(String purCompanyId, CompanyExample companyExample, String roleEnum) {
        PageView<Company> pageView = companyExample.getPageView();
        List<Company> list = this.companyMapper.selectPartnerByExampleForApplyRecognizeByPage(purCompanyId, companyExample, roleEnum);
        pageView.setQueryResult(list);
        return pageView;
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public Company queryCompanyByCode(String companyCode) {
        CompanyExample example = new CompanyExample();
        CompanyExample.Criteria criteria = example.createCriteria();
        criteria.andCompanyCodeEqualTo(companyCode);
        List<Company> companyList = this.companyMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(companyList)) {
            return null;
        }
        return companyList.get(0);
    }

    @Override
    @Transactional
    @CacheEvict(value={"company"}, allEntries=true)
    public void updatePartnerRole(CompanyPartner companyPartner, CompanyPartnerExample example) {
        companyPartner.setId(null);
        this.companyPartnerMapper.updateByExampleSelective(companyPartner, example);
    }

    @Override
    @CacheEvict(value={"company"}, allEntries=true)
    public void updatePartnerRoleForApply(CompanyPartner companyPartner, CompanyPartnerExample example) {
        this.companyPartnerMapper.updateByExampleSelectiveForApply(companyPartner, example);
    }

    @Override
    @Transactional
    @CacheEvict(value={"company"}, allEntries=true)
    public String register(Project project, Company company) {
        CompanyExample companyExample = new CompanyExample();
        CompanyExample.Criteria companyExampleCriteria = companyExample.createCriteria();
        companyExampleCriteria.andCompanyFullNameEqualTo(company.getCompanyFullName());
        int count = this.companyMapper.countByExample(companyExample);
        if (count > 0) {
            throw new CommonException("\u516c\u53f8\u540d\u79f0\u5df2\u5b58\u5728,\u4e0d\u80fd\u91cd\u590d", "base_is_exists", "\u516c\u53f8\u540d\u79f0");
        }
        companyExample.clear();
        companyExample.createCriteria().andMobilephoneEqualTo(company.getMobilephone());
        int count2 = this.companyMapper.countByExample(companyExample);
        if (count2 > 0) {
            throw new CommonException("\u624b\u673a\u53f7\u7801 \u5df2\u5b58\u5728,\u4e0d\u80fd\u91cd\u590d", "base_is_exists", "\u624b\u673a\u53f7\u7801 ");
        }
        company.setProjectId(project.getId());
        company.setIsEnable(Constant.YES_INT);
        company.setCreateTime(new Date());
        company.setId(null);
        company.setCompanyCode(this.generateCodeService.getNextCompanyCode());
        company.setExecution(Constant.NO_INT);
        this.dealSencondCompanyTypeData(company);
        this.companyMapper.insertSelective(company);
        User user = new User();
        user.setLoginName(company.getCompanyCode());
        user.setNickName(company.getCompanyFullName());
        user.setMobilePhone(company.getMobilephone());
        user.setPassword(company.getPassword());
        user.setEmail(company.getEmail());
        user.setIsEnable(Constant.YES_INT);
        user.setCreateTime(new Date());
        if (project != null) {
            user.setProjectCode(project.getProjectCode());
        }
        this.userService.addObj(user);
        this.companyUserRefService.addUserIntoCompany(user.getId(), company.getId());
        RoleExample roleExample = new RoleExample();
        RoleExample.Criteria roleExampleCriteria = roleExample.createCriteria();
        roleExampleCriteria.andRoleCodeEqualTo(PartnerRoleEnum.STRANGER.getUserRoleCode());
        List list = this.roleService.queryAllObjByExample((IExample)roleExample);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (Role role : list) {
                UserRole t = new UserRole();
                t.setUserId(user.getId());
                t.setRoleId(role.getId());
                t.setCreateTime(new Date());
                this.userRoleService.addObj((Serializable)t);
            }
        }
        CompanyPartner companyPartner = new CompanyPartner();
        companyPartner.setProjectId(project.getId());
        companyPartner.setCompanyId(project.getCompanyId());
        companyPartner.setPartnerCompanyId(company.getId());
        companyPartner.setPartnerCompanyName(company.getCompanyFullName());
        companyPartner.setPartnerRoleCode(PartnerRoleEnum.STRANGER.getCode());
        companyPartner.setPartnerRoleName(PartnerRoleEnum.STRANGER.getName());
        this.companyPartnerMapper.insertSelective(companyPartner);
        return company.getCompanyCode();
    }

    private void dealSencondCompanyTypeData(Company company) {
        String secondCompanyType = company.getSecondCompanyType();
        if (StringUtils.isBlank((String)secondCompanyType)) {
            throw new CommonException("\u4ea7\u54c1\u5927\u7c7b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String secondCompanyTypeDesc = company.getSecondCompanyTypeDesc();
        if (StringUtils.isBlank((String)secondCompanyTypeDesc)) {
            throw new CommonException("\u4ea7\u54c1\u5927\u7c7b\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String[] typeList = secondCompanyType.split(",");
        String[] typeDescList = secondCompanyTypeDesc.split(",");
        if (typeList.length == 1) {
            company.setProductTypeFirst(typeList[0]);
            company.setProductTypeFirstDesc(typeDescList[0]);
            company.setProductTypeFirstCognizance(Constant.NO_INT);
        } else if (typeList.length == 2) {
            company.setProductTypeFirst(typeList[0]);
            company.setProductTypeFirstDesc(typeDescList[0]);
            company.setProductTypeFirstCognizance(Constant.NO_INT);
            company.setProductTypeSecond(typeList[1]);
            company.setProductTypeSecondDesc(typeDescList[1]);
            company.setProductTypeSecondCognizance(Constant.NO_INT);
        } else if (typeList.length == 3) {
            company.setProductTypeFirst(typeList[0]);
            company.setProductTypeFirstDesc(typeDescList[0]);
            company.setProductTypeFirstCognizance(Constant.NO_INT);
            company.setProductTypeSecond(typeList[1]);
            company.setProductTypeSecondDesc(typeDescList[1]);
            company.setProductTypeSecondCognizance(Constant.NO_INT);
            company.setProductTypeThird(typeList[2]);
            company.setProductTypeThirdDesc(typeDescList[2]);
            company.setProductTypeThirdCognizance(Constant.NO_INT);
        } else if (typeList.length == 4) {
            company.setProductTypeFirst(typeList[0]);
            company.setProductTypeFirstDesc(typeDescList[0]);
            company.setProductTypeFirstCognizance(Constant.NO_INT);
            company.setProductTypeSecond(typeList[1]);
            company.setProductTypeSecondDesc(typeDescList[1]);
            company.setProductTypeSecondCognizance(Constant.NO_INT);
            company.setProductTypeThird(typeList[2]);
            company.setProductTypeThirdDesc(typeDescList[2]);
            company.setProductTypeThirdCognizance(Constant.NO_INT);
            company.setProductTypeFourth(typeList[3]);
            company.setProductTypeFourthDesc(typeDescList[3]);
            company.setProductTypeFourthCognizance(Constant.NO_INT);
        } else if (typeList.length == 5) {
            company.setProductTypeFirst(typeList[0]);
            company.setProductTypeFirstDesc(typeDescList[0]);
            company.setProductTypeFirstCognizance(Constant.NO_INT);
            company.setProductTypeSecond(typeList[1]);
            company.setProductTypeSecondDesc(typeDescList[1]);
            company.setProductTypeSecondCognizance(Constant.NO_INT);
            company.setProductTypeThird(typeList[2]);
            company.setProductTypeThirdDesc(typeDescList[2]);
            company.setProductTypeThirdCognizance(Constant.NO_INT);
            company.setProductTypeFourth(typeList[3]);
            company.setProductTypeFourthDesc(typeDescList[3]);
            company.setProductTypeFourthCognizance(Constant.NO_INT);
            company.setProductTypeFifth(typeList[4]);
            company.setProductTypeFifthDesc(typeDescList[4]);
            company.setProductTypeFifthCognizance(Constant.NO_INT);
        }
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public List<Company> queryChildCompany(String parentId) {
        CompanyExample example = new CompanyExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andParentIdEqualTo(parentId);
        return this.queryAllObjByExample(example);
    }

    @Override
    public PageView<Company> querySupplerCompaniesAndRoleInfo(String purCompanyId, CompanyExample companyExample, List<String> list) {
        PageView<Company> pageView = companyExample.getPageView();
        List<Company> selectPartner = this.companyMapper.selectPartnerByPage(purCompanyId, companyExample, list);
        pageView.setQueryResult(selectPartner);
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"company"}, allEntries=true)
    public void importSupplierCompanyExcel(MultipartFile file, Project project) throws Exception {
        List<TitleAndModelKey> titleAndModelKeys = SupplierCompanyExcelImportUtils.createExcelHeaderVer();
        List companyList = null;
        companyList = ExcelUtils.importExcelDataToMap((InputStream)file.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, Company.class);
        if (CollectionUtils.isNotEmpty((Collection)companyList)) {
            System.out.println("\u603b\u5171\u8981\u5bfc\u5165\u7684\u4f9b\u5e94\u5546\u4e3a\uff1a" + companyList.size());
            for (Company c : companyList) {
                c.setStatus(200);
                if ("\u5185\u8d2d".equals(c.getExternalManufacturer())) {
                    c.setExternalManufacturer("1");
                } else if ("\u8f6c\u5382".equals(c.getExternalManufacturer())) {
                    c.setExternalManufacturer("2");
                } else if ("\u4ea4\u9999\u6e2f".equals(c.getExternalManufacturer())) {
                    c.setExternalManufacturer("3");
                } else {
                    c.setExternalManufacturer("0");
                }
                c.setIsWriteSapSuccess(Constant.YES_INT);
                this.registerImportSupplierCompany(project, c);
                System.out.println("SAP\u7f16\u7801\u4e3a\uff1a" + c.getCompanySapCode() + ",\u751f\u6210\u7684SRM\u7f16\u7801\u4e3a:" + c.getCompanyCode());
                Thread.sleep(1000L);
            }
        }
    }

    private void registerImportSupplierCompany(Project project, Company company) throws Exception {
        if (null == project) {
            throw new CommonException("\u6240\u5c5e\u9879\u76ee\u4fe1\u606f\u4e3a\u7a7a!");
        }
        System.out.println("\u9879\u76ee\u4fe1\u606f\u4e3a\uff1a" + project.getCompanyId() + "," + project.getId() + "," + project.getProjectCode());
        if (StringUtils.isEmpty((String)company.getCompanySapCode())) {
            throw new CommonException("\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5bfc\u5165excel!");
        }
        this.isExistCompanySapCode(company);
        this.addImportExcelSupplierCompany(project, company);
        System.out.println("\u7528\u6237\u8d26\u53f7\u4e3a\uff1a" + company.getCompanyCode());
        User user = this.createSupplierCompanyUserInfo(project, company);
        this.companyUserRefService.addUserIntoCompany(user.getId(), company.getId());
        this.distributeSupplierCompanyRole(user);
        this.createCreateSupplierPartner(project, company);
    }

    private void createCreateSupplierPartner(Project project, Company company) {
        CompanyPartner companyPartner = new CompanyPartner();
        companyPartner.setProjectId(project.getId());
        companyPartner.setCompanyId(project.getCompanyId());
        companyPartner.setPartnerCompanyId(company.getId());
        companyPartner.setPartnerCompanyName(company.getCompanyFullName());
        companyPartner.setPartnerRoleCode(PartnerRoleEnum.QUALIFIED.getCode());
        companyPartner.setPartnerRoleName(PartnerRoleEnum.QUALIFIED.getName());
        this.companyPartnerMapper.insertSelective(companyPartner);
    }

    private void distributeSupplierCompanyRole(User user) {
        RoleExample roleExample = new RoleExample();
        RoleExample.Criteria roleExampleCriteria = roleExample.createCriteria();
        roleExampleCriteria.andRoleCodeEqualTo(PartnerRoleEnum.QUALIFIED.getUserRoleCode());
        List list = this.roleService.queryAllObjByExample((IExample)roleExample);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (Role role : list) {
                UserRole t = new UserRole();
                t.setUserId(user.getId());
                t.setRoleId(role.getId());
                t.setCreateTime(new Date());
                this.userRoleService.addObj((Serializable)t);
            }
        }
    }

    private User createSupplierCompanyUserInfo(Project project, Company company) throws Exception {
        User user = new User();
        user.setId(UUIDGenerator.generateUUID());
        user.setLoginName(company.getCompanyCode());
        user.setNickName(company.getCompanyName());
        user.setPassword("1");
        user.setEmail(company.getEmail());
        user.setIsEnable(Constant.YES_INT);
        user.setCreateTime(new Date());
        if (project != null) {
            user.setProjectCode(project.getProjectCode());
        }
        this.userService.addObj(user);
        this.userService.resetPwd("123456", user.getId());
        return user;
    }

    private void addImportExcelSupplierCompany(Project project, Company company) {
        company.setProjectId(project.getId());
        company.setIsEnable(Constant.YES_INT);
        company.setCreateTime(new Date());
        company.setId(null);
        company.setCompanyCode(this.generateCodeService.getNextCompanyCode());
        this.companyMapper.insertSelective(company);
    }

    private void isExistCompanySapCode(Company company) {
        CompanyExample example = new CompanyExample();
        example.createCriteria().andCompanySapCodeEqualTo(company.getCompanySapCode());
        if (this.companyMapper.countByExample(example) > 0) {
            throw new CommonException("\u8981\u5bfc\u5165\u7684\u4f9b\u5e94\u5546\u7684SAP\u7f16\u7801\u5df2\u5b58\u5728,\u4e0d\u80fd\u91cd\u590d,SAP\u7f16\u7801\u4e3a\uff1a" + company.getCompanySapCode(), "base_is_exists", "\u4f9b\u5e94\u5546\u7684SAP\u7f16\u7801");
        }
    }

    @Override
    @CacheEvict(value={"company"}, allEntries=true)
    public void dealCompanyInfo(MultipartFile file) throws Exception {
        List<TitleAndModelKey> titleAndModelKeys = SupplierCompanyExcelImportUtils.createExcelSAPHeaderVer();
        List companyList = null;
        companyList = ExcelUtils.importExcelDataToMap((InputStream)file.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, Company.class);
        if (CollectionUtils.isNotEmpty((Collection)companyList)) {
            System.out.println("\u8bfb\u53d6\u7684SAP\u6570\u636e\u4e3a\uff1a" + companyList.size());
            CompanyExample example = new CompanyExample();
            int size = 0;
            for (Company c : companyList) {
                System.out.println(c.getCompanySapCode());
                example.clear();
                example.createCriteria().andCompanySapCodeEqualTo(c.getCompanySapCode());
                if (this.companyMapper.countByExample(example) > 0) {
                    ++size;
                }
                c.setIsWriteSapSuccess(Constant.YES_INT);
                this.companyMapper.updateByExampleSelective(c, example);
            }
            System.out.println("\u603b\u5171\u66f4\u65b0\u4e86:" + size);
        }
    }

    @Override
    @CacheEvict(value={"company"}, allEntries=true)
    public void updateCompanyIsWriteToSapStatus(Company company) {
        company.setCompanyCode(null);
        this.companyMapper.updateByPrimaryKeySelective(company);
    }

    @Override
    @Transactional
    @CacheEvict(value={"company"}, allEntries=true)
    public void deleteStrangeSupplierByIds(List<String> ids, Project project, User loginUser) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("id\u53c2\u6570\u4e3a\u7a7a!");
        }
        CompanyExample example = new CompanyExample();
        example.createCriteria().andIdIn((List)ids);
        List<Company> companyList = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(companyList)) {
            throw new CommonException("\u67e5\u8be2\u7684\u6570\u636e\u4e3a\u7a7a!");
        }
        if (ids.size() != companyList.size()) {
            throw new CommonException("\u6240\u4f20\u53c2\u6570\u7684\u90e8\u5206\u4f9b\u5e94\u5546\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5!");
        }
        this.isStrangeSupplier(ids, project);
        this.companyMapper.deleteByExample(example);
        this.deleteCompanyUserInfo(companyList);
        this.deleteCompanyUserRefInfo(ids);
        this.deleteCompanyPartnerInfo(ids);
        CompanyStusChgLogService companyStusChgLogService = (CompanyStusChgLogService)SpringContextHolder.getOneBean(CompanyStusChgLogService.class);
        for (Company c : companyList) {
            companyStusChgLogService.addCompanyDeleteEventLog(c, loginUser);
        }
    }

    private void isStrangeSupplier(List<String> ids, Project project) {
        for (String id : ids) {
            CompanyPartnerExample example = new CompanyPartnerExample();
            CompanyPartnerExample.Criteria criteria = example.createCriteria();
            criteria.andCompanyIdEqualTo(project.getCompanyId()).andPartnerCompanyIdEqualTo(id).andPartnerRoleCodeEqualTo(PartnerRoleEnum.STRANGER.getCode());
            if (this.companyPartnerMapper.countByExample(example) > 0) continue;
            throw new CommonException("\u53ea\u6709\u964c\u751f\u4f9b\u5e94\u5546\u624d\u53ef\u4ee5\u5220\u9664\u6570\u636e!");
        }
    }

    private void deleteCompanyUserInfo(List<Company> companyList) {
        ArrayList<String> companyCodeList = new ArrayList<String>();
        for (Company company : companyList) {
            companyCodeList.add(company.getCompanyCode());
        }
        UserExample example = new UserExample();
        example.createCriteria().andLoginNameIn(companyCodeList).andIsEnableEqualTo(Constant.YES_INT);
        List userList = this.userService.queryAllObjByExample(example);
        if (CollectionUtils.isNotEmpty(userList)) {
            for (User user : userList) {
                this.userRoleService.deleteAllUserRole(user.getId());
            }
        }
        this.userService.deleteUserInfo(example);
    }

    private void deleteCompanyUserRefInfo(List<String> ids) {
        CompanyUserRefExample example = new CompanyUserRefExample();
        example.createCriteria().andCompanyIdIn((List)ids);
        this.companyUserRefService.deleteCompanyUserRefInfo(example);
    }

    private void deleteCompanyPartnerInfo(List<String> ids) {
        CompanyPartnerExample example = new CompanyPartnerExample();
        example.createCriteria().andPartnerCompanyIdIn((List)ids);
        this.companyPartnerMapper.deleteByExample(example);
    }

    @Override
    @Transactional
    @CacheEvict(value={"company"}, allEntries=true)
    public void dealSecondCompanyTypeInfo() {
        CompanyExample example = new CompanyExample();
        List<Company> list = this.queryAllObjByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            for (Company company : list) {
                String secondCompanyTypeDesc;
                String secondCompanyType = company.getSecondCompanyType();
                if (StringUtils.isBlank((String)secondCompanyType) || StringUtils.isBlank((String)(secondCompanyTypeDesc = company.getSecondCompanyTypeDesc()))) continue;
                String[] typeList = secondCompanyType.split(",");
                String[] typeDescList = secondCompanyTypeDesc.split(",");
                Company c = new Company();
                c.setId(company.getId());
                c.setProjectId(company.getProjectId());
                System.out.println(secondCompanyType + ":" + secondCompanyTypeDesc + ":" + c.getId());
                if (typeList.length == 1) {
                    c.setProductTypeFirst(typeList[0]);
                    c.setProductTypeFirstDesc(typeDescList[0]);
                    c.setProductTypeFirstCognizance(Constant.NO_INT);
                } else if (typeList.length == 2) {
                    c.setProductTypeFirst(typeList[0]);
                    c.setProductTypeFirstDesc(typeDescList[0]);
                    c.setProductTypeFirstCognizance(Constant.NO_INT);
                    c.setProductTypeSecond(typeList[1]);
                    c.setProductTypeSecondDesc(typeDescList[1]);
                    c.setProductTypeSecondCognizance(Constant.NO_INT);
                } else if (typeList.length == 3) {
                    c.setProductTypeFirst(typeList[0]);
                    c.setProductTypeFirstDesc(typeDescList[0]);
                    c.setProductTypeFirstCognizance(Constant.NO_INT);
                    c.setProductTypeSecond(typeList[1]);
                    c.setProductTypeSecondDesc(typeDescList[1]);
                    c.setProductTypeSecondCognizance(Constant.NO_INT);
                    c.setProductTypeThird(typeList[2]);
                    c.setProductTypeThirdDesc(typeDescList[2]);
                    c.setProductTypeThirdCognizance(Constant.NO_INT);
                } else if (typeList.length == 4) {
                    c.setProductTypeFirst(typeList[0]);
                    c.setProductTypeFirstDesc(typeDescList[0]);
                    c.setProductTypeFirstCognizance(Constant.NO_INT);
                    c.setProductTypeSecond(typeList[1]);
                    c.setProductTypeSecondDesc(typeDescList[1]);
                    c.setProductTypeSecondCognizance(Constant.NO_INT);
                    c.setProductTypeThird(typeList[2]);
                    c.setProductTypeThirdDesc(typeDescList[2]);
                    c.setProductTypeThirdCognizance(Constant.NO_INT);
                    c.setProductTypeFourth(typeList[3]);
                    c.setProductTypeFourthDesc(typeDescList[3]);
                    c.setProductTypeFourthCognizance(Constant.NO_INT);
                } else if (typeList.length == 5) {
                    c.setProductTypeFirst(typeList[0]);
                    c.setProductTypeFirstDesc(typeDescList[0]);
                    c.setProductTypeFirstCognizance(Constant.NO_INT);
                    c.setProductTypeSecond(typeList[1]);
                    c.setProductTypeSecondDesc(typeDescList[1]);
                    c.setProductTypeSecondCognizance(Constant.NO_INT);
                    c.setProductTypeThird(typeList[2]);
                    c.setProductTypeThirdDesc(typeDescList[2]);
                    c.setProductTypeThirdCognizance(Constant.NO_INT);
                    c.setProductTypeFourth(typeList[3]);
                    c.setProductTypeFourthDesc(typeDescList[3]);
                    c.setProductTypeFourthCognizance(Constant.NO_INT);
                    c.setProductTypeFifth(typeList[4]);
                    c.setProductTypeFifthDesc(typeDescList[4]);
                    c.setProductTypeFifthCognizance(Constant.NO_INT);
                }
                this.companyMapper.updateByPrimaryKeySelective(c);
            }
        }
    }

    @Override
    public void setProductTypeJsonData(Company company) {
        ArrayList<CompanyProductType> list = null;
        if (StringUtils.isNotBlank((String)company.getProductTypeFirst())) {
            list = new ArrayList<CompanyProductType>();
            CompanyProductType firstCompanyType = new CompanyProductType();
            firstCompanyType.setCode(company.getProductTypeFirst());
            firstCompanyType.setDesc(company.getProductTypeFirstDesc());
            firstCompanyType.setFlag(company.getProductTypeFirstCognizance());
            list.add(firstCompanyType);
            if (StringUtils.isNotBlank((String)company.getProductTypeSecond())) {
                CompanyProductType secondCompanyType = new CompanyProductType();
                secondCompanyType.setCode(company.getProductTypeSecond());
                secondCompanyType.setDesc(company.getProductTypeSecondDesc());
                secondCompanyType.setFlag(company.getProductTypeSecondCognizance());
                list.add(secondCompanyType);
                if (StringUtils.isNotBlank((String)company.getProductTypeThird())) {
                    CompanyProductType thirdCompanyType = new CompanyProductType();
                    thirdCompanyType.setCode(company.getProductTypeThird());
                    thirdCompanyType.setDesc(company.getProductTypeThirdDesc());
                    thirdCompanyType.setFlag(company.getProductTypeThirdCognizance());
                    list.add(thirdCompanyType);
                    if (StringUtils.isNotBlank((String)company.getProductTypeFourth())) {
                        CompanyProductType fourthCompanyType = new CompanyProductType();
                        fourthCompanyType.setCode(company.getProductTypeFourth());
                        fourthCompanyType.setDesc(company.getProductTypeFourthDesc());
                        fourthCompanyType.setFlag(company.getProductTypeFourthCognizance());
                        list.add(fourthCompanyType);
                        if (StringUtils.isNotBlank((String)company.getProductTypeFifth())) {
                            CompanyProductType fifthCompanyType = new CompanyProductType();
                            fifthCompanyType.setCode(company.getProductTypeFifth());
                            fifthCompanyType.setDesc(company.getProductTypeFifthDesc());
                            fifthCompanyType.setFlag(company.getProductTypeFifthCognizance());
                            list.add(fifthCompanyType);
                        }
                    }
                }
            }
        }
        company.setProductTypeJson(list);
    }

    @Override
    public void handleSecondCompanyType(Company company) {
        List<CompanyProductType> list = company.getProductTypeJson();
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u4ea7\u54c1\u5927\u7c7b\u660e\u7ec6\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String secondCompanyType = company.getSecondCompanyType();
        String[] secondCompanyTypeList = secondCompanyType.split(",");
        if (secondCompanyTypeList.length != list.size()) {
            throw new CommonException("\u4ea7\u54c1\u5927\u7c7b\u4e0e\u4ea7\u54c1\u5927\u7c7b\u660e\u7ec6\u6570\u7ec4\u4e2a\u6570\u4e0d\u4e00\u81f4!");
        }
        this.cleanSupplierCompanyType(company);
        company.setProductTypeFirst(list.get(0).getCode());
        company.setProductTypeFirstDesc(list.get(0).getDesc());
        company.setProductTypeFirstCognizance(list.get(0).getFlag());
        if (list.size() >= 2) {
            company.setProductTypeSecond(list.get(1).getCode());
            company.setProductTypeSecondDesc(list.get(1).getDesc());
            company.setProductTypeSecondCognizance(list.get(1).getFlag());
            if (list.size() >= 3) {
                company.setProductTypeThird(list.get(2).getCode());
                company.setProductTypeThirdDesc(list.get(2).getDesc());
                company.setProductTypeThirdCognizance(list.get(2).getFlag());
                if (list.size() >= 4) {
                    company.setProductTypeFourth(list.get(3).getCode());
                    company.setProductTypeFourthDesc(list.get(3).getDesc());
                    company.setProductTypeFourthCognizance(list.get(3).getFlag());
                    if (list.size() >= 5) {
                        company.setProductTypeFifth(list.get(4).getCode());
                        company.setProductTypeFifthDesc(list.get(4).getDesc());
                        company.setProductTypeFifthCognizance(list.get(4).getFlag());
                    }
                }
            }
        }
    }

    private void cleanSupplierCompanyType(Company company) {
        company.setProductTypeFirst("");
        company.setProductTypeFirstDesc("");
        company.setProductTypeFirstCognizance(Constant.NO_INT);
        company.setProductTypeSecond("");
        company.setProductTypeSecondDesc("");
        company.setProductTypeSecondCognizance(Constant.NO_INT);
        company.setProductTypeThird("");
        company.setProductTypeThirdDesc("");
        company.setProductTypeThirdCognizance(Constant.NO_INT);
        company.setProductTypeFourth("");
        company.setProductTypeFourthDesc("");
        company.setProductTypeFourthCognizance(Constant.NO_INT);
        company.setProductTypeFifth("");
        company.setProductTypeFifthDesc("");
        company.setProductTypeFifthCognizance(Constant.NO_INT);
    }
}

