/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.adjust.command;

import com.els.base.company.entity.Company;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.mould.adjust.entity.MouldAdjustMaterial;
import com.els.base.mould.adjust.vo.AdjustDetailVo;
import com.els.base.mould.adjust.vo.AdjustVo;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class CreateMouldAdjustCmd
extends AbstractMouldCommand<String> {
    private static final String ADJUST_BILL_NO = "ADJUST_BILL_NO";
    private AdjustVo adjustVo;

    public CreateMouldAdjustCmd(AdjustVo adjustVo) {
        this.adjustVo = adjustVo;
    }

    @Override
    public String execute(MouldInvorker mouldInvorker) {
        this.verification(this.adjustVo);
        this.compleMouldAdjust(this.adjustVo, mouldInvorker);
        mouldInvorker.getMouldAdjustService().addObj(this.adjustVo);
        for (AdjustDetailVo adjustDetailVo : this.adjustVo.getMouldAdjustDetailList()) {
            mouldInvorker.getMouldAdjustDetailService().addObj(adjustDetailVo);
            List<MouldAdjustMaterial> moudlAdjustMaterialList = adjustDetailVo.getMouldAdjustMaterialList();
            for (MouldAdjustMaterial mouldAdjustMaterial : moudlAdjustMaterialList) {
                mouldInvorker.getMouldAdjustMaterialService().addObj(mouldAdjustMaterial);
            }
        }
        return null;
    }

    private void compleMouldAdjust(AdjustVo vo, MouldInvorker mouldInvorker) {
        String id = UUIDGenerator.generateUUID();
        vo.setId(id);
        vo.setProjectId(ProjectUtils.getProjectId());
        Company purCompany = this.getPurCompany();
        vo.setPurCompanyId(purCompany.getId());
        vo.setPurCompanySrmCode(purCompany.getCompanyCode());
        vo.setPurCompanyName(purCompany.getCompanyName());
        vo.setPurCompanyFullName(purCompany.getCompanyFullName());
        vo.setIsEnable(Constant.YES_INT);
        String adjustBillNo = mouldInvorker.getGenerateCodeService().getNextCode(ADJUST_BILL_NO);
        vo.setAdjustBillNo(adjustBillNo);
        vo.setCreateBillUserName(this.getPurUser().getNickName());
        vo.setPurUserId(this.getPurUser().getId());
        vo.setSendStatus(Constant.NO_INT);
        vo.setIsEnable(Constant.YES_INT);
        vo.setConfirmStatus(Constant.NO_INT);
        vo.setCreateTime(new Date());
        for (AdjustDetailVo detial : vo.getMouldAdjustDetailList()) {
            String uuid = UUIDGenerator.generateUUID();
            detial.setId(uuid);
            detial.setProjectId(vo.getProjectId());
            detial.setAdjustId(id);
            detial.setCreateTime(new Date());
            for (MouldAdjustMaterial material : detial.getMouldAdjustMaterialList()) {
                material.setAdjustDetailId(uuid);
                material.setProjectId(vo.getProjectId());
                material.setAdjustId(id);
                material.setCreateTime(new Date());
            }
        }
    }

    private void verification(AdjustVo vo) {
        Assert.isNotNull(vo, "\u63d0\u4ea4\u7684\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
        Assert.isNotBlank(vo.getSupCompanyId(), "\u63d0\u4ea4\u7684\u4f9b\u5e94\u5546id\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
        Assert.isNotBlank(vo.getSupCompanySrmCode(), "\u63d0\u4ea4\u7684\u4f9b\u5e94\u5546SRM\u7f16\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
        Assert.isNotBlank(vo.getSupCompanySapCode(), "\u63d0\u4ea4\u7684\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
        Assert.isNotBlank(vo.getSupCompanyName(), "\u63d0\u4ea4\u7684\u4f9b\u5e94\u5546\u7b80\u79f0\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
        Assert.isNotBlank(vo.getSupCompanyFullName(), "\u63d0\u4ea4\u7684\u4f9b\u5e94\u5546\u5168\u79f0\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
        Assert.isNotNull(vo.getChangeType(), "\u63d0\u4ea4\u7684\u53d8\u66f4\u7c7b\u578b\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
        if (CollectionUtils.isEmpty(vo.getMouldAdjustDetailList())) {
            throw new CommonException("\u63d0\u4ea4\u7684\u6a21\u5177\u4fe1\u606f\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
        }
        for (AdjustDetailVo detail : vo.getMouldAdjustDetailList()) {
            Assert.isNotBlank(detail.getMouldId(), "\u63d0\u4ea4\u7684\u6a21\u5177ID\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
            Assert.isNotBlank(detail.getMouldCode(), "\u63d0\u4ea4\u7684\u6a21\u5177\u7f16\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
            Assert.isNotBlank(detail.getMouldDesc(), "\u63d0\u4ea4\u7684\u6a21\u5177\u63cf\u8ff0\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
            Assert.isNotNull(detail.getMouldPrimaryLifetime(), "\u63d0\u4ea4\u7684\u6a21\u5177\u539f\u5bff\u547d\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
            if (CollectionUtils.isEmpty(detail.getMouldAdjustMaterialList())) {
                throw new CommonException("\u63d0\u4ea4\u7684\u7269\u6599\u4fe1\u606f\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
            }
            for (MouldAdjustMaterial mouldAdjustMaterial : detail.getMouldAdjustMaterialList()) {
                Assert.isNotBlank(mouldAdjustMaterial.getMaterialCode(), "\u8c03\u6574\u5355\u660e\u7ec6\u91cc\u7684\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isNotNull(mouldAdjustMaterial.getIsCalculated(), "\u8c03\u6574\u5355\u660e\u7ec6\u91cc\u7684\u7269\u6599\u662f\u5426\u6838\u7b97\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isNotNull(mouldAdjustMaterial.getProductMouldQuantity(), "\u8c03\u6574\u5355\u660e\u7ec6\u91cc\u7684\u51fa\u6a21\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

