/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.adjust.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.mould.adjust.command.CreateMouldAdjustCmd;
import com.els.base.mould.adjust.command.ModifyMouldAdjustCmd;
import com.els.base.mould.adjust.entity.MouldAdjust;
import com.els.base.mould.adjust.entity.MouldAdjustDetail;
import com.els.base.mould.adjust.entity.MouldAdjustDetailExample;
import com.els.base.mould.adjust.entity.MouldAdjustExample;
import com.els.base.mould.adjust.entity.MouldAdjustMaterial;
import com.els.base.mould.adjust.entity.MouldAdjustMaterialExample;
import com.els.base.mould.adjust.service.MouldAdjustDetailService;
import com.els.base.mould.adjust.service.MouldAdjustMaterialService;
import com.els.base.mould.adjust.service.MouldAdjustService;
import com.els.base.mould.adjust.vo.AdjustDetailVo;
import com.els.base.mould.adjust.vo.AdjustVo;
import com.els.base.mould.common.MouldInvorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u8d44\u4ea7\u7ba1\u7406-\u6a21\u5177\u5bff\u547d/\u79fb\u6a21\u8c03\u6574\u5355")
@Controller
@RequestMapping(value={"mouldAdjust"})
public class MouldAdjustController {
    @Resource
    private MouldInvorker Invoker;
    @Resource
    private MouldAdjustDetailService mouldAdjustDetailService;
    @Resource
    private MouldAdjustMaterialService mouldAdjustMaterialService;
    @Resource
    protected MouldAdjustService mouldAdjustService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8d44\u4ea7\u7ba1\u7406-\u6a21\u5177\u5bff\u547d/\u79fb\u6a21\u8c03\u6574\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody AdjustVo adjustVo) {
        CreateMouldAdjustCmd cmd = new CreateMouldAdjustCmd(adjustVo);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.Invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8d44\u4ea7\u7ba1\u7406-\u6a21\u5177\u5bff\u547d/\u79fb\u6a21\u8c03\u6574\u5355")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody AdjustVo adjustVo) {
        Assert.isNotBlank(adjustVo.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        MouldAdjustExample adjustExample = new MouldAdjustExample();
        adjustExample.createCriteria().andIdEqualTo(adjustVo.getId()).andSendStatusEqualTo(Constant.YES_INT).andIsEnableEqualTo(Constant.YES_INT);
        List list = this.mouldAdjustService.queryAllObjByExample(adjustExample);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new CommonException("\u8be5\u5355\u636e\u5df2\u53d1\u9001\u7ed9\u4f9b\u5e94\u5546,\u65e0\u6cd5\u4fee\u6539\u6570\u636e!");
        }
        ModifyMouldAdjustCmd cmd = new ModifyMouldAdjustCmd(adjustVo);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.Invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u8d44\u4ea7\u7ba1\u7406-\u6a21\u5177\u5bff\u547d/\u79fb\u6a21\u8c03\u6574\u5355")
    @RequestMapping(value={"service/deleteAdjusts"})
    @ResponseBody
    public ResponseResult<String> deleteAdjusts(@RequestBody List<String> ids) {
        this.mouldAdjustService.deleteAdjusts(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u5355\u636e")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<AdjustVo> findById(@RequestParam(required=true) String id) {
        Assert.isNotNull(id, "id\u4e0d\u80fd\u4e3a\u7a7a");
        MouldAdjust adjust = (MouldAdjust)this.mouldAdjustService.queryObjById(id);
        if (adjust == null) {
            throw new CommonException("\u8be5\u5355\u636e\u4e3a\u7a7a");
        }
        AdjustVo vo = new AdjustVo();
        BeanUtils.copyProperties((Object)adjust, (Object)vo);
        MouldAdjustDetailExample detailExample = new MouldAdjustDetailExample();
        detailExample.createCriteria().andAdjustIdEqualTo(id);
        List mouldAdjustDetails = this.mouldAdjustDetailService.queryAllObjByExample(detailExample);
        if (CollectionUtils.isEmpty(mouldAdjustDetails)) {
            return ResponseResult.success(vo);
        }
        ArrayList<AdjustDetailVo> detailList = new ArrayList<AdjustDetailVo>();
        for (MouldAdjustDetail mouldAdjustDetail : mouldAdjustDetails) {
            AdjustDetailVo detailVo = new AdjustDetailVo();
            BeanUtils.copyProperties((Object)mouldAdjustDetail, (Object)detailVo);
            MouldAdjustMaterialExample materialExample = new MouldAdjustMaterialExample();
            materialExample.createCriteria().andAdjustDetailIdEqualTo(mouldAdjustDetail.getId());
            List<MouldAdjustMaterial> mouldAdjustMaterials = this.mouldAdjustMaterialService.queryAllObjByExample(materialExample);
            detailVo.setMouldAdjustMaterialList(mouldAdjustMaterials);
            detailList.add(detailVo);
        }
        vo.setMouldAdjustDetailList(detailList);
        return ResponseResult.success(vo);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8d44\u4ea7\u7ba1\u7406-\u6a21\u5177\u5bff\u547d/\u79fb\u6a21\u8c03\u6574\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MouldAdjust", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MouldAdjust>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MouldAdjustExample example = new MouldAdjustExample();
        example.setPageView(new PageView<MouldAdjust>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        MouldAdjustExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.mouldAdjustService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8d44\u4ea7\u7ba1\u7406-\u6a21\u5177\u5bff\u547d/\u79fb\u6a21\u8c03\u6574\u5355(\u4f9b\u5e94\u5546\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MouldAdjust", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageSup"})
    @ResponseBody
    public ResponseResult<PageView<MouldAdjust>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MouldAdjustExample example = new MouldAdjustExample();
        example.setPageView(new PageView<MouldAdjust>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        MouldAdjustExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andSendStatusEqualTo(Constant.YES_INT).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.mouldAdjustService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u8d44\u4ea7\u7ba1\u7406-\u6a21\u5177\u5bff\u547d/\u79fb\u6a21\u8c03\u6574\u5355--\u6279\u91cf\u53d1\u9001\u7ed9\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/send"})
    @ResponseBody
    public ResponseResult<String> sendToSup(@RequestBody(required=true) List<String> ids) {
        this.mouldAdjustService.sendToSup(SpringSecurityUtils.getLoginUser(), ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8d44\u4ea7\u7ba1\u7406-\u6a21\u5177\u5bff\u547d/\u79fb\u6a21\u8c03\u6574\u5355--\u4f9b\u5e94\u5546\u786e\u8ba4\u5355\u636e")
    @RequestMapping(value={"service/confirm"})
    @ResponseBody
    public ResponseResult<String> confirm(@RequestBody(required=true) List<String> ids) {
        this.mouldAdjustService.confirm(SpringSecurityUtils.getLoginUser(), ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u6a21\u5177id\u751f\u6210\u5355\u636e\u884c\u4fe1\u606f")
    @RequestMapping(value={"service/pur/generateAdjustByMouldId"})
    @ResponseBody
    public ResponseResult<List<AdjustDetailVo>> generateNoticeItemByMouldId(@RequestBody List<String> mouldIds) {
        List<AdjustDetailVo> list = this.mouldAdjustService.generateAdjustByMouldId(mouldIds);
        return ResponseResult.success(list);
    }
}

