/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.notice.common;

import com.els.base.company.entity.Company;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.notice.entity.MouldNoticeMaterial;
import com.els.base.mould.notice.entity.MouldNoticePlan;
import com.els.base.mould.notice.vo.MouldNoticeItemVO;
import com.els.base.mould.notice.vo.MouldNoticeVO;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class CreateMouldNoticeCmd
extends AbstractMouldCommand<String> {
    private static final String NOTICE_BILL_NO = "NOTICE_BILL_NO";
    private MouldNoticeVO mouldNoticeVo;

    public CreateMouldNoticeCmd(MouldNoticeVO mouldNoticeVo) {
        this.mouldNoticeVo = mouldNoticeVo;
    }

    @Override
    public String execute(MouldInvorker mouldInvorker) {
        this.verificatData(this.mouldNoticeVo);
        this.completeMouldNoticeData(this.mouldNoticeVo, mouldInvorker);
        mouldInvorker.getMouldNoticeService().addObj(this.mouldNoticeVo);
        for (MouldNoticeItemVO item : this.mouldNoticeVo.getItemVoList()) {
            mouldInvorker.getMouldNoticeItemService().addObj(item);
            for (MouldNoticePlan plan : item.getCreatePlanList()) {
                mouldInvorker.getMouldNoticePlanService().addObj(plan);
            }
            for (MouldNoticeMaterial material : item.getMaterialList()) {
                mouldInvorker.getMouldNoticeMaterialService().addObj(material);
            }
        }
        return null;
    }

    private void completeMouldNoticeData(MouldNoticeVO vo, MouldInvorker mouldInvorker) {
        String id = UUIDGenerator.generateUUID();
        vo.setId(id);
        vo.setProjectId(ProjectUtils.getProjectId());
        Company purCompany = this.getPurCompany();
        vo.setPurCompanyId(purCompany.getId());
        vo.setPurCompanySrmCode(purCompany.getCompanyCode());
        vo.setPurCompanyName(purCompany.getCompanyName());
        vo.setPurCompanyFullName(purCompany.getCompanyFullName());
        String mouldNoticeBillNo = mouldInvorker.getGenerateCodeService().getNextCode(NOTICE_BILL_NO);
        vo.setMouldNoticeBillNo(mouldNoticeBillNo);
        vo.setCreateBillUserName(this.getPurUser().getNickName());
        vo.setPurUserId(this.getPurUser().getId());
        vo.setSendStatus(Constant.NO_INT);
        vo.setIsEnable(Constant.YES_INT);
        vo.setConfirmStatus(Constant.NO_INT);
        vo.setCreateTime(new Date());
        for (MouldNoticeItemVO item : vo.getItemVoList()) {
            String itemId = UUIDGenerator.generateUUID();
            item.setId(itemId);
            item.setMouldNoticeId(id);
            item.setCreateTime(new Date());
            item.setCreatePlanList(mouldInvorker.getMouldNoticeService().generatePlanInfo());
            for (MouldNoticePlan plan : item.getCreatePlanList()) {
                plan.setMouldNoticeId(id);
                plan.setNoticeItemId(itemId);
                plan.setCreateTime(new Date());
            }
            for (MouldNoticeMaterial material : item.getMaterialList()) {
                material.setMouldNoticeId(id);
                material.setNoticeItemId(itemId);
                material.setCreateTime(new Date());
            }
        }
    }

    private void verificatData(MouldNoticeVO vo) {
        Assert.isNotNull(vo, "\u63d0\u4ea4\u7684\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
        Assert.isNotBlank(vo.getSupCompanyId(), "\u63d0\u4ea4\u7684\u4f9b\u5e94\u5546id\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
        Assert.isNotBlank(vo.getSupCompanySrmCode(), "\u63d0\u4ea4\u7684\u4f9b\u5e94\u5546SRM\u7f16\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
        Assert.isNotBlank(vo.getSupCompanySapCode(), "\u63d0\u4ea4\u7684\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
        Assert.isNotBlank(vo.getSupCompanyName(), "\u63d0\u4ea4\u7684\u4f9b\u5e94\u5546\u7b80\u79f0\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
        Assert.isNotBlank(vo.getSupCompanyFullName(), "\u63d0\u4ea4\u7684\u4f9b\u5e94\u5546\u5168\u79f0\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
        Assert.isNotBlank(vo.getComponentType(), "\u63d0\u4ea4\u7684\u90e8\u54c1\u7c7b\u578b\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
        Assert.isNotBlank(vo.getComponentTypeDesc(), "\u63d0\u4ea4\u7684\u90e8\u54c1\u7c7b\u578b\u63cf\u8ff0\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
        Assert.isNotNull(vo.getMouldNoticeBillType(), "\u63d0\u4ea4\u7684\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
        if (CollectionUtils.isEmpty(vo.getItemVoList())) {
            throw new CommonException("\u63d0\u4ea4\u7684\u6a21\u5177\u4fe1\u606f\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
        }
        for (MouldNoticeItemVO item : vo.getItemVoList()) {
            Assert.isNotBlank(item.getMouldId(), "\u63d0\u4ea4\u7684\u6a21\u5177ID\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
            Assert.isNotBlank(item.getMouldCode(), "\u63d0\u4ea4\u7684\u6a21\u5177\u7f16\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
            Assert.isNotBlank(item.getMouldDesc(), "\u63d0\u4ea4\u7684\u6a21\u5177\u63cf\u8ff0\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
            Assert.isNotNull(item.getMouldLifetime(), "\u63d0\u4ea4\u7684\u6a21\u5177\u5bff\u547d\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
            List<MouldNoticeMaterial> materialList = item.getMaterialList();
            if (CollectionUtils.isEmpty(materialList)) {
                throw new CommonException("\u63d0\u4ea4\u7684\u6a21\u5177\u7269\u6599\u4fe1\u606f\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
            }
            for (MouldNoticeMaterial material : materialList) {
                Assert.isNotBlank(material.getMaterialCode(), "\u63d0\u4ea4\u7684\u6a21\u5177\u7269\u6599\u7f16\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
                Assert.isNotNull(material.getProductMouldQuantity(), "\u63d0\u4ea4\u7684\u6a21\u5177\u7269\u6599\u51fa\u6a21\u6570\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u5355\u636e!");
            }
        }
    }
}

