/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.delivery;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.command.order.ModifyOrderItemForDeliveryCmd;
import com.els.base.purchase.entity.DeliveryOrder;
import com.els.base.purchase.entity.DeliveryOrderItem;
import com.els.base.purchase.entity.DeliveryOrderItemExample;
import com.els.base.purchase.utils.DeliveryStatusEnum;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class BatchCancelCommand
extends AbstractOrderCommand<String> {
    private List<String> deliveryOrderIdList;

    public BatchCancelCommand(List<String> deliveryOrderIdList) {
        this.deliveryOrderIdList = deliveryOrderIdList;
    }

    @Override
    public String execute(OrderComandInvoker context) {
        for (String id : this.deliveryOrderIdList) {
            DeliveryOrder deliveryOrder = (DeliveryOrder)context.getDeliveryOrderService().queryObjById(id);
            this.cancelDeliveryOrder(deliveryOrder);
        }
        return null;
    }

    protected void cancelDeliveryOrder(DeliveryOrder deliveryOrder) {
        if (deliveryOrder == null) {
            throw new CommonException("\u6ca1\u6709\u627e\u5230\u8be5\u53d1\u8d27\u5355", "do_not_exists", "\u53d1\u8d27\u5355");
        }
        if (deliveryOrder.getDeliveryStatus() == null) {
            throw new CommonException("\u9001\u8d27\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u9001\u8d27\u5355\u72b6\u6001");
        }
        if (Constant.NO_INT.equals(deliveryOrder.getIsEnable())) {
            throw new CommonException("\u8be5\u9001\u8d27\u5355\u5df2\u7ecf\u4f5c\u5e9f\u4e86\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u540e\u518d\u64cd\u4f5c");
        }
        if (!DeliveryStatusEnum.ONWAY.getValue().equals(deliveryOrder.getDeliveryStatus()) && !DeliveryStatusEnum.UN_SENT.getValue().equals(deliveryOrder.getDeliveryStatus())) {
            throw new CommonException("\u8be5\u9001\u8d27\u5355\u5ba2\u6237\u5df2\u6536\u8d27\uff0c\u4e0d\u53ef\u4f5c\u5e9f\u53d1\u8d27\uff0c\u8c22\u8c22\uff01", "the_customer_has_received_the_goods");
        }
        if (StringUtils.isNotEmpty((String)deliveryOrder.getLogisticOrderNo())) {
            throw new CommonException("\u8be5\u9001\u8d27\u5355\u5df2\u521b\u5efa\u5728" + deliveryOrder.getLogisticOrderNo() + "\u7269\u6d41\u5355\u5185\uff0c\u8bf7\u5220\u9664\u7269\u6d41\u5355\u540e\u518d\u4f5c\u5e9f\u53d1\u8d27\u5355", "delivery_order_backout_error", deliveryOrder.getLogisticOrderNo());
        }
        List<DeliveryOrderItem> deliveryOrderItems = this.context.getDeliveryOrderItemService().queryByDeliveryOrderId(deliveryOrder.getId());
        for (int i = 0; CollectionUtils.isNotEmpty(deliveryOrderItems) && i < deliveryOrderItems.size(); ++i) {
            DeliveryOrderItem deliveryOrderItem = deliveryOrderItems.get(i);
            ModifyOrderItemForDeliveryCmd command = new ModifyOrderItemForDeliveryCmd(deliveryOrderItem.getPurOrderItemId(), "DO_CANCEL", deliveryOrderItem.getDeliveryQuantity());
            this.context.invoke(command);
        }
        DeliveryOrderItemExample deliveryOrderItemExample = new DeliveryOrderItemExample();
        deliveryOrderItemExample.createCriteria().andDeliveryOrderIdEqualTo(deliveryOrder.getId());
        DeliveryOrderItem tempItem = new DeliveryOrderItem();
        tempItem.setIsEnable(Constant.NO_INT);
        this.context.getDeliveryOrderItemService().updateDeliveryOrderItem(tempItem, deliveryOrderItemExample);
        deliveryOrder.setIsEnable(Constant.NO_INT);
        this.context.getDeliveryOrderService().modifyAndAddHis(deliveryOrder, "\u4f5c\u5e9f\u53d1\u8d27\u5355");
    }
}

