/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.command.order.ConfirmTheWholeOrderCommand;
import com.els.base.purchase.command.order.RefusePartOfOrderCommand;
import com.els.base.purchase.command.order.RefuseTheWholeOrderCommand;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderExample;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.entity.SupplierOrderItemExample;
import com.els.base.purchase.service.SupplierOrderItemService;
import com.els.base.purchase.service.SupplierOrderService;
import com.els.base.purchase.utils.PurchaseOrderDeliveryStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderStatusEnum;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.qqt.message.client.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u9500\u552e\u8ba2\u5355\u5934")
@Controller
@RequestMapping(value={"supplierOrder"})
public class SupplierOrderController {
    private static Logger logger = LoggerFactory.getLogger(SupplierOrderController.class);
    @Resource
    protected OrderComandInvoker orderComandInvoker;
    @Resource
    protected SupplierOrderService supplierOrderService;
    @Resource
    protected SupplierOrderItemService supplierOrderItemService;

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u5934")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<SupplierOrder>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SupplierOrder") @RequestBody(required=false) QueryParamWapper wapper) {
        SupplierOrderExample example = new SupplierOrderExample();
        example.setPageView(new PageView<SupplierOrder>(pageNo, pageSize));
        String companyId = CompanyUtils.currentCompanyId();
        String projectId = ProjectUtils.getProjectId();
        SupplierOrderExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(projectId);
        criteria.andCompanyIdEqualTo(companyId);
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        example.setOrderByClause(" ORDER_NO DESC ");
        PageView<SupplierOrder> pageData = this.supplierOrderService.findByPageForAvaliableOrder(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u8ba2\u5355\u534f\u540c-\u4f9b\u5e94\u5546\u8ba2\u5355\u67e5\u8be2")
    @RequestMapping(value={"service/findByPageForAll"})
    @ResponseBody
    public ResponseResult<PageView<SupplierOrder>> findByPageForAll(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u5ba2\u6237\u7269\u6599\u7f16\u7801") @RequestParam(required=false) String purMaterialCode, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SupplierOrder") @RequestBody(required=false) QueryParamWapper wapper) {
        SupplierOrderExample example = new SupplierOrderExample();
        example.setPageView(new PageView<SupplierOrder>(pageNo, pageSize));
        ArrayList<Integer> isEnableValues = new ArrayList<Integer>();
        isEnableValues.add(1);
        isEnableValues.add(2);
        SupplierOrderExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsEnableIn(isEnableValues);
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        if (StringUtils.isNotBlank((String)purMaterialCode)) {
            SupplierOrderItemExample orderItemExample = new SupplierOrderItemExample();
            SupplierOrderItemExample.Criteria cri = orderItemExample.createCriteria();
            cri.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
            if (purMaterialCode.matches("^\\s*\\S+(\\s+\\S+)+\\s*$")) {
                cri.andMaterialCodeIn((List)Arrays.asList(purMaterialCode.trim().split("\\s+")));
            } else {
                cri.andMaterialCodeLike("%" + purMaterialCode + "%");
            }
            List<String> orderIdList = this.supplierOrderItemService.queryOrderIdByExample(orderItemExample);
            if (CollectionUtils.isEmpty(orderIdList)) {
                return ResponseResult.success(new PageView(pageNo, pageSize));
            }
            criteria.andIdIn((List)orderIdList);
        }
        example.setOrderByClause(" ORDER_NO DESC ");
        PageView<SupplierOrder> pageData = this.supplierOrderService.findByPageForAvaliableOrder(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u672a\u5b8c\u6210\u8ba2\u5355")
    @RequestMapping(value={"service/findUnFinishedOrder"})
    @ResponseBody
    public ResponseResult<PageView<SupplierOrder>> findUnFinishedOrder(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u4f9b\u5e94\u5546\u7269\u6599\u7f16\u7801") @RequestParam(required=false) String supMaterialCode, @ApiParam(value="\u5ba2\u6237\u7269\u6599\u7f16\u7801") @RequestParam(required=false) String purMaterialCode, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SupplierOrder") @RequestBody(required=false) QueryParamWapper wapper) {
        ArrayList<Integer> isEnableValues = new ArrayList<Integer>();
        isEnableValues.add(1);
        isEnableValues.add(2);
        SupplierOrderExample example = new SupplierOrderExample();
        example.setPageView(new PageView<SupplierOrder>(pageNo, pageSize));
        SupplierOrderExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsEnableIn(isEnableValues).andDeliveryStatusIn((List)Arrays.asList(PurchaseOrderDeliveryStatusEnum.RECEVIED_NONE.getValue(), PurchaseOrderDeliveryStatusEnum.RECEIVED_PART.getValue()));
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        if (StringUtils.isNotBlank((String)supMaterialCode) || StringUtils.isNotBlank((String)purMaterialCode)) {
            List<String> orderIdList;
            SupplierOrderItemExample orderItemExample = new SupplierOrderItemExample();
            SupplierOrderItemExample.Criteria cri = orderItemExample.createCriteria().andCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andFinishFlagEqualTo("N");
            if (StringUtils.isNotBlank((String)supMaterialCode)) {
                if (supMaterialCode.matches("^\\s*\\S+(\\s+\\S+)+\\s*$")) {
                    cri.andSupMaterialCodeIn((List)Arrays.asList(supMaterialCode.trim().split("\\s+")));
                } else {
                    cri.andSupMaterialCodeLike("%" + supMaterialCode + "%");
                }
            }
            if (StringUtils.isNotBlank((String)purMaterialCode)) {
                if (purMaterialCode.matches("^\\s*\\S+(\\s+\\S+)+\\s*$")) {
                    cri.andMaterialCodeIn((List)Arrays.asList(purMaterialCode.trim().split("\\s+")));
                } else {
                    cri.andMaterialCodeLike("%" + purMaterialCode + "%");
                }
            }
            if (CollectionUtils.isEmpty(orderIdList = this.supplierOrderItemService.queryOrderIdByExample(orderItemExample))) {
                return ResponseResult.success(new PageView(pageNo, pageSize));
            }
            criteria.andIdIn((List)orderIdList);
        }
        example.setOrderByClause(" ORDER_NO DESC ");
        PageView<SupplierOrder> pageData = this.supplierOrderService.findByPageForAvaliableOrder(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u9500\u552e\u65b9\u62d2\u7edd\u6216\u8005\u786e\u8ba4\u8ba2\u5355\u884c\uff1a\u5165\u53c2\uff08\u6574\u4e2a\u9500\u552e\u5355\u5b9e\u4f53\u5305\u62ec\u884c\u9879\u76ee\uff09")
    @RequestMapping(value={"service/supplierOrderItemRefuse"})
    @ResponseBody
    public ResponseResult<String> supplierOrderItemRefuse(@RequestBody SupplierOrder supplierOrder) {
        Assert.isNotNull(supplierOrder, "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(supplierOrder.getItems(), "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null");
        RefusePartOfOrderCommand command = new RefusePartOfOrderCommand(supplierOrder);
        command.setSupCompany(CompanyUtils.currentCompany());
        command.setSupUser((User)SpringSecurityUtils.getLoginUser());
        this.orderComandInvoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u9500\u552e\u65b9\u6279\u91cf\u62d2\u7edd\u6216\u8005\u786e\u8ba4\u8ba2\u5355\u5934\uff1a\u5165\u53c2\uff08\u6574\u4e2a\u9500\u552e\u5355\u5b9e\u4f53\u6570\u7ec4\uff09")
    @RequestMapping(value={"service/supplierOrderRefuseOrComfirm"})
    @ResponseBody
    public ResponseResult<String> supplierOrderRefuseOrComfirm(@RequestBody List<SupplierOrder> supplierOrderList) {
        Assert.isNotEmpty(supplierOrderList, "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null");
        for (SupplierOrder supplierOrder2 : supplierOrderList) {
            logger.info("supplier order status:{}", (Object)supplierOrder2.getOrderStatus());
            AbstractOrderCommand command = null;
            command = PurchaseOrderStatusEnum.BACK.getValue().equals(supplierOrder2.getOrderStatus()) ? new RefuseTheWholeOrderCommand(supplierOrder2) : new ConfirmTheWholeOrderCommand(supplierOrder2);
            command.setSupCompany(CompanyUtils.currentCompany());
            command.setSupUser((User)SpringSecurityUtils.getLoginUser());
            this.orderComandInvoker.invoke(command);
        }
        return ResponseResult.success();
    }

    @ApiOperation(value="\u9500\u552e\u8ba2\u5355\u6279\u91cf\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadExcel"})
    @ResponseBody
    public ModelAndView downloadExcel(String queryParams, HttpServletResponse response, @ApiParam(value="\u4ea4\u8d27\u662f\u5426\u5df2\u5b8c\u6210\u6807\u8bc6,Y\u5b8c\u6210", defaultValue="") @RequestParam(defaultValue="") String finishFlag) {
        try {
            SupplierOrderExample supplierOrderExample = new SupplierOrderExample();
            SupplierOrderExample.Criteria cri = supplierOrderExample.createCriteria();
            cri.andCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andProjectIdEqualTo(ProjectUtils.getProjectId());
            if (StringUtils.isNotBlank((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
                CriteriaUtils.addCriterion(cri, queryParamWapper);
            }
            List<SupplierOrderItem> list = null;
            list = StringUtils.isNotBlank((String)finishFlag) && finishFlag.equals("N") ? this.supplierOrderItemService.selectForExcelByOutstandingOrder(supplierOrderExample) : this.supplierOrderItemService.selectForExcel(supplierOrderExample);
            for (int i = 0; CollectionUtils.isNotEmpty(list) && i < list.size(); ++i) {
                SupplierOrderItem supplierOrderItem = list.get(i);
                BigDecimal quantity = supplierOrderItem.getQuantity();
                BigDecimal receivedQuantity = supplierOrderItem.getReceivedQuantity();
                BigDecimal noReceivedQuantity = BigDecimal.ZERO;
                if (supplierOrderItem.getQuantity() != null) {
                    noReceivedQuantity = supplierOrderItem.getReceivedQuantity() != null ? quantity.subtract(receivedQuantity) : supplierOrderItem.getQuantity();
                }
                supplierOrderItem.setNoReceivedQuantity(noReceivedQuantity);
                if (supplierOrderItem.getIsEnable() != null && supplierOrderItem.getIsEnable() == 2) {
                    supplierOrderItem.setFrozenFlag("\u5df2\u51bb\u7ed3");
                    continue;
                }
                supplierOrderItem.setFrozenFlag("\u672a\u51bb\u7ed3");
            }
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String companyShortName = CompanyUtils.currentCompany().getCompanyName();
            header.append("filename=\"" + URLEncoder.encode("\u534e\u9633-" + companyShortName + "PO\u660e\u7ec6.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, this.createExcelHeader(), list, (String)"\u9500\u552e\u8ba2\u5355", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            response.setStatus(417);
            logger.error("\u5bfc\u51fa\u4f9b\u5e94\u5546\u8ba2\u5355\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    private List<TitleAndModelKey> createExcelHeader() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u7801", (String)"companyCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5ba2\u6237\u540d\u79f0", (String)"purCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u8ba2\u5355\u53f7", (String)"orderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9879\u76ee", (String)"orderItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u54c1\u53f7", (String)"materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u54c1\u540d\u89c4\u683c", (String)"materialName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u6570\u91cf", (String)"quantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5df2\u4ea4\u6570\u91cf", (String)"receivedQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u672a\u4ea4\u6570\u91cf", (String)"noReceivedQuantity"));
        TitleAndModelKey titleAndModelKey = ExcelUtils.createTitleAndModelKey((String)"\u4ea4\u8d27\u65e5\u671f", (String)"deliveredDate");
        DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKey.setToObjConverter((StrToObjConverter)dateConverter);
        titleAndModelKey.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(titleAndModelKey);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u4f4d", (String)"orderUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u51c0\u4ef7", (String)"noTaxPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ef7\u683c\u5355\u4f4d", (String)"priceUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u91d1\u989d", (String)"nonTaxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e01\u79cd", (String)"currency"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7a0e\u7387", (String)"saleTaxCode"));
        TitleAndModelKey titleAndModelKey2 = ExcelUtils.createTitleAndModelKey((String)"\u51ed\u8bc1\u65e5\u671f", (String)"orderDate");
        DateConverter dateConverter2 = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKey2.setToObjConverter((StrToObjConverter)dateConverter2);
        titleAndModelKey2.setToStrConverter((ObjToStrConverter)dateConverter2);
        titleAndModelKeys.add(titleAndModelKey2);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u51bb\u7ed3\u6807\u8bc6", (String)"frozenFlag"));
        return titleAndModelKeys;
    }

    @ApiOperation(value="\u9500\u552e\u8ba2\u5355\u9009\u4e2d\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadExcelBySelect"})
    @ResponseBody
    public ModelAndView downloadExcelBySelect(@ApiParam(value="\u91c7\u8d2d\u8ba2\u5355\u53f7", defaultValue="") @RequestParam(defaultValue="") String orderNOList, @ApiParam(value="\u4ea4\u8d27\u662f\u5426\u5df2\u5b8c\u6210\u6807\u8bc6", defaultValue="") @RequestParam(defaultValue="") Integer deliveryStatus, @ApiParam(value="\u4ea4\u8d27\u662f\u5426\u5df2\u5b8c\u6210\u6807\u8bc6,Y\u5b8c\u6210", defaultValue="") @RequestParam(defaultValue="") String finishFlag, HttpServletResponse response) {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String companyShortName = CompanyUtils.currentCompany().getCompanyName();
            header.append("filename=\"" + URLEncoder.encode("\u534e\u9633-" + companyShortName + "PO\u660e\u7ec6.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            SupplierOrderExample example = new SupplierOrderExample();
            SupplierOrderExample.Criteria cri = example.createCriteria().andCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andProjectIdEqualTo(ProjectUtils.getProjectId());
            if (StringUtils.isNotBlank((String)orderNOList)) {
                cri.andOrderNoIn((List)Arrays.asList(orderNOList.split(",")));
            }
            if (deliveryStatus != null) {
                cri.andDeliveryStatusEqualTo(deliveryStatus);
            }
            List<SupplierOrderItem> listOrderItem = null;
            listOrderItem = StringUtils.isNotBlank((String)finishFlag) && finishFlag.equals("N") ? this.supplierOrderItemService.selectForExcelByOutstandingOrder(example) : this.supplierOrderItemService.selectForExcel(example);
            for (int i = 0; CollectionUtils.isNotEmpty(listOrderItem) && i < listOrderItem.size(); ++i) {
                SupplierOrderItem supplierOrderItem = listOrderItem.get(i);
                BigDecimal quantity = supplierOrderItem.getQuantity();
                BigDecimal receivedQuantity = supplierOrderItem.getReceivedQuantity();
                BigDecimal noReceivedQuantity = BigDecimal.ZERO;
                if (supplierOrderItem.getQuantity() != null) {
                    noReceivedQuantity = supplierOrderItem.getReceivedQuantity() != null ? quantity.subtract(receivedQuantity) : supplierOrderItem.getQuantity();
                }
                supplierOrderItem.setNoReceivedQuantity(noReceivedQuantity);
                if (supplierOrderItem.getIsEnable() != null && supplierOrderItem.getIsEnable() == 2) {
                    supplierOrderItem.setFrozenFlag("\u5df2\u51bb\u7ed3");
                    continue;
                }
                supplierOrderItem.setFrozenFlag("\u672a\u51bb\u7ed3");
            }
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, this.createExcelHeader(), listOrderItem, (String)"\u9500\u552e\u8ba2\u5355", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }
}

