/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.adjust.command;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.mould.adjust.entity.MouldAdjustMaterial;
import com.els.base.mould.adjust.util.ChangeTypeEnum;
import com.els.base.mould.adjust.vo.AdjustDetailVo;
import com.els.base.mould.adjust.vo.AdjustVo;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ModifyMouldAdjustCmd
extends AbstractMouldCommand<String> {
    private AdjustVo adjustVo;

    public ModifyMouldAdjustCmd(AdjustVo adjustVo) {
        this.adjustVo = adjustVo;
    }

    @Override
    public String execute(MouldInvorker mouldInvorker) {
        List<MouldAdjustMaterial> moudlAdjustMaterialList;
        this.verification(this.adjustVo);
        this.completeMouldAdjust(this.adjustVo, mouldInvorker);
        mouldInvorker.getMouldAdjustDetailService().deleteByAdjustId(this.adjustVo.getId());
        List<AdjustDetailVo> adjustVoList = this.adjustVo.getMouldAdjustDetailList();
        for (AdjustDetailVo adjustDetailVo : adjustVoList) {
            mouldInvorker.getMouldAdjustDetailService().addObj(adjustDetailVo);
            moudlAdjustMaterialList = adjustDetailVo.getMouldAdjustMaterialList();
            for (MouldAdjustMaterial mouldAdjustMaterial : moudlAdjustMaterialList) {
                mouldInvorker.getMouldAdjustMaterialService().addObj(mouldAdjustMaterial);
            }
        }
        if (this.adjustVo.getChangeType().equals(ChangeTypeEnum.Change_Sup.getValue())) {
            mouldInvorker.getMouldAdjustService().modifyObj(this.adjustVo);
        }
        if (this.adjustVo.getChangeType().equals(ChangeTypeEnum.Life_adjustment.getValue())) {
            mouldInvorker.getMouldAdjustService().modifyObj(this.adjustVo);
        }
        if (this.adjustVo.getChangeType().equals(ChangeTypeEnum.Opening_Stroke.getValue())) {
            for (AdjustDetailVo adjustDetailVo : adjustVoList) {
                mouldInvorker.getMouldAdjustMaterialService().deleteByDetailId(adjustDetailVo.getId());
                moudlAdjustMaterialList = adjustDetailVo.getMouldAdjustMaterialList();
                for (MouldAdjustMaterial mouldAdjustMaterial : moudlAdjustMaterialList) {
                    mouldInvorker.getMouldAdjustMaterialService().addObj(mouldAdjustMaterial);
                }
            }
            mouldInvorker.getMouldAdjustService().modifyObj(this.adjustVo);
        }
        return null;
    }

    private void completeMouldAdjust(AdjustVo vo, MouldInvorker mouldInvorker) {
        vo.setPurUserId(this.getPurUser().getId());
        vo.setUpdateTime(new Date());
        for (AdjustDetailVo adjustDetailVo : vo.getMouldAdjustDetailList()) {
            adjustDetailVo.setId(UUIDGenerator.generateUUID());
            adjustDetailVo.setAdjustId(vo.getId());
            adjustDetailVo.setCreateTime(new Date());
            for (MouldAdjustMaterial mouldAdjustMaterial : adjustDetailVo.getMouldAdjustMaterialList()) {
                mouldAdjustMaterial.setId(UUIDGenerator.generateUUID());
                mouldAdjustMaterial.setAdjustId(vo.getId());
                mouldAdjustMaterial.setAdjustDetailId(adjustDetailVo.getId());
                mouldAdjustMaterial.setCreateTime(new Date());
            }
        }
    }

    private void verification(AdjustVo vo) {
        Assert.isNotNull(vo, "\u63d0\u4ea4\u7684\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u4fee\u6539\u5355\u636e!");
        Assert.isNotBlank(vo.getSupCompanyId(), "\u63d0\u4ea4\u7684\u4f9b\u5e94\u5546id\u4e3a\u7a7a,\u65e0\u6cd5\u4fee\u6539\u5355\u636e!");
        Assert.isNotBlank(vo.getSupCompanySrmCode(), "\u63d0\u4ea4\u7684\u4f9b\u5e94\u5546SRM\u7f16\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u4fee\u6539\u5355\u636e!");
        Assert.isNotBlank(vo.getSupCompanySapCode(), "\u63d0\u4ea4\u7684\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u4fee\u6539\u5355\u636e!");
        Assert.isNotBlank(vo.getSupCompanyName(), "\u63d0\u4ea4\u7684\u4f9b\u5e94\u5546\u7b80\u79f0\u4e3a\u7a7a,\u65e0\u6cd5\u4fee\u6539\u5355\u636e!");
        Assert.isNotBlank(vo.getSupCompanyFullName(), "\u63d0\u4ea4\u7684\u4f9b\u5e94\u5546\u5168\u79f0\u4e3a\u7a7a,\u65e0\u6cd5\u4fee\u6539\u5355\u636e!");
        Assert.isNotNull(vo.getChangeType(), "\u63d0\u4ea4\u7684\u53d8\u66f4\u7c7b\u578b\u4e3a\u7a7a,\u65e0\u6cd5\u4fee\u6539\u5355\u636e!");
        if (CollectionUtils.isEmpty(vo.getMouldAdjustDetailList())) {
            throw new CommonException("\u63d0\u4ea4\u7684\u6a21\u5177\u4fe1\u606f\u4e3a\u7a7a,\u65e0\u6cd5\u4fee\u6539\u5355\u636e!");
        }
        for (AdjustDetailVo detail : vo.getMouldAdjustDetailList()) {
            Assert.isNotBlank(detail.getMouldId(), "\u63d0\u4ea4\u7684\u6a21\u5177ID\u4e3a\u7a7a,\u65e0\u6cd5\u4fee\u6539\u5355\u636e!");
            Assert.isNotBlank(detail.getMouldCode(), "\u63d0\u4ea4\u7684\u6a21\u5177\u7f16\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u4fee\u6539\u5355\u636e!");
            Assert.isNotBlank(detail.getMouldDesc(), "\u63d0\u4ea4\u7684\u6a21\u5177\u63cf\u8ff0\u4e3a\u7a7a,\u65e0\u6cd5\u4fee\u6539\u5355\u636e!");
            Assert.isNotNull(detail.getMouldPrimaryLifetime(), "\u63d0\u4ea4\u7684\u6a21\u5177\u539f\u5bff\u547d\u4e3a\u7a7a,\u65e0\u6cd5\u4fee\u6539\u5355\u636e!");
            if (CollectionUtils.isEmpty(detail.getMouldAdjustMaterialList())) {
                throw new CommonException("\u63d0\u4ea4\u7684\u7269\u6599\u4fe1\u606f\u4e3a\u7a7a,\u65e0\u6cd5\u4fee\u6539\u5355\u636e!");
            }
            for (MouldAdjustMaterial mouldAdjustMaterial : detail.getMouldAdjustMaterialList()) {
                Assert.isNotBlank(mouldAdjustMaterial.getMaterialCode(), "\u8c03\u6574\u5355\u660e\u7ec6\u91cc\u7684\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isNotNull(mouldAdjustMaterial.getIsCalculated(), "\u8c03\u6574\u5355\u660e\u7ec6\u91cc\u7684\u7269\u6599\u662f\u5426\u6838\u7b97\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isNotNull(mouldAdjustMaterial.getProductMouldQuantity(), "\u8c03\u6574\u5355\u660e\u7ec6\u91cc\u7684\u51fa\u6a21\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

